/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5crm.server.workflow;

import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5crm.api.oppo.payload.OpportunityCostEstimatePayload;
import com.elitesland.tw.tw5crm.api.oppo.vo.OpportunityCostEstimateVO;
import com.elitesland.tw.tw5crm.server.oppo.dao.OpportunityCostEstimateDAO;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rpc/workflow/OPPO_ESTIMATE/callBack"})
@Transactional
public class OpportunityCostEstimateWorkflowController
implements WorkflowCallBack {
    private static final Logger log = LoggerFactory.getLogger(OpportunityCostEstimateWorkflowController.class);
    private final OpportunityCostEstimateDAO opportunityCostEstimateDAO;

    @PostMapping(value={"/taskAssignee"})
    public ArrayList<String> taskAssignee(@RequestBody TaskAssigneePayload payload) {
        log.info("\u52a8\u6001\u6307\u5b9a\u4efb\u52a1\u8d1f\u8d23\u4eba\u53c2\u6570: {}", (Object)payload);
        return null;
    }

    @PostMapping(value={"/taskCreated"})
    public void taskCreated(@RequestBody TaskCreatedPayload payload) {
        log.info("\u4efb\u52a1\u521b\u5efa\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
    }

    @PostMapping(value={"/taskCompleted"})
    public void taskCompleted(@RequestBody TaskCompletedPayload payload) {
        log.info("\u4efb\u52a1\u5b8c\u6210\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
    }

    @PostMapping(value={"/processStatusChange"})
    @Transactional
    public void processStatusChange(@RequestBody ProcessStatusChangePayload payload) {
        log.info("\u6d41\u7a0b\u72b6\u6001\u53d8\u5316\u56de\u8c03\u53c2\u6570:{}", (Object)payload);
        String businessKey = payload.getBusinessKey();
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        OpportunityCostEstimatePayload updatePayload = new OpportunityCostEstimatePayload();
        long id = Long.parseLong(businessKey);
        updatePayload.setId(Long.valueOf(id));
        OpportunityCostEstimateVO opportunityCostEstimateVO = this.opportunityCostEstimateDAO.queryByKey(Long.valueOf(businessKey));
        if (opportunityCostEstimateVO != null) {
            boolean deleteFlag = false;
            switch (procInstStatus) {
                case NOTSUBMIT: {
                    updatePayload.setApprStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
                    updatePayload.setProcInstStatus(ProcInstStatus.NOTSUBMIT);
                    break;
                }
                case INTERRUPT: {
                    updatePayload.setApprStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
                    break;
                }
                case INVALID: {
                    updatePayload.setApprStatus(WorkFlowStatusEnum.INVALID.getCode());
                    updatePayload.setProcInstStatus(ProcInstStatus.INVALID);
                    deleteFlag = true;
                    break;
                }
                case REJECTED: {
                    updatePayload.setApprStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
                    updatePayload.setProcInstStatus(ProcInstStatus.REJECTED);
                    break;
                }
                case APPROVED: {
                    updatePayload.setApprStatus(WorkFlowStatusEnum.APPROVED_WORK.getCode());
                    updatePayload.setProcInstStatus(ProcInstStatus.APPROVED);
                    updatePayload.setApprovedTime(LocalDateTime.now());
                    break;
                }
            }
            this.opportunityCostEstimateDAO.updateWorkFlow(updatePayload);
            if (deleteFlag) {
                this.opportunityCostEstimateDAO.deleteSoft(Arrays.asList(id));
            }
        }
    }

    public OpportunityCostEstimateWorkflowController(OpportunityCostEstimateDAO opportunityCostEstimateDAO) {
        this.opportunityCostEstimateDAO = opportunityCostEstimateDAO;
    }
}

