/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5pms.server.my.controller;

import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import com.elitesland.tw.tw5pms.api.my.payload.TimesheetPlanListPayload;
import com.elitesland.tw.tw5pms.api.my.payload.TimesheetPlanPayload;
import com.elitesland.tw.tw5pms.api.my.query.TimesheetPlanQuery;
import com.elitesland.tw.tw5pms.api.my.service.TimesheetPlanService;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/pms/timesheetPlan"})
public class TimesheetPlanController {
    private static final Logger log = LoggerFactory.getLogger(TimesheetPlanController.class);
    private final TimesheetPlanService timesheetPlanService;

    @PostMapping
    public TwOutputUtil insert(@RequestBody TimesheetPlanPayload payload) {
        return TwOutputUtil.ok((Object)this.timesheetPlanService.insert(payload));
    }

    @PostMapping(value={"/batchInsert"})
    public TwOutputUtil batchInsert(@RequestBody TimesheetPlanListPayload payload) {
        return TwOutputUtil.ok((Object)this.timesheetPlanService.batchInsert(payload));
    }

    @PostMapping(value={"/copyLastWeek"})
    public TwOutputUtil copyLastWeek(String date) {
        return TwOutputUtil.ok((Object)this.timesheetPlanService.copyLastWeek(date));
    }

    @PutMapping
    public TwOutputUtil update(@RequestBody TimesheetPlanPayload payload) {
        return TwOutputUtil.ok((Object)this.timesheetPlanService.update(payload));
    }

    @GetMapping(value={"/{key}"})
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok((Object)this.timesheetPlanService.queryByKey(key));
    }

    @GetMapping(value={"/paging"})
    @UdcNameClass
    public TwOutputUtil paging(TimesheetPlanQuery query) {
        query.setCreateUserId(GlobalUtil.getLoginUserId());
        return TwOutputUtil.ok((Object)this.timesheetPlanService.paging(query));
    }

    @GetMapping(value={"/list"})
    @UdcNameClass
    public TwOutputUtil queryList(TimesheetPlanQuery query) {
        query.setCreateUserId(GlobalUtil.getLoginUserId());
        return TwOutputUtil.ok((Object)this.timesheetPlanService.queryList(query));
    }

    @DeleteMapping(value={"/deleteSoft"})
    public TwOutputUtil deleteSoft(Long[] keys) {
        this.timesheetPlanService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    public TimesheetPlanController(TimesheetPlanService timesheetPlanService) {
        this.timesheetPlanService = timesheetPlanService;
    }
}

