/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5pms.server.my.service;

import cn.hutool.core.bean.BeanUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.util.DateUtil;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5pms.api.my.payload.TimesheetPlanListPayload;
import com.elitesland.tw.tw5pms.api.my.payload.TimesheetPlanPayload;
import com.elitesland.tw.tw5pms.api.my.query.TimesheetBiweeklyQuery;
import com.elitesland.tw.tw5pms.api.my.query.TimesheetPlanQuery;
import com.elitesland.tw.tw5pms.api.my.service.TimesheetPlanService;
import com.elitesland.tw.tw5pms.api.my.vo.TimesheetPlanVO;
import com.elitesland.tw.tw5pms.api.project.service.PmsProjectService;
import com.elitesland.tw.tw5pms.api.project.service.PmsProjectTeamBaseService;
import com.elitesland.tw.tw5pms.api.project.service.PmsProjectTeamMemberService;
import com.elitesland.tw.tw5pms.api.project.vo.PmsProjectVO;
import com.elitesland.tw.tw5pms.api.task.service.PmsTaskService;
import com.elitesland.tw.tw5pms.api.task.vo.PmsTaskVO;
import com.elitesland.tw.tw5pms.server.my.convert.TimesheetPlanConvert;
import com.elitesland.tw.tw5pms.server.my.entity.QTimesheetPlanDO;
import com.elitesland.tw.tw5pms.server.my.entity.TimesheetPlanDO;
import com.elitesland.tw.tw5pms.server.my.repo.TimesheetBiweeklyReadFlagRepo;
import com.elitesland.tw.tw5pms.server.my.repo.TimesheetBiweeklyRepo;
import com.elitesland.tw.tw5pms.server.my.repo.TimesheetPlanRepo;
import com.elitesland.tw.tw5pms.server.project.dao.PmsProjectWbsDAO;
import com.elitesland.tw.tw5pms.server.task.dao.PmsTaskDAO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Root;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class TimesheetPlanServiceImpl
implements TimesheetPlanService {
    private static final Logger log = LoggerFactory.getLogger(TimesheetPlanServiceImpl.class);
    private final TimesheetPlanRepo timesheetPlanRepo;
    private final PmsProjectService projectService;
    private final PmsTaskDAO taskDAO;
    private final PmsTaskService taskService;
    private final PmsProjectWbsDAO pmsProjectWbsDAO;
    private final JPAQueryFactory jpaQueryFactory;
    private final CacheUtil cacheUtil;
    private final TimesheetBiweeklyRepo timesheetBiweeklyRepo;
    private final PmsProjectTeamMemberService pmsProjectTeamMemberService;
    private final TimesheetBiweeklyReadFlagRepo biweeklyReadFlagRepo;
    private final PmsProjectTeamBaseService pmsProjectTeamBaseService;

    public PagingVO<TimesheetPlanVO> paging(TimesheetPlanQuery query) {
        Page page = this.timesheetPlanRepo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate((Root)root, (Object)query, (CriteriaBuilder)criteriaBuilder), (Pageable)query.getPageRequest());
        return PageUtil.toPageVo((Page)page.map(TimesheetPlanConvert.INSTANCE::toVo));
    }

    public List<TimesheetPlanVO> queryList(TimesheetPlanQuery query) {
        return TimesheetPlanConvert.INSTANCE.toVoList(this.timesheetPlanRepo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate((Root)root, (Object)query, (CriteriaBuilder)criteriaBuilder)));
    }

    private List<TimesheetPlanDO> queryDoList(TimesheetPlanQuery query) {
        return this.timesheetPlanRepo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate((Root)root, (Object)query, (CriteriaBuilder)criteriaBuilder));
    }

    public TimesheetPlanVO queryByKey(Long key) {
        TimesheetPlanDO entity = this.timesheetPlanRepo.findById(key).orElseGet(TimesheetPlanDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        TimesheetPlanVO vo = TimesheetPlanConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public TimesheetPlanVO insert(TimesheetPlanPayload payload) {
        payload.setCreateUserId(GlobalUtil.getLoginUserId());
        this.check(payload);
        this.dataProcess(payload);
        this.biweeklyReadFlagRepo.updateReadFlag(payload.getCreateUserId(), 0);
        TimesheetPlanDO entityDo = TimesheetPlanConvert.INSTANCE.toDo(payload);
        return TimesheetPlanConvert.INSTANCE.toVo((TimesheetPlanDO)((Object)this.timesheetPlanRepo.save((Object)entityDo)));
    }

    private void check(TimesheetPlanPayload payload) {
        LocalDate workDate = payload.getWorkDate();
        if (workDate.isBefore(LocalDate.now()) && (payload.getExt5() == null || !payload.getExt5().equals("EMPTY"))) {
            throw TwException.error((String)"", (String)"\u53ea\u5141\u8bb8\u63d0\u4ea4\u4eca\u5929\u53ca\u4ee5\u540e\u7684\u8ba1\u5212\uff01");
        }
        if (null == payload.getProjId()) {
            throw TwException.error((String)"", (String)"\u53c2\u6570\u5f02\u5e38\uff1aprojId");
        }
        if (null == payload.getTaskId()) {
            throw TwException.error((String)"", (String)"\u53c2\u6570\u5f02\u5e38\uff1ataskId");
        }
    }

    private void dataProcess(TimesheetPlanPayload payload) {
        if (payload.getWorkDate() != null) {
            payload.setYearWeek(Integer.valueOf(Integer.parseInt(DateUtil.getYearWeek((LocalDate)payload.getWorkDate()))));
            payload.setWeekStartDate(DateUtil.getStartWeekDay((LocalDate)payload.getWorkDate()));
        }
        if (null != payload.getProjId()) {
            PmsProjectVO projectVO = this.projectService.queryByKey(payload.getProjId());
            if (!StringUtils.hasText((String)payload.getProjNo())) {
                payload.setProjNo(null != projectVO ? projectVO.getProjectCode() : "");
            }
            if (!StringUtils.hasText((String)payload.getProjName())) {
                payload.setProjName(null != projectVO ? projectVO.getProjectName() : "");
            }
        }
        if (null != payload.getTaskId()) {
            PmsTaskVO taskVO = this.taskDAO.queryByKey(payload.getTaskId());
            if (!StringUtils.hasText((String)payload.getTaskNo())) {
                payload.setTaskNo(null != taskVO ? taskVO.getTaskCode() : "");
            }
            if (!StringUtils.hasText((String)payload.getTaskName())) {
                payload.setTaskName(null != taskVO ? taskVO.getTaskName() : "");
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public TimesheetPlanVO update(TimesheetPlanPayload payload) {
        TimesheetPlanDO entity = this.timesheetPlanRepo.findById(payload.getId()).orElseGet(TimesheetPlanDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        this.dataProcess(payload);
        TimesheetPlanDO entityDo = TimesheetPlanConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return TimesheetPlanConvert.INSTANCE.toVo((TimesheetPlanDO)((Object)this.timesheetPlanRepo.save((Object)entity)));
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional optional = this.timesheetPlanRepo.findById(id);
                if (!optional.isEmpty()) {
                    TimesheetPlanDO entity = (TimesheetPlanDO)((Object)((Object)optional.get()));
                    TimesheetBiweeklyQuery timesheetBiweeklyQuery = new TimesheetBiweeklyQuery();
                    timesheetBiweeklyQuery.setYearWeek(entity.getYearWeek());
                    timesheetBiweeklyQuery.setCreateUserId(entity.getCreateUserId());
                    Long count = this.timesheetBiweeklyRepo.count((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate((Root)root, (Object)timesheetBiweeklyQuery, (CriteriaBuilder)criteriaBuilder));
                    if (count > 0L) {
                        throw TwException.error((String)"", (String)"\u5ba1\u6279\u4e2d\u7684\u6570\u636e\u4e0d\u53ef\u4ee5\u5220\u9664");
                    }
                    entity.setDeleteFlag(1);
                    this.timesheetPlanRepo.save((Object)entity);
                }
            });
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoftByYearWeek(Integer yeerWeek, Long loginUserId) {
        if (null != yeerWeek) {
            LocalDateTime now = LocalDateTime.now();
            QTimesheetPlanDO qTimesheetPlanDO = QTimesheetPlanDO.timesheetPlanDO;
            JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)qTimesheetPlanDO).set(qTimesheetPlanDO.deleteFlag, (Object)1).set((Path)qTimesheetPlanDO.updater, (Object)GlobalUtil.getLoginUserName()).set(qTimesheetPlanDO.modifyTime, (Object)now).where(new Predicate[]{qTimesheetPlanDO.yearWeek.eq((Object)yeerWeek)}).where(new Predicate[]{qTimesheetPlanDO.createUserId.eq((Object)loginUserId)});
            update.execute();
        }
    }

    public List<TimesheetPlanVO> batchInsert(TimesheetPlanListPayload payload) {
        ArrayList<TimesheetPlanVO> list = new ArrayList<TimesheetPlanVO>();
        List timesheetPlanList = payload.getTimesheetPlanList();
        if (!CollectionUtils.isEmpty((Collection)timesheetPlanList)) {
            timesheetPlanList.forEach(timesheetPlanPayload -> list.add(this.insert((TimesheetPlanPayload)timesheetPlanPayload)));
        }
        return list;
    }

    @Transactional(rollbackFor={Exception.class})
    public List<TimesheetPlanVO> copyLastWeek(String date) {
        LocalDate localDate = LocalDate.now();
        if (StringUtils.hasText((String)date)) {
            localDate = LocalDate.parse(date);
        }
        LocalDate lastWeekDate = localDate.plusDays(-7L);
        int yearWeek = Integer.parseInt(DateUtil.getYearWeek((LocalDate)localDate));
        String lastYearWeek = DateUtil.getYearWeek((LocalDate)lastWeekDate);
        TimesheetPlanQuery timesheetPlanQuery = new TimesheetPlanQuery();
        timesheetPlanQuery.setYearWeek(Integer.valueOf(Integer.parseInt(lastYearWeek)));
        Long loginUserId = GlobalUtil.getLoginUserId();
        timesheetPlanQuery.setCreateUserId(loginUserId);
        List<TimesheetPlanDO> timesheetPlanDOS = this.queryDoList(timesheetPlanQuery);
        TimesheetBiweeklyQuery timesheetBiweeklyQuery = new TimesheetBiweeklyQuery();
        timesheetBiweeklyQuery.setYearWeek(Integer.valueOf(yearWeek));
        timesheetBiweeklyQuery.setCreateUserId(loginUserId);
        Long count = this.timesheetBiweeklyRepo.count((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate((Root)root, (Object)timesheetBiweeklyQuery, (CriteriaBuilder)criteriaBuilder));
        if (count > 0L) {
            throw TwException.error((String)"", (String)"\u5de5\u4f5c\u8ba1\u5212\u63d0\u4ea4\u540e\u4e0d\u53ef\u4fee\u6539");
        }
        this.deleteSoftByYearWeek(yearWeek, loginUserId);
        ArrayList<TimesheetPlanVO> result = new ArrayList<TimesheetPlanVO>();
        if (!CollectionUtils.isEmpty(timesheetPlanDOS)) {
            timesheetPlanDOS.forEach(timesheetPlanDO -> {
                TimesheetPlanDO entity = new TimesheetPlanDO();
                BeanUtil.copyProperties((Object)timesheetPlanDO, (Object)((Object)entity), (String[])new String[0]);
                entity.setId(null);
                entity.setCreateTime(LocalDateTime.now());
                entity.setCreator(GlobalUtil.getLoginUserName());
                entity.setCreateUserId(loginUserId);
                entity.setModifyTime(LocalDateTime.now());
                entity.setModifyUserId(loginUserId);
                entity.setUpdater(GlobalUtil.getLoginUserName());
                LocalDate workDate = timesheetPlanDO.getWorkDate();
                if (null != workDate) {
                    LocalDate nextWeekWorkDate = workDate.plusDays(7L);
                    entity.setWorkDate(nextWeekWorkDate);
                    entity.setYearWeek(Integer.parseInt(DateUtil.getYearWeek((LocalDate)nextWeekWorkDate)));
                }
                TimesheetPlanDO save = (TimesheetPlanDO)((Object)((Object)this.timesheetPlanRepo.save((Object)entity)));
                result.add(TimesheetPlanConvert.INSTANCE.toVo(save));
            });
        }
        return result;
    }

    public TimesheetPlanServiceImpl(TimesheetPlanRepo timesheetPlanRepo, PmsProjectService projectService, PmsTaskDAO taskDAO, PmsTaskService taskService, PmsProjectWbsDAO pmsProjectWbsDAO, JPAQueryFactory jpaQueryFactory, CacheUtil cacheUtil, TimesheetBiweeklyRepo timesheetBiweeklyRepo, PmsProjectTeamMemberService pmsProjectTeamMemberService, TimesheetBiweeklyReadFlagRepo biweeklyReadFlagRepo, PmsProjectTeamBaseService pmsProjectTeamBaseService) {
        this.timesheetPlanRepo = timesheetPlanRepo;
        this.projectService = projectService;
        this.taskDAO = taskDAO;
        this.taskService = taskService;
        this.pmsProjectWbsDAO = pmsProjectWbsDAO;
        this.jpaQueryFactory = jpaQueryFactory;
        this.cacheUtil = cacheUtil;
        this.timesheetBiweeklyRepo = timesheetBiweeklyRepo;
        this.pmsProjectTeamMemberService = pmsProjectTeamMemberService;
        this.biweeklyReadFlagRepo = biweeklyReadFlagRepo;
        this.pmsProjectTeamBaseService = pmsProjectTeamBaseService;
    }
}

