/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5pms.server.project.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.QBaseModel;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5pms.api.project.payload.PmsBudgetAppropriatePayload;
import com.elitesland.tw.tw5pms.api.project.query.PmsBudgetAppropriateQuery;
import com.elitesland.tw.tw5pms.api.project.vo.PmsBudgetAppropriateVO;
import com.elitesland.tw.tw5pms.server.project.entity.PmsBudgetAppropriateDO;
import com.elitesland.tw.tw5pms.server.project.entity.QPmsBudgetAppropriateDO;
import com.elitesland.tw.tw5pms.server.project.repo.PmsBudgetAppropriateRepo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Repository
public class PmsBudgetAppropriateDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final PmsBudgetAppropriateRepo repo;
    private final QPmsBudgetAppropriateDO qdo = QPmsBudgetAppropriateDO.pmsBudgetAppropriateDO;

    private JPAQuery<PmsBudgetAppropriateVO> getJpaQuerySelect() {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PmsBudgetAppropriateVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.remark, this.qdo.createUserId, this.qdo.creator, this.qdo.createTime, this.qdo.appropriationCode, this.qdo.appropriationAmount, this.qdo.submitTime, this.qdo.projectId, this.qdo.procInstId, this.qdo.procInstStatus, this.qdo.approvedTime, this.qdo.procInstStatus, this.qdo.appropriationStatus, this.qdo.paidMoney, this.qdo.usedMoney, this.qdo.totalMoney, this.qdo.appropriationProportion})).from((EntityPath)this.qdo);
    }

    private JPAQuery<PmsBudgetAppropriateVO> getJpaQueryWhere(PmsBudgetAppropriateQuery query) {
        JPAQuery<PmsBudgetAppropriateVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, (QBaseModel)this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn((EntityPathBase)this.qdo, (List)query.getOrders()));
        return jpaQuery;
    }

    public List<PmsBudgetAppropriateVO> queryByProjectId(Long projectId, ProcInstStatus procInstStatus) {
        JPAQuery<PmsBudgetAppropriateVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.projectId.eq((Object)projectId));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        jpaQuery.where((Predicate)this.qdo.procInstStatus.eq((Object)procInstStatus));
        return jpaQuery.fetch();
    }

    public long count(PmsBudgetAppropriateQuery query) {
        long total = (Long)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.count()).from((EntityPath)this.qdo)).where(this.where(query))).fetchOne();
        return total;
    }

    private Predicate where(PmsBudgetAppropriateQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (!ObjectUtils.isEmpty((Object)query.getProjectId())) {
            list.add(this.qdo.projectId.eq((Object)query.getProjectId()));
        }
        return ExpressionUtils.allOf(list);
    }

    public PmsBudgetAppropriateVO queryByKey(Long id) {
        JPAQuery<PmsBudgetAppropriateVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (PmsBudgetAppropriateVO)jpaQuery.fetchFirst();
    }

    public PmsBudgetAppropriateVO queryByProcInstId(String procInstId) {
        JPAQuery<PmsBudgetAppropriateVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.procInstId.eq((Object)procInstId));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (PmsBudgetAppropriateVO)jpaQuery.fetchFirst();
    }

    public List<PmsBudgetAppropriateVO> queryListDynamic(PmsBudgetAppropriateQuery query) {
        JPAQuery<PmsBudgetAppropriateVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public PagingVO<PmsBudgetAppropriateVO> queryPaging(PmsBudgetAppropriateQuery query) {
        long total = this.count(query);
        if (total == 0L) {
            return PagingVO.empty();
        }
        JPAQuery<PmsBudgetAppropriateVO> jpaQuery = this.getJpaQueryWhere(query);
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        return PagingVO.builder().records(result).total(total).build();
    }

    public PmsBudgetAppropriateDO save(PmsBudgetAppropriateDO ado) {
        return (PmsBudgetAppropriateDO)this.repo.save(ado);
    }

    public List<PmsBudgetAppropriateDO> saveAll(List<PmsBudgetAppropriateDO> dos) {
        return this.repo.saveAll(dos);
    }

    @Transactional
    public long updateByKeyDynamic(PmsBudgetAppropriatePayload payload) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        List nullFields = payload.getNullFields();
        if (nullFields == null || nullFields.size() > 0) {
            // empty if block
        }
        SqlUtil.updateCommonJpaQuery((JPAUpdateClause)update, (QBaseModel)this.qdo._super);
        return update.execute();
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        SqlUtil.updateCommonJpaQuery((JPAUpdateClause)update, (QBaseModel)this.qdo._super);
        return update.execute();
    }

    public long updateWorkFlow(PmsBudgetAppropriatePayload payload) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (!ObjectUtils.isEmpty((Object)payload.getProcInstId())) {
            update.set((Path)this.qdo.procInstId, (Object)payload.getProcInstId());
        }
        if (!ObjectUtils.isEmpty((Object)payload.getProcInstStatus())) {
            update.set(this.qdo.procInstStatus, (Object)payload.getProcInstStatus());
        }
        if (!ObjectUtils.isEmpty((Object)payload.getAppropriationStatus())) {
            update.set((Path)this.qdo.appropriationStatus, (Object)payload.getAppropriationStatus());
        }
        if (!ObjectUtils.isEmpty((Object)payload.getSubmitTime())) {
            update.set(this.qdo.submitTime, (Object)payload.getSubmitTime());
        }
        if (!ObjectUtils.isEmpty((Object)payload.getApprovedTime())) {
            update.set(this.qdo.approvedTime, (Object)payload.getApprovedTime());
        }
        if (!ObjectUtils.isEmpty((Object)payload.getDeleteFlag())) {
            update.set(this.qdo.deleteFlag, (Object)payload.getDeleteFlag());
        }
        if (!ObjectUtils.isEmpty((Object)payload.getTotalMoney())) {
            update.set(this.qdo.totalMoney, (Object)payload.getTotalMoney());
        }
        if (!ObjectUtils.isEmpty((Object)payload.getUsedMoney())) {
            update.set(this.qdo.usedMoney, (Object)payload.getUsedMoney());
        }
        if (!ObjectUtils.isEmpty((Object)payload.getPaidMoney())) {
            update.set(this.qdo.paidMoney, (Object)payload.getPaidMoney());
        }
        if (!ObjectUtils.isEmpty((Object)payload.getAppropriationProportion())) {
            update.set(this.qdo.appropriationProportion, (Object)payload.getAppropriationProportion());
        }
        SqlUtil.updateCommonJpaQuery((JPAUpdateClause)update, (QBaseModel)this.qdo._super);
        return update.execute();
    }

    public PmsBudgetAppropriateDAO(JPAQueryFactory jpaQueryFactory, PmsBudgetAppropriateRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

