/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5pms.server.project.dao;

import com.elitescloud.cloudt.common.base.QBaseModel;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5pms.api.project.query.PmsProjectWbsQuery;
import com.elitesland.tw.tw5pms.api.project.vo.PmsProjectWbsVO;
import com.elitesland.tw.tw5pms.server.project.entity.PmsProjectWbsDO;
import com.elitesland.tw.tw5pms.server.project.entity.QPmsProjectWbsDO;
import com.elitesland.tw.tw5pms.server.project.repo.PmsProjectWbsRepo;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.util.ObjectUtils;

@Repository
public class PmsProjectWbsDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final PmsProjectWbsRepo repo;
    private final QPmsProjectWbsDO qdo = QPmsProjectWbsDO.pmsProjectWbsDO;

    private JPAQuery<PmsProjectWbsVO> getJpaQuerySelect() {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PmsProjectWbsVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.remark, this.qdo.createUserId, this.qdo.creator, this.qdo.createTime, this.qdo.modifyUserId, this.qdo.updater, this.qdo.modifyTime, this.qdo.projectId, this.qdo.parentId, this.qdo.wbsName, this.qdo.wbsType, this.qdo.wbsCode, this.qdo.nodeCode, this.qdo.parentWbsCode, this.qdo.wbsStatus, this.qdo.managerUserId, this.qdo.subjectDist, this.qdo.startDate, this.qdo.endDate, this.qdo.preStartDate, this.qdo.preEndDate, this.qdo.preDurationDay, this.qdo.wbsProgress, this.qdo.durationDay, this.qdo.costType, this.qdo.relyIds, this.qdo.relyNames, this.qdo.relyType, this.qdo.relyDay, this.qdo.invoiceAttr, this.qdo.costPlan})).from((EntityPath)this.qdo);
    }

    private JPAQuery<PmsProjectWbsVO> getJpaQueryWhere(PmsProjectWbsQuery query) {
        JPAQuery<PmsProjectWbsVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, (QBaseModel)this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn((EntityPathBase)this.qdo, (List)query.getOrders()));
        return jpaQuery;
    }

    private Predicate where(PmsProjectWbsQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (!ObjectUtils.isEmpty((Object)query.getProjectId())) {
            list.add(this.qdo.projectId.eq((Object)query.getProjectId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getWbsSearch())) {
            list.add(this.qdo.wbsName.like(SqlUtil.toSqlLikeString((String)query.getWbsSearch())).or((Predicate)this.qdo.nodeCode.like(SqlUtil.toSqlLikeString((String)query.getWbsSearch()))));
        }
        if (!ObjectUtils.isEmpty((Object)query.getWbsName())) {
            list.add(this.qdo.wbsName.like(SqlUtil.toSqlLikeString((String)query.getWbsName())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getWbsType())) {
            list.add(this.qdo.wbsType.eq((Object)query.getWbsType()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getWbsCode())) {
            list.add(this.qdo.wbsCode.like(SqlUtil.toSqlLikeString((String)query.getWbsCode())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getNodeCode())) {
            list.add(this.qdo.nodeCode.eq((Object)query.getNodeCode()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getParentWbsCode())) {
            list.add(this.qdo.parentWbsCode.eq((Object)query.getParentWbsCode()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCostPlan())) {
            list.add(this.qdo.costPlan.eq((Object)query.getCostPlan()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSubjectDist())) {
            list.add(this.qdo.subjectDist.eq((Object)query.getSubjectDist()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getInvoiceAttr())) {
            list.add(this.qdo.invoiceAttr.eq((Object)query.getInvoiceAttr()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getDurationDay())) {
            list.add(this.qdo.durationDay.eq((Object)query.getDurationDay()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCostType())) {
            list.add(this.qdo.costType.eq((Object)query.getCostType()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getStartDate())) {
            list.add(this.qdo.startDate.eq((Object)query.getStartDate()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getEndDate())) {
            list.add(this.qdo.endDate.eq((Object)query.getEndDate()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPreStartDate())) {
            list.add(this.qdo.preStartDate.goe((Comparable)query.getPreStartDate()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPreEndDate())) {
            list.add(this.qdo.preEndDate.loe((Comparable)query.getPreEndDate()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPreDurationDay())) {
            list.add(this.qdo.preDurationDay.eq((Object)query.getPreDurationDay()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getWbsProgress())) {
            list.add(this.qdo.wbsProgress.eq((Object)query.getWbsProgress()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getRelyIds())) {
            list.add(this.qdo.relyIds.like(SqlUtil.toSqlLikeString((String)query.getRelyIds())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getRelyNames())) {
            list.add(this.qdo.relyNames.like(SqlUtil.toSqlLikeString((String)query.getRelyNames())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getRelyType())) {
            list.add(this.qdo.relyType.eq((Object)query.getRelyType()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getRelyDay())) {
            list.add(this.qdo.relyDay.eq((Object)query.getRelyDay()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getManagerUserIds())) {
            list.add(this.qdo.managerUserId.in((Collection)query.getManagerUserIds()));
        }
        return ExpressionUtils.allOf(list);
    }

    public PmsProjectWbsVO queryByKey(Long id) {
        JPAQuery<PmsProjectWbsVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (PmsProjectWbsVO)jpaQuery.fetchFirst();
    }

    public List<PmsProjectWbsVO> queryByProjectId(Long projectId) {
        JPAQuery<PmsProjectWbsVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.projectId.eq((Object)projectId));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return jpaQuery.fetch();
    }

    public List<PmsProjectWbsVO> queryListDynamic(PmsProjectWbsQuery query) {
        JPAQuery<PmsProjectWbsVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public PmsProjectWbsDO save(PmsProjectWbsDO ado) {
        return (PmsProjectWbsDO)this.repo.save(ado);
    }

    public List<PmsProjectWbsDO> saveAll(List<PmsProjectWbsDO> dos) {
        return this.repo.saveAll(dos);
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        SqlUtil.updateCommonJpaQuery((JPAUpdateClause)update, (QBaseModel)this.qdo._super);
        return update.execute();
    }

    public List<PmsProjectWbsVO> querySimpleByProjectId(Long projectId) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PmsProjectWbsVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.wbsName, this.qdo.preStartDate, this.qdo.preEndDate, this.qdo.durationDay})).from((EntityPath)this.qdo);
        jpaQuery.where((Predicate)this.qdo.projectId.eq((Object)projectId));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return jpaQuery.fetch();
    }

    public long upadateManagerUserId(Long projectId, List<Long> managerUserIds, Long managerUserId) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.managerUserId, (Object)managerUserId).where(new Predicate[]{this.qdo.projectId.eq((Object)projectId).and((Predicate)this.qdo.managerUserId.in(managerUserIds))});
        SqlUtil.updateCommonJpaQuery((JPAUpdateClause)update, (QBaseModel)this.qdo._super);
        return update.execute();
    }

    public PmsProjectWbsDAO(JPAQueryFactory jpaQueryFactory, PmsProjectWbsRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

