/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5pms.server.project.service;

import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5pms.api.project.payload.PmsBudgetDetailPlanPayload;
import com.elitesland.tw.tw5pms.api.project.service.PmsBudgetDetailPlanService;
import com.elitesland.tw.tw5pms.api.project.vo.PmsBudgetDetailPlanVO;
import com.elitesland.tw.tw5pms.server.project.convert.PmsBudgetDetailPlanConvert;
import com.elitesland.tw.tw5pms.server.project.dao.PmsBudgetDetailPlanDAO;
import com.elitesland.tw.tw5pms.server.project.entity.PmsBudgetDetailPlanDO;
import com.elitesland.tw.tw5pms.server.project.repo.PmsBudgetDetailPlanRepo;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
public class PmsBudgetDetailPlanServiceImpl
extends BaseServiceImpl
implements PmsBudgetDetailPlanService {
    private static final Logger log = LoggerFactory.getLogger(PmsBudgetDetailPlanServiceImpl.class);
    private final PmsBudgetDetailPlanRepo pmsBudgetDetailPlanRepo;
    private final PmsBudgetDetailPlanDAO pmsBudgetDetailPlanDAO;

    public List<PmsBudgetDetailPlanVO> queryByProjectId(Long projectId, String ... type) {
        return this.pmsBudgetDetailPlanDAO.queryByProjectId(projectId, type);
    }

    public List<PmsBudgetDetailPlanVO> queryByProjectIds(List<Long> projectIds, String type) {
        return this.pmsBudgetDetailPlanDAO.queryByProjectIds(projectIds, type);
    }

    public List<Long> queryByPlanIds(List<Long> planIds) {
        List<PmsBudgetDetailPlanVO> list = this.pmsBudgetDetailPlanDAO.queryByPlanIds(planIds);
        if (ObjectUtils.isEmpty(list)) {
            return new ArrayList<Long>();
        }
        return list.stream().map(PmsBudgetDetailPlanVO::getPlanId).collect(Collectors.toList());
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional optional = this.pmsBudgetDetailPlanRepo.findById(id);
                if (!optional.isEmpty()) {
                    PmsBudgetDetailPlanDO entity = (PmsBudgetDetailPlanDO)optional.get();
                    entity.setDeleteFlag(1);
                    this.pmsBudgetDetailPlanRepo.save(entity);
                }
            });
        }
    }

    public void insertBacth(List<PmsBudgetDetailPlanPayload> payloads) {
        ArrayList dos = new ArrayList();
        payloads.forEach(payload -> dos.add(PmsBudgetDetailPlanConvert.INSTANCE.toDo((PmsBudgetDetailPlanPayload)payload)));
        this.pmsBudgetDetailPlanRepo.saveAll(dos);
    }

    public PmsBudgetDetailPlanServiceImpl(PmsBudgetDetailPlanRepo pmsBudgetDetailPlanRepo, PmsBudgetDetailPlanDAO pmsBudgetDetailPlanDAO) {
        this.pmsBudgetDetailPlanRepo = pmsBudgetDetailPlanRepo;
        this.pmsBudgetDetailPlanDAO = pmsBudgetDetailPlanDAO;
    }
}

