/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5pms.server.project.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.api.prd.org.query.PrdOrgEmployeeQuery;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5pms.api.project.payload.PmsProjectPayload;
import com.elitesland.tw.tw5pms.api.project.payload.PmsProjectStakeholdersListPayload;
import com.elitesland.tw.tw5pms.api.project.query.PmsProjectStakeholdersQuery;
import com.elitesland.tw.tw5pms.api.project.query.PmsProjectWbsQuery;
import com.elitesland.tw.tw5pms.api.project.service.PmsProjectStakeholdersService;
import com.elitesland.tw.tw5pms.api.project.service.PmsProjectWbsService;
import com.elitesland.tw.tw5pms.api.project.vo.PmsProjectStakeholdersVO;
import com.elitesland.tw.tw5pms.api.project.vo.PmsProjectVO;
import com.elitesland.tw.tw5pms.api.project.vo.PmsProjectWbsVO;
import com.elitesland.tw.tw5pms.server.common.functionEnum.ProjectWbsStatusEnum;
import com.elitesland.tw.tw5pms.server.project.dao.PmsProjectDAO;
import com.elitesland.tw.tw5pms.server.project.dao.PmsProjectStakeholdersDao;
import com.elitesland.tw.tw5pms.server.project.entity.PmsProjectStakeholdersDO;
import com.elitesland.tw.tw5pms.server.project.repo.PmsProjectStakeholdersRepo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
public class PmsProjectStakeholdersServiceImpl
extends BaseServiceImpl
implements PmsProjectStakeholdersService {
    private static final Logger log = LoggerFactory.getLogger(PmsProjectStakeholdersServiceImpl.class);
    private final PmsProjectStakeholdersDao pmsProjectStakeholdersDao;
    private final PmsProjectStakeholdersRepo pmsProjectStakeholdersRepo;
    private final PmsProjectDAO pmsProjectDAO;
    private final PrdOrgEmployeeService prdOrgEmployeeService;
    private final CacheUtil cacheUtil;
    private final PmsProjectWbsService pmsProjectWbsService;

    public PagingVO<PmsProjectStakeholdersVO> queryPaging(PmsProjectStakeholdersQuery query) {
        PagingVO<PmsProjectStakeholdersVO> projectVOPagingVO = this.pmsProjectStakeholdersDao.queryPaging(query);
        List list = projectVOPagingVO.getRecords();
        if (!ObjectUtils.isEmpty((Object)list)) {
            this.getWBSInfo(query.getProjectId(), list);
            projectVOPagingVO.setRecords(this.getDataFromEmployee(list));
        }
        return projectVOPagingVO;
    }

    public List<PmsProjectStakeholdersVO> queryListDynamic(PmsProjectStakeholdersQuery query) {
        List<PmsProjectStakeholdersVO> list = this.pmsProjectStakeholdersDao.queryListDynamic(query);
        if (!ObjectUtils.isEmpty(list)) {
            this.getWBSInfo(query.getProjectId(), list);
            return this.getDataFromEmployee(list);
        }
        return list;
    }

    @Transactional(rollbackFor={Exception.class})
    public void batchInsert(PmsProjectStakeholdersListPayload payload) {
        Object[] userIds = payload.getUserIds();
        if (ObjectUtils.isEmpty((Object[])userIds)) {
            throw TwException.error((String)"", (String)"\u5e72\u7cfb\u4eba\u672a\u9009\u62e9\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        Long projectId = payload.getProjectId();
        if (ObjectUtils.isEmpty((Object)projectId)) {
            throw TwException.error((String)"", (String)"\u5f52\u5c5e\u9879\u76ee\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        PmsProjectVO project = this.pmsProjectDAO.queryByKey(projectId);
        if (ObjectUtils.isEmpty((Object)project)) {
            throw TwException.error((String)"", (String)"\u5173\u8054\u9879\u76ee\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (!GlobalUtil.getLoginUserId().equals(project.getCreateUserId()) && !GlobalUtil.getLoginUserId().equals(project.getManagerUserId())) {
            throw TwException.error((String)"", (String)"\u53ea\u6709\u9879\u76ee\u521b\u5efa\u4eba\u548c\u9879\u76ee\u7ecf\u7406\u6709\u6743\u9650\u7f16\u8f91\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        for (Object userId : userIds) {
            if (!((Long)userId).equals(project.getManagerUserId())) continue;
            throw TwException.error((String)"", (String)"\u9879\u76ee\u7ecf\u7406 \u4e0d\u5141\u8bb8\u624b\u52a8\u6dfb\u52a0\u6216\u4fee\u6539\uff01");
        }
        this.insertData(Arrays.asList(userIds), projectId, 0);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        List<PmsProjectStakeholdersVO> list = this.pmsProjectStakeholdersDao.queryByKey(keys);
        if (ObjectUtils.isEmpty(list) || keys.size() != list.size()) {
            throw TwException.error((String)"", (String)"\u6240\u9009\u5e72\u7cfb\u4eba\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        Long projectId = list.get(0).getProjectId();
        PmsProjectVO project = this.pmsProjectDAO.queryByKey(projectId);
        if (!GlobalUtil.getLoginUserId().equals(project.getCreateUserId()) && !GlobalUtil.getLoginUserId().equals(project.getManagerUserId())) {
            throw TwException.error((String)"", (String)"\u53ea\u6709\u9879\u76ee\u521b\u5efa\u4eba\u548c\u9879\u76ee\u7ecf\u7406\u6709\u6743\u9650\u7f16\u8f91\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        long count = list.stream().filter(vo -> 1 == vo.getManagerUserIdFlag()).count();
        if (count > 0L) {
            throw TwException.error((String)"", (String)"\u9879\u76ee\u7ecf\u7406\u4e0d\u53ef\u4ee5\u79fb\u9664\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        this.getWBSInfo(projectId, list);
        for (PmsProjectStakeholdersVO vo2 : list) {
            if (!ProjectWbsStatusEnum.FINISHED.getCode().equals(vo2.getNodeStatus())) continue;
            throw TwException.error((String)"", (String)(vo2.getUserName() + "\u662f" + vo2.getNodeName() + "\u7684\u8d1f\u8d23\u4eba\uff0c\u4e14\u8be5\u5de5\u4f5c\u5df2\u5b8c\u6210\uff0c\u4e0d\u53ef\u79fb\u9664"));
        }
        this.pmsProjectStakeholdersDao.deleteSoft(keys);
        List managerUserIds = list.stream().map(PmsProjectStakeholdersVO::getUserId).distinct().collect(Collectors.toList());
        this.pmsProjectWbsService.deleteManagerUserIds(projectId, managerUserIds);
    }

    @Transactional(rollbackFor={Exception.class})
    public void addProjectManagerUserId(Long projectId, Long managerUserId) {
        this.insertData(Arrays.asList(managerUserId), projectId, 1);
    }

    @Transactional(rollbackFor={Exception.class})
    public void changeProjectLeader(PmsProjectPayload projectPayload) {
        Long projectId = projectPayload.getId();
    }

    void getWBSInfo(Long projectId, List<PmsProjectStakeholdersVO> list) {
        List managerUserIds = list.stream().map(PmsProjectStakeholdersVO::getUserId).distinct().collect(Collectors.toList());
        PmsProjectWbsQuery wbsQuery = new PmsProjectWbsQuery();
        wbsQuery.setProjectId(projectId);
        wbsQuery.setManagerUserIds(managerUserIds);
        List wbsVOList = this.pmsProjectWbsService.queryStakeholdersList(wbsQuery);
        Map<Long, List<PmsProjectWbsVO>> groupedList = wbsVOList.stream().collect(Collectors.groupingBy(PmsProjectWbsVO::getManagerUserId));
        list.forEach(vo -> this.getNodeRelatedData((PmsProjectStakeholdersVO)vo, (List)groupedList.get(vo.getUserId())));
    }

    void getNodeRelatedData(PmsProjectStakeholdersVO vo, List<PmsProjectWbsVO> wbsVOList) {
        vo.setNodeName(null);
        vo.setNodeStatus(null);
        vo.setIsNodeRelated(Boolean.valueOf(false));
        if (!ObjectUtils.isEmpty(wbsVOList)) {
            for (PmsProjectWbsVO wbsVO : wbsVOList) {
                if (!ProjectWbsStatusEnum.FINISHED.getCode().equals(wbsVO.getWbsStatus())) continue;
                vo.setNodeName(wbsVO.getWbsName());
                vo.setNodeStatus(ProjectWbsStatusEnum.FINISHED.getCode());
                vo.setIsNodeRelated(Boolean.valueOf(true));
                break;
            }
            if (ObjectUtils.isEmpty((Object)vo.getNodeName())) {
                for (PmsProjectWbsVO wbsVO : wbsVOList) {
                    if (!ProjectWbsStatusEnum.NOGIONG.getCode().equals(wbsVO.getWbsStatus())) continue;
                    vo.setNodeName(wbsVO.getWbsName());
                    vo.setNodeStatus(ProjectWbsStatusEnum.NOGIONG.getCode());
                    vo.setIsNodeRelated(Boolean.valueOf(true));
                    break;
                }
            }
        }
    }

    void insertData(List<Long> userIds, Long projectId, Integer managerUserIdFlag) {
        PmsProjectStakeholdersQuery stakeholdersQuery = new PmsProjectStakeholdersQuery();
        stakeholdersQuery.setProjectId(projectId);
        stakeholdersQuery.setUserIds(userIds);
        List<PmsProjectStakeholdersVO> stakeholdersVOS = this.pmsProjectStakeholdersDao.queryListDynamic(stakeholdersQuery);
        stakeholdersVOS.stream().forEach(vo -> userIds.remove(vo.getUserId()));
        PrdOrgEmployeeQuery query = new PrdOrgEmployeeQuery();
        query.setUserIds(userIds);
        HashMap<Long, PrdOrgEmployeeVO> employeeMap = new HashMap<Long, PrdOrgEmployeeVO>();
        List employeeList = this.prdOrgEmployeeService.queryList(query);
        for (PrdOrgEmployeeVO employee : employeeList) {
            employeeMap.put(employee.getUserId(), employee);
        }
        ArrayList<PmsProjectStakeholdersDO> list = new ArrayList<PmsProjectStakeholdersDO>();
        for (Long userId : userIds) {
            PrdOrgEmployeeVO employeeVO = (PrdOrgEmployeeVO)employeeMap.get(userId);
            if (ObjectUtils.isEmpty((Object)employeeVO)) {
                throw TwException.error((String)"", (String)"\u7528\u6237\u8d44\u6e90\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
            PmsProjectStakeholdersDO object = new PmsProjectStakeholdersDO();
            object.setProjectId(projectId);
            object.setUserId(userId);
            object.setUserNo(employeeVO.getEmployeeNo());
            object.setUserName(employeeVO.getEmployeeName());
            object.setManagerUserIdFlag(managerUserIdFlag);
            list.add(object);
        }
        this.pmsProjectStakeholdersRepo.saveAll(list);
    }

    private List<PmsProjectStakeholdersVO> getDataFromEmployee(List<PmsProjectStakeholdersVO> list) {
        List userIds = list.stream().map(PmsProjectStakeholdersVO::getUserId).distinct().collect(Collectors.toList());
        PrdOrgEmployeeQuery query = new PrdOrgEmployeeQuery();
        query.setUserIds(userIds);
        HashMap<Long, PrdOrgEmployeeVO> employeeMap = new HashMap<Long, PrdOrgEmployeeVO>();
        List employeeList = this.prdOrgEmployeeService.queryList(query);
        for (PrdOrgEmployeeVO employee : employeeList) {
            employeeMap.put(employee.getUserId(), employee);
        }
        for (PmsProjectStakeholdersVO object : list) {
            PrdOrgEmployeeVO employeeVO = (PrdOrgEmployeeVO)employeeMap.get(object.getUserId());
            if (ObjectUtils.isEmpty((Object)employeeVO)) continue;
            object.setUserNo(employeeVO.getEmployeeNo());
            object.setUserName(employeeVO.getEmployeeName());
            object.setMobile(employeeVO.getMobile());
            object.setEmail(employeeVO.getEmail());
            object.setCompanyName(employeeVO.getCompanyName());
            if (!ObjectUtils.isEmpty((Object)employeeVO.getExtString3())) {
                object.setProfessionalSequence(this.cacheUtil.transferSystemSelection("org:employee:sequence", employeeVO.getExtString3()));
            }
            if (!ObjectUtils.isEmpty((Object)employeeVO.getExtString6())) {
                object.setSourceTypeName(this.cacheUtil.transferSystemSelection("org:employee:type", employeeVO.getExtString6()));
            }
            object.setOrgName(employeeVO.getOrgName());
        }
        return list;
    }

    public PmsProjectStakeholdersServiceImpl(PmsProjectStakeholdersDao pmsProjectStakeholdersDao, PmsProjectStakeholdersRepo pmsProjectStakeholdersRepo, PmsProjectDAO pmsProjectDAO, PrdOrgEmployeeService prdOrgEmployeeService, CacheUtil cacheUtil, PmsProjectWbsService pmsProjectWbsService) {
        this.pmsProjectStakeholdersDao = pmsProjectStakeholdersDao;
        this.pmsProjectStakeholdersRepo = pmsProjectStakeholdersRepo;
        this.pmsProjectDAO = pmsProjectDAO;
        this.prdOrgEmployeeService = prdOrgEmployeeService;
        this.cacheUtil = cacheUtil;
        this.pmsProjectWbsService = pmsProjectWbsService;
    }
}

