/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5pms.server.task.controller;

import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5pms.api.task.payload.PmsTaskAppraisePayload;
import com.elitesland.tw.tw5pms.api.task.payload.PmsTaskPayload;
import com.elitesland.tw.tw5pms.api.task.query.PmsTaskQuery;
import com.elitesland.tw.tw5pms.api.task.service.PmsTaskService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4efb\u52a1"})
@RestController
@RequestMapping(value={"/api/pms/pmsTask"})
public class PmsTaskController {
    private static final Logger log = LoggerFactory.getLogger(PmsTaskController.class);
    private final PmsTaskService pmsTaskService;

    @GetMapping(value={"/{key}"})
    @ApiOperation(value="\u4efb\u52a1-\u4e3b\u952e\u67e5\u8be2")
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok((Object)this.pmsTaskService.queryOneByKey(key));
    }

    @PutMapping(value={"/acceptTask"})
    @ApiOperation(value="\u63a5\u53d7\u4efb\u52a1")
    public TwOutputUtil acceptTask(@RequestBody PmsTaskPayload payload) {
        this.pmsTaskService.acceptTask(payload);
        return TwOutputUtil.ok();
    }

    @PutMapping(value={"/applySettle"})
    @ApiOperation(value="\u7533\u8bf7\u5f53\u91cf\u7ed3\u7b97")
    public TwOutputUtil applySettle(@RequestBody List<PmsTaskPayload> payloads) {
        this.pmsTaskService.applySettle(payloads);
        return TwOutputUtil.ok();
    }

    @PutMapping(value={"/operApplySettle"})
    @ApiOperation(value="\u5904\u7406\u7533\u8bf7\u7ed3\u7b97")
    public TwOutputUtil operApplySettle(@RequestBody PmsTaskPayload payload) {
        this.pmsTaskService.operApplySettle(payload);
        return TwOutputUtil.ok();
    }

    @PutMapping(value={"/updateTaskProgress"})
    @ApiOperation(value="\u4fee\u6539\u4efb\u52a1\u8fdb\u5ea6")
    public TwOutputUtil updateTaskProgress(@RequestBody List<PmsTaskPayload> payloads) {
        this.pmsTaskService.updateTaskProgress(payloads);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/updateTaskStatus"})
    @ApiOperation(value="\u4fee\u6539\u72b6\u6001")
    public TwOutputUtil updateTaskStatus(Long[] keys) {
        this.pmsTaskService.updateTaskStatus(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    @PostMapping(value={"/appraiseTask"})
    @ApiOperation(value="\u4efb\u52a1-\u8bc4\u4ef7")
    public TwOutputUtil appraiseTask(@RequestBody PmsTaskAppraisePayload payload) {
        this.pmsTaskService.appraiseTask(payload);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/paging"})
    @ApiOperation(value="\u4efb\u52a1-\u5206\u9875")
    public TwOutputUtil paging(PmsTaskQuery query) {
        return TwOutputUtil.ok((Object)this.pmsTaskService.queryPaging(query));
    }

    @GetMapping(value={"/list"})
    @ApiOperation(value="\u4efb\u52a1-\u67e5\u8be2\u5217\u8868")
    public TwOutputUtil queryList(PmsTaskQuery query) {
        return TwOutputUtil.ok((Object)this.pmsTaskService.queryListDynamic(query));
    }

    @GetMapping(value={"/queryAppraiseTaskList"})
    @ApiOperation(value="\u4efb\u52a1-\u8bc4\u4ef7\u67e5\u8be2\u5217\u8868")
    public TwOutputUtil queryAppraiseTaskList(Long taskId) {
        return TwOutputUtil.ok((Object)this.pmsTaskService.queryAppraiseTaskList(taskId));
    }

    @DeleteMapping(value={"/deleteSoft"})
    @ApiOperation(value="\u4efb\u52a1-\u5220\u9664")
    public TwOutputUtil deleteSoft(Long[] keys) {
        this.pmsTaskService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/queryViewPaging"})
    @ApiOperation(value="\u4efb\u52a1-\u770b\u677f\u5217\u8868\uff08\u6211\u63a5\u6536\u7684\u4efb\u52a1\uff09")
    public TwOutputUtil queryViewPaging(PmsTaskQuery query) {
        return TwOutputUtil.ok((Object)this.pmsTaskService.queryViewPaging(query));
    }

    @GetMapping(value={"/returnTask"})
    @ApiOperation(value="\u4efb\u52a1\u9000\u56de")
    public TwOutputUtil returnTask(Long[] keys) {
        this.pmsTaskService.returnTask(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    public PmsTaskController(PmsTaskService pmsTaskService) {
        this.pmsTaskService = pmsTaskService;
    }
}

