package com.elitesland.tw.tw5crm.server.${package}.service;

import com.elitesland.tw.tw5crm.server.${package}.repo.${className}Repo;
import com.elitesland.tw.tw5crm.server.${package}.dao.${className}DAO;
import com.elitesland.tw.tw5crm.server.${package}.convert.${className}Convert;
import com.elitesland.tw.tw5crm.api.${package}.service.${className}Service;
import com.elitesland.tw.tw5crm.api.${package}.payload.${className}Payload;
import com.elitesland.tw.tw5crm.server.${package}.entity.${className}DO;
import com.elitesland.tw.tw5crm.api.${package}.vo.${className}VO;
import com.elitesland.tw.tw5crm.api.${package}.query.${className}Query;
import com.elitesland.tw.tw5crm.server.${package}.convert.${className}Convert;
import org.springframework.stereotype.Service;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import org.springframework.transaction.annotation.Transactional;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.util.PageUtil;

import javax.servlet.http.HttpServletResponse;
import java.util.*;

/**
 * ${apiAlias}
 *
 * @author ${author}
 * @date ${date}
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class ${className}ServiceImpl extends BaseServiceImpl implements ${className}Service {

    private final ${className}Repo ${changeClassName}Repo;
    private final ${className}DAO ${changeClassName}DAO;

    @Override
    public PagingVO<${className}VO> queryPaging(${className}Query query){
        return ${changeClassName}DAO.queryPaging(query);
    }

    @Override
    public List<${className}VO> queryListDynamic(${className}Query query){
        return ${changeClassName}DAO.queryListDynamic(query);
    }

    @Override
    public ${className}VO queryByKey(Long key) {
        ${className}DO entity = ${changeClassName}Repo.findById(key).orElseGet(${className}DO::new);
        Assert.notNull(entity.getId(), "不存在");
        ${className}VO vo = ${className}Convert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ${className}VO insert(${className}Payload payload) {
        ${className}DO entityDo = ${className}Convert.INSTANCE.toDo(payload);
        return ${className}Convert.INSTANCE.toVo(${changeClassName}Repo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ${className}VO update(${className}Payload payload) {
        ${className}DO entity = ${changeClassName}Repo.findById(payload.getId()).orElseGet(${className}DO::new);
        Assert.notNull(entity.getId(), "不存在");
        ${className}DO entityDo = ${className}Convert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return ${className}Convert.INSTANCE.toVo(${changeClassName}Repo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(${className}Payload payload) {
        ${className}DO entity = ${changeClassName}Repo.findById(payload.getId()).orElseGet(${className}DO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = ${changeClassName}DAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional<${className}DO> optional = ${changeClassName}Repo.findById(id);
                if (!optional.isEmpty()) {
                    ${className}DO entity = optional.get();
                    entity.setDeleteFlag(1);
                    ${changeClassName}Repo.save(entity);
                }
             });
        }
    }

}
