package com.elitesland.tw.tw5.server.${package}.controller;

import com.elitesland.tw.tw5.api.${package}.payload.${className}Payload;
import com.elitesland.tw.tw5.api.${package}.query.${className}Query;
import com.elitesland.tw.tw5.api.${package}.vo.${className}VO;
import com.elitesland.tw.tw5.api.${package}.service.${className}Service;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import com.elitescloud.cloudt.common.base.PagingVO;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * ${apiAlias}
 *
 <#if apiGroupName != ''>
 * @folder ${apiGroupName}
 </#if>
 * @author ${author}
 * @date ${date}
 */
@Api(tags = "${apiAlias}")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/${changeClassName}")
@Slf4j
public class ${className}Controller {

private final ${className}Service ${changeClassName}Service;

    /**
     * ${apiAlias}-新增
     *
     <#if apiGroupName != ''>
     * @folder ${apiGroupName}
     </#if>
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("${apiAlias}-新增")
    public TwOutputUtil<${className}VO> insert(@RequestBody ${className}Payload payload){
         return TwOutputUtil.ok(${changeClassName}Service.insert(payload));
    }

    /**
     * ${apiAlias}-更新
     *
     <#if apiGroupName != ''>
         * @folder ${apiGroupName}
     </#if>
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("${apiAlias}-更新")
    public TwOutputUtil<${className}VO> update(@RequestBody ${className}Payload payload){
        return TwOutputUtil.ok(${changeClassName}Service.update(payload));
    }

    /**
     * ${apiAlias}-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     <#if apiGroupName != ''>
     * @folder ${apiGroupName}
     </#if>
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("${apiAlias}-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody ${className}Payload payload){
        return TwOutputUtil.ok(${changeClassName}Service.updateByKeyDynamic(payload));
    }

    /**
     * ${apiAlias}-主键查询
     *
     <#if apiGroupName != ''>
     * @folder ${apiGroupName}
     </#if>
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("${apiAlias}-主键查询")
    public TwOutputUtil<${className}VO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(${changeClassName}Service.queryByKey(key));
    }

    /**
     * ${apiAlias}-分页
     *
     <#if apiGroupName != ''>
         * @folder ${apiGroupName}
     </#if>
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("${apiAlias}-分页")
    public TwOutputUtil<PagingVO<${className}VO>> paging(${className}Query query) {
        return TwOutputUtil.ok(${changeClassName}Service.queryPaging(query));
    }

    /**
     * ${apiAlias}-查询列表
     *
     <#if apiGroupName != ''>
     * @folder ${apiGroupName}
     </#if>
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("${apiAlias}-查询列表")
    public TwOutputUtil<List<${className}VO>> queryList(${className}Query query) {
        return TwOutputUtil.ok(${changeClassName}Service.queryListDynamic(query));
    }

    /**
     * ${apiAlias}-删除
     *
     <#if apiGroupName != ''>
         * @folder ${apiGroupName}
     </#if>
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("${apiAlias}-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
         ${changeClassName}Service.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}

