package com.elitesland.tw.tw5.server.common;

import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.util.CollectionUtils;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import lombok.extern.slf4j.Slf4j;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * @author lvqf
 * @Date 2021/5/19
 * @Description
 */
@Slf4j
public class ExcelEntityDataListener<T> extends AnalysisEventListener {

    /**
     * 数据集
     */
    private List<T> datas = new ArrayList<>();

    /**
     * 需要校验的表头名称（为空时，不校验内容）
     */
    private List<String> headCheckList;

    public ExcelEntityDataListener() {

    }

    public ExcelEntityDataListener(List<String> headCheckList) {
        this.headCheckList = headCheckList;
    }

    @Override
    public void invoke(Object data, AnalysisContext context) {
        datas.add((T) data);
    }

    @Override
    public void doAfterAllAnalysed(AnalysisContext context) {

    }

    @Override
    public void invokeHeadMap(Map headMap, AnalysisContext context) {
        if (CollectionUtils.isEmpty(headCheckList)) {
            return;
        }
        if (headCheckList.size() != headMap.size()) {
            log.info("解析到一条头数据:{}，【长度】与设定的列信息不符{}", JSON.toJSONString(headMap), JSON.toJSONString(headCheckList));
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "导入数据异常，请检查导入 excel的列值是否与模板对应");
        }
        Optional any = headMap.values().stream().filter(headValue -> !headCheckList.contains(headValue)).findAny();
        if (any.isPresent()) {
            log.info("解析到一条头数据:{} 【内容】与设定的列信息不符{}", JSON.toJSONString(headMap), JSON.toJSONString(headCheckList));
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "导入数据异常，请检查导入 excel的列值是否与模板对应");
        }


    }

    /**
     * 获取结果集
     *
     * @return
     */
    public List<T> getDatas() {
        return datas;
    }

}
