package com.elitesland.tw.tw5.server.common.crontask;


import com.elitesland.tw.tw5.api.prd.administration.service.CertificationLicenseService;
import com.elitesland.tw.tw5.api.prd.budget.service.BudgetService;
import com.elitesland.tw.tw5.api.prd.cal.service.CalTaskSettleService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmActActivityService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmCustomerOperationService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmLeadsService;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdBaseBuChangeService;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdProbationExamService;
import com.elitesland.tw.tw5.api.prd.inv.service.InvItemService;
import com.elitesland.tw.tw5.api.prd.my.service.*;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgCompanyNoticeService;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgSyncDataService;
import com.elitesland.tw.tw5.api.prd.partner.common.service.BusinessPartnerService;
import com.elitesland.tw.tw5.api.prd.partner.identity.service.BusinessCustomerInfoService;
import com.elitesland.tw.tw5.api.prd.personplan.service.PersonPlanDtlService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectBriefService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectService;
import com.elitesland.tw.tw5.api.prd.purchase.service.PurchaseContractManagerService;
import com.elitesland.tw.tw5.api.prd.salecon.service.*;
import com.elitesland.tw.tw5.api.prd.system.service.PrdMessageConfigService;
import com.elitesland.tw.tw5.server.common.StringUtil;
import com.elitesland.tw.tw5.server.prd.personcare.service.PersonCareService;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.annotation.XxlJob;
import com.xxl.job.core.log.XxlJobLogger;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 定时任务
 */
@Slf4j
@Component
@RequiredArgsConstructor
public class CmadCronTask {
    /**
     * TW5.0版本更新通知
     */
    public final static String messageXxlJobValue = "xxl-job-executor-message";
    /**
     * 组织定时任务
     */
//    public final static String orgXxlJobValue = "xxl-job-executor-org";
    /**
     * 员工定时任务
     */
//    public final static String userXxlJobValue = "xxl-job-executor-user";
    /**
     * 员工当量系数定时任务
     */
//    public final static String employeeEqvaRatioXxlJobValue = "xxl-job-executor-eqva-ratio";

    /**
     * 员工关系定时任务 （组织员工关系）
     */
//    public final static String orgRefUserXxlJobValue = "xxl-job-executor-org-ref-user";
    /**
     * 项目定时任务
     */
//    public final static String projectXxlJobValue = "xxl-job-executor-project";

    /**
     * 任务定时任务
     */
//    public final static String taskXxlJobValue = "xxl-job-executor-task";

    /**
     * 任务包授权定时任务
     */
//    public final static String taskAuthorizedXxlJobValue = "xxl-job-executor-task-authorized";

    /**
     * 任务包授权详情定时任务
     */
//    public final static String taskAuthorizedDetailXxlJobValue = "xxl-job-executor-task-authorized-detail";

    /**
     * 项目成员定时任务
     */
//    public final static String projShXxlJobValue = "xxl-job-executor-proj-sh";


    /**
     * 活动定时任务
     */
//    public final static String activityXxlJobValue = "xxl-job-executor-activity";

    /**
     * 工时定时任务  5.0单项到4.0
     */
//    public final static String timesheetXxlJobValue = "xxl-job-executor-timesheet";


    /**
     * 假期工时定时任务  4.0单项到5.0
     */
//    public final static String vacationTimesheetTo5XxlJobValue = "xxl-job-executor-timesheet-vacation-to5";

    /**
     * 同步4.0的正常上下班打卡表到5.0
     */
    public final static String attendanceNormalTo5 = "xxl-job-executor-attendance-normal-to5";

    /**
     * 同步4.0的其它打卡表到5.0
     */
    public final static String attendanceOtherTo5 = "xxl-job-executor-attendance-other-to5";

    /**
     * 同步4.0的打卡记录明细表到5.0
     */
    public final static String attendanceRecordTo5 = "xxl-job-executor-attendance-record-to5";

    /**
     * 同步4.0的打卡结果补充表到5.0
     */
    public final static String attendanceRemarkTo5 = "xxl-job-executor-attendance-remark-to5";

    /**
     * 活动超时未发布
     */
    public final static String activityUnRelease = "xxl-job-activity-unrelease";
    /**
     * 公告定时任务
     */
    public final static String companyNoticeXxlJobValue = "xxl-job-company-notice";

    /**
     * 线索分配七日提醒定时任务
     */
    public final static String leadsRecieveNotice1XxlJobValue = "xxl-job-leads-receive-notice1";

    /**
     * 线索分配十日提醒定时任务
     */
    public final static String leadsRecieveNotice2XxlJobValue = "xxl-job-leads-receive-notice2";

    /**
     * 帮我吧项目定时任务
     * see bangwo8ProjProXxlJobValue
     */
//    @Deprecated
//    public final static String bangwo8ProjXxlJobValue = "xxl-job-bangwo8-proj";
    /**
     * 帮我吧项目定时任务
     */
    public final static String bangwo8ProjProXxlJobValue = "xxl-job-bangwo8-proj-pro";

    /**
     * 帮我吧顾问定时任务
     */
    public final static String bangwo8AdviserXxlJobValue = "xxl-job-bangwo8-adviser";

    /**
     * 帮我吧工单定时任务
     */
    public final static String bangwo8TicketXxlJobValue = "xxl-job-bangwo8-ticket";

    /**
     * 请假申请数据同步定时任务
     */
//    public final static String applyVacationXxlJobValue = "xxl-job-executor-apply-vacation";

    /**
     * 请假申请数据明细同步定时任务
     */
//    public final static String applyVacationDetailXxlJobValue = "xxl-job-executor-apply-vacation-detail";


    /**
     * 销售合同同步定时任务到4.0
     */
//    public final static String saleContractDataTo4XxlJobValue = "xxl-job-executor-sale-contract-dataTo4";

    /**
     * 采购合同同步定时任务
     */
//    public final static String purchaseContractTo5XxlJobValue = "xxl-job-executor-purchase-contract";

    /**
     * 采购合同明细同步定时任务
     */
//    public final static String purchaseContractDetailTo5XxlJobValue = "xxl-job-executor-purchase-contract-detail";

    /**
     * 财务期间同步定时任务
     */
//    public final static String finYearTo5XxlJobValue = "xxl-job-executor-fin-year";

    /**
     * 财务期间同步定时任务
     */
//    public final static String finPeriodTo5XxlJobValue = "xxl-job-executor-fin-period";

    /**
     * 产品同步定时任务
     */
//    public final static String productClassTo5XxlJobValue = "xxl-job-executor-product-class";

    /**
     * 产品同步定时任务
     */
//    public final static String productTo5XxlJobValue = "xxl-job-executor-product";

    /**
     * 供应商同步定时任务
     */
//    public final static String abTo5XxlJobValue = "xxl-job-executor-ab";

//
//    /**
//     * 业绩统计同步定时任务
//     */
//    public final static String contractAchieveTo5XxlJobValue = "xxl-job-executor-contract-achieve";


    /**
     * 合同收款计划同步定时任务to4.0
     */
//    public final static String contractRecvplanTo4XxlJobValue = "xxl-job-executor-contract_recvplan_to4";

    /**
     * 合同开票同步定时任务to4.0
     */
//    public final static String contractInvBatchTo4XxlJobValue = "xxl-job-executor-contract_invbatch_to4";

    /**
     * 合同开票发票同步定时任务to4.0
     */
//    public final static String contractInvBatchInvdtlTo4XxlJobValue = "xxl-job-executor-contract_invbatch_invdtl_to4";

//    public final static String conReceivableTo4XxlJobValue = "xxl-job-executor-contract_receivable_to4";

//    public final static String conReceivableDTo4XxlJobValue = "xxl-job-executor-contract_receivabled_to4";
    /**
     * 采购需求同步定时任务to4.0
     */
//    public final static String purcDemandTo4XxlJobValue = "xxl-job-executor-purc_demand_to4";

    /**
     * 外包费用同步定时任务to4.0
     */
//    public final static String costConTo4XxlJobValue = "xxl-job-executor-cost_con_to4";

    /**
     * 业绩统计同步定时任务to4.0
     */
//    public final static String conAchieveTo4XxlJobValue = "xxl-job-executor-con_achieve_to4";


    /**
     * 合同收款计划同步定时任务to5.0
     */
//    public final static String recvplanTo5XxlJobValue = "xxl-job-executor-contract_recvplan_to5";

    /**
     * 采购需求同步定时任务to5.0
     */
//    public final static String purcDemandTo5XxlJobValue = "xxl-job-executor-purc_demand_to5";

    /**
     * 外包费用同步定时任务to5.0
     */
//    public final static String costConTo5XxlJobValue = "xxl-job-executor-cost_con_to5";

    /**
     * 工作计划同步定时任务to4.0
     */
//    public final static String syncWorkPlanTo4 = "xxl-job-executor-work_plan_to4";
    /**
     * 定时执行项目自动汇报
     */
    public final static String projectBriefXxlJobValue = "xxl-job-executor-project-brief";

    public final static String autoCreateCustOperation = "xxl-job-executor-auto-cust-operation";

    public final static String overdueCompleteCustOperation = "xxl-job-executor-overdue-complete-cust-operation";

    /**
     * 百望发票商品数据同步接口(每天凌晨2点 执行，获取百望的自定义商品列表数据)
     */
//    public final static String INVOICE_ITEM_FROM_BAIWANG_HANDLE = "invoiceItemFromBaiwangHandle";

    /**
     * 销项发票百望数据同步接口(销项发票，定时从百望获取数据，同步到tw  con_inv_batch_invdtl 表中)
     */
    public final static String INVOICE_FROM_BAIWANG_HANDLE = "invoiceFromBaiwangHandle";

    /**
     * 定时执行项目风险等级
     */
    public final static String projectRiskLevelXxlJobValue = "xxl-job-executor-project-risk-level";

    private final PrdMessageConfigService prdMessageConfigService;
    @Autowired
    private CrmLeadsService leadsService;
    private final PrdOrgSyncDataService service;
    private final TimesheetService timesheetService;
    private final CrmActActivityService activityService;
    private final PrdOrgCompanyNoticeService noticeService;
    private final UserVacationApplyService userVacationApplyService;
    private final ConReceivablePlanService conReceivablePlanService;
    private final ConPurchaseDemandService conPurchaseDemandService;
    private final ConEpibolyCostConService conEpibolyCostConService;
    private final ConAchieveService conAchieveService;
    private final TimesheetPlanService timesheetPlanService;
    private final PmsProjectBriefService pmsProjectBriefService;
    private final PmsProjectService pmsProjectService;
    //private final CrmCustomerOperationAutoService crmCustomerOperationAutoService;
    private final CrmCustomerOperationService crmCustomerOperationService;
    private final ConInvBatchService invBatchService;
    private final InvItemService invItemService;
    private final ConReceivableService conReceivableService;
    private final ConReceivableDService conReceivableDService;
    private final BusinessPartnerService businessPartnerService;
    private final BusinessCustomerInfoService businessCustomerInfoService;
    private final CertificationLicenseService certificationLicenseService;
    private final PrdProbationExamService prdProbationExamService;
    private final PrdBaseBuChangeService prdBaseBuChangeService;
    private final VacationService vacationService;
    private final PersonCareService personCareService;
    private final SaleConContractService saleConContractService;
    private final TAttendanceNormalService tAttendanceNormalService;
    private final TAttendanceOtherService tAttendanceOtherService;
    private final TAttendanceRecordService tAttendanceRecordService;
    private final TAttendanceRemarkService tAttendanceRemarkService;

    private final PurchaseContractManagerService purchaseContractManagerService;

    private final BudgetService budgetService;
    private final PersonPlanDtlService personPlanDtlService;

    private final TAttendanceRuleService attendanceRuleService;


    private final ConReceivablePlanConfirmService conReceivablePlanConfirmService;
    /**
     * 工时提醒定时任务(BU/研发BU全员)
     */
    public final static String timeSheetAlterAllXxlJobValue = "xxl-job-timesheet-alter-all";

    /**
     * 工时提醒报销定时任务(BU/研发BU全员)
     */
    public final static String timeSheetAlterAllBackXxlJobValue = "xxl-job-timesheet-alter-all-back";

    /**
     * 工时提醒定时任务(上级)
     */
    public final static String timeSheetAlterSuperiorXxlJobValue = "xxl-job-timesheet-alter-superior";

    /**
     * 工时提醒定时任务(BU领导)
     */
    public final static String timeSheetAlterBuLeaderXxlJobValue = "xxl-job-timesheet-alter-buleader";

    /**
     * 工时审批提醒定时任务
     */
    public final static String timeSheetApprovingAlterXxlJobValue = "xxl-job-timesheet-approving-alter";

    /**
     * 业务伙伴主档同步（同步更新银行信息）
     */
//    public final static String businessPartnerXxlJobValue = "xxl-job-business-partner";

    /**
     * 业务伙伴-客户信息同步
     */
//    public final static String businessCustomerXxlJobValue = "xxl-job-business-customer";


    /**
     * 资质证照过期提醒定时任务
     */
    public final static String certificationLicenseInvaildAlterXxlJobValue = "xxl-job-certification-license-invaild-alter";


    public final static String purchaseContractCloseBatchXxlJobValue = "xxl-job-purchasecontract-close-batch";
    /**
     * 业务伙伴-客户信息同步JDE
     */
    public final static String businessPartnerSyncJdeXxlJobValue = "xxl-job-customer-jde";
    /**
     * 业务伙伴-销售合同信息同步JDE
     */
    public final static String saleContractSyncJdeXxlJobValue = "xxl-job-sale-contract-jde";

    public final static String budgetChangeTmpXxlJobValue = "xxl-job-budget-change-tmp";

    public final static String personPlanTmpXxlJobValue = "xxl-job-person-plan-tmp";

    public final static String synchronousAttendanceInformationHandle = "xxl-job-attendance-information-update";


    /**
     * 消息定时任务
     *
     * @param param 定时任务服务给的参数
     * @return 定时任务执行结果
     */
    @XxlJob(value = messageXxlJobValue)
    public ReturnT<String> messageJobHandler(String param) {
        log.info("wwwwwwwwwwwwwwwwwwwwwwwwwww:", param);
        XxlJobLogger.log("xxl-job-executor-message 开始执行。。。");
        prdMessageConfigService.onJobHandlerRelease(param);
        // 执行一次消息发送服务
        XxlJobLogger.log("执行结果:");
        System.out.println("wwwwwwwwwwwwwwwwwwwwwwwwwww:" + param);
        return ReturnT.SUCCESS;
    }

    /**
     * 组织定时任务 todo: 1231上线后删除
     *
     * @return 定时任务执行结果
     */
//    @XxlJob(value = orgXxlJobValue)
//    public ReturnT<String> orgJobHandler(String param) {
//        service.syncOrgs();
//        return ReturnT.SUCCESS;
//    }

    /**
     * 员工定时任务
     *
     * @return 定时任务执行结果 todo:1231上线后删除
     */
//    @XxlJob(value = userXxlJobValue)
//    //@GlobalTransactional
//    public ReturnT<String> userJobHandler(String param) {
//        service.syncUsers();
//        return ReturnT.SUCCESS;
//    }

    /**
     * 员工当量系数定时任务 todo:1231上线后删除
     *
     * @return 定时任务执行结果
     */
//    @XxlJob(value = employeeEqvaRatioXxlJobValue)
//    //@GlobalTransactional
//    public ReturnT<String> employeeEqvaRatioJobHandler(String param) {
//        service.syncEqvaRatio();
//        return ReturnT.SUCCESS;
//    }

    /**
     * 员工关系定时任务
     *
     * @return 定时任务执行结果 todo:1231上线后删除
     */
//    @XxlJob(value = orgRefUserXxlJobValue)
//    public ReturnT<String> OrgRefUserJobHandler(String param) {
//        service.syncOrgRefUsers();
//        return ReturnT.SUCCESS;
//    }

    /**
     * 项目定时任务//TODO 5.0项目、任务上线后删除
     *
     * @return 定时任务执行结果
     */
//    @XxlJob(value = projectXxlJobValue)
//    public ReturnT<String> projectJobHandler(String param) {
//        // TODO 5.0项目、任务上线后删除
//        XxlJobLogger.log("5.0项目、任务上线后删除...");
//        // service.syncProjects();
//        // return ReturnT.SUCCESS;
//        return ReturnT.FAIL;
//    }

    /**
     * 任务定时任务 //TODO 5.0项目、任务上线后删除
     *
     * @return 定时任务执行结果
     */
//    @XxlJob(value = taskXxlJobValue)
//    public ReturnT<String> taskJobHandler(String param) {
//        // TODO 5.0项目、任务上线后删除
//        XxlJobLogger.log("5.0项目、任务上线后删除...");
//        // service.syncTasks(param);
//        // return ReturnT.SUCCESS;
//        return ReturnT.FAIL;
//    }

    /**
     * 活动定时任务//TODO 5.0项目、任务上线后删除
     *
     * @return 定时任务执行结果
     */
//    @XxlJob(value = activityXxlJobValue)
//    public ReturnT<String> activityJobHandler(String param) {
//        // TODO 5.0项目、任务上线后删除
//        XxlJobLogger.log("5.0项目、任务上线后删除...");
//        // service.syncActivity();
//        // return ReturnT.SUCCESS;
//        return ReturnT.FAIL;
//    }

    /**
     * 工时定时任务 //TODO 5.0项目、任务上线后删除
     *
     * @return 定时任务执行结果
     */
//    @XxlJob(value = timesheetXxlJobValue)
//    public ReturnT<String> timesheetJobHandler(String param) {
//        // TODO 5.0项目、任务上线后删除
//        XxlJobLogger.log("5.0项目、任务上线后删除...");
//        // service.syncTimesheetDataTo4(param);
//        // return ReturnT.SUCCESS;
//        return ReturnT.FAIL;
//    }

    /**
     * 工时定时任务 TODO 5.0项目、任务上线后删除
     *
     * @return 定时任务执行结果
     */
//    @XxlJob(value = vacationTimesheetTo5XxlJobValue)
//    public ReturnT<String> vacationTimesheetTo5JobHandler(String param) {
//        service.syncVacationTimesheetDataTo5();
//        return ReturnT.SUCCESS;
//    }

    /**
     * 同步4.0的正常上下班打卡表到5.0
     */
    @XxlJob(value = attendanceNormalTo5)
    public ReturnT<String> attendanceNormalTo5(String param) {
        tAttendanceNormalService.attendanceNormalTo5(param);
        return ReturnT.SUCCESS;
    }

    /**
     * 同步4.0的其它打卡表到5.0
     */
    @XxlJob(value = attendanceOtherTo5)
    public ReturnT<String> attendanceOtherTo5(String param) {
        tAttendanceOtherService.attendanceOtherTo5(param);
        return ReturnT.SUCCESS;
    }


    /**
     * 同步4.0的打卡记录明细表到5.0
     */
    @XxlJob(value = attendanceRecordTo5)
    public ReturnT<String> attendanceRecordTo5(String param) {
        tAttendanceRecordService.attendanceRecordTo5(param);
        return ReturnT.SUCCESS;
    }

    /**
     * 同步4.0的打卡结果补充表到5.0
     */
    @XxlJob(value = attendanceRemarkTo5)
    public ReturnT<String> attendanceRemarkTo5(String param) {
        tAttendanceRemarkService.attendanceRemarkTo5(param);
        return ReturnT.SUCCESS;
    }


    /**
     * 任务包授权定时任务
     *
     * @return 定时任务执行结果 //todo: 1231上线后删除
     */
//    @XxlJob(value = taskAuthorizedXxlJobValue)
//    public ReturnT<String> taskAuthorizedJobHandler(String param) {
//        // TODO 5.0项目、任务上线后删除
//        XxlJobLogger.log("5.0项目、任务上线后删除...");
//        // service.syncTaskAuthorized();
//        // return ReturnT.SUCCESS;
//        return ReturnT.FAIL;
//    }


    /**
     * 任务包授权详情定时任务
     *
     * @return 定时任务执行结果 //todo: 1231上线后删除
     */
//    @XxlJob(value = taskAuthorizedDetailXxlJobValue)
//    public ReturnT<String> taskAuthorizedDetailJobHandler(String param) {
//        // TODO 5.0项目、任务上线后删除
//        XxlJobLogger.log("5.0项目、任务上线后删除...");
//        // service.syncTaskAuthorizedDetails();
//        // return ReturnT.SUCCESS;
//        return ReturnT.FAIL;
//    }


    /**
     * 项目成员定时任务
     *
     * @return 定时任务执行结果 //todo: 1231上线后删除
     */
//    @XxlJob(value = projShXxlJobValue)
//    public ReturnT<String> projShJobHandler(String param) {
//        // TODO 5.0项目、任务上线后删除
//        XxlJobLogger.log("5.0项目、任务上线后删除...");
//        // service.syncProjSh();
//        // return ReturnT.SUCCESS;
//        return ReturnT.FAIL;
//    }


    /**
     * 超时未分配校验定时任务
     *
     * @return 定时任务执行结果
     */
    @XxlJob(value = "leadsUndistributedRemind")
    public ReturnT<String> leadsUndistributedRemind(String param) {
        XxlJobLogger.log("[任务开始]-开始扫描超时未分配的线索...");
        boolean result = leadsService.leadsToDistributeRemind();
        if (result) {
            return ReturnT.SUCCESS;
        } else {
            return ReturnT.FAIL;
        }

    }


    /**
     * 超时未跟进校验定时任务
     *
     * @return 定时任务执行结果
     */
    @XxlJob(value = "leadsNotFollowRemind")
    public ReturnT<String> leadsUnReceivedRemind(String param) {
        XxlJobLogger.log("[任务开始]-开始扫描超时未跟进配的线索...");
        boolean result = leadsService.leadsNotFollowRemind();
        if (result) {
            return ReturnT.SUCCESS;
        } else {
            return ReturnT.FAIL;
        }
    }

    /**
     * 线索分配七日提醒定时任务
     *
     * @return 定时任务执行结果
     */
    @XxlJob(value = leadsRecieveNotice1XxlJobValue)
    public ReturnT<String> leadsRecieveNotice1(String param) {
        XxlJobLogger.log("[任务开始]-开始扫描超过7天未接收的线索...");
        boolean result = leadsService.leadsNotReceiveRemind(7);
        if (result) {
            return ReturnT.SUCCESS;
        } else {
            return ReturnT.FAIL;
        }
    }

    /**
     * 线索分配十日提醒定时任务
     *
     * @return 定时任务执行结果
     */
    @XxlJob(value = leadsRecieveNotice2XxlJobValue)
    public ReturnT<String> leadsRecieveNotice2(String param) {
        XxlJobLogger.log("[任务开始]-开始扫描超过10天未接收的线索...");
        boolean result = leadsService.leadsNotReceiveRemind(10);
        if (result) {
            return ReturnT.SUCCESS;
        } else {
            return ReturnT.FAIL;
        }
    }


    /**
     * 活动超时未发布
     *
     * @return 定时任务执行结果
     */
    @XxlJob(value = activityUnRelease)
    public ReturnT<String> activityUnReleaseJobHandler(String param) {
        XxlJobLogger.log("[任务开始]-开始扫描活动超时未发布...");
        log.info("[任务开始]-开始扫描活动超时未发布...:", param);
        activityService.activityUnReleaseJobHandler();
        return ReturnT.SUCCESS;
    }
//

    /**
     * 公告定时任务
     *
     * @return 公告定时任务
     */
    @XxlJob(value = companyNoticeXxlJobValue)
    public ReturnT<String> companyNoticeXxlJobValue(String param) {
        noticeService.companyNoticeJobHandler(param);
        return ReturnT.SUCCESS;
    }


    /**
     * 帮我吧项目同步定时任务 // TODO 5.0项目、任务上线后删除
     */
//    @XxlJob(value = bangwo8ProjXxlJobValue)
//    public ReturnT<String> bangwo8ProjXxlJobValue(String param) {
//        // TODO 5.0项目、任务上线后删除
//        XxlJobLogger.log("5.0项目、任务上线后删除...");
//        // service.syncProjectsToBangwo8(param);
//        // return ReturnT.SUCCESS;
//        return ReturnT.FAIL;
//    }

    /**
     * 帮我吧项目同步定时任务 新版
     */
    @XxlJob(value = bangwo8ProjProXxlJobValue)
    public ReturnT<String> bangwo8ProjProXxlJobValue(String param) {
        service.syncProjectsToBangwo8Pro(param);
        return ReturnT.SUCCESS;
    }

    /**
     * 帮我吧顾问同步定时任务
     */
    @XxlJob(value = bangwo8AdviserXxlJobValue)
    public ReturnT<String> bangwo8AdviserXxlJobValue(String param) {
        service.syncAdvisersToBangwo8(param);
        return ReturnT.SUCCESS;
    }

    /**
     * 帮我吧工单同步定时任务
     */
    @XxlJob(value = bangwo8TicketXxlJobValue)
    public ReturnT<String> bangwo8TicketXxlJobValue(String param) {
        LocalDateTime date = null;
        if (StringUtil.isDate(param)) {
            param = param + "T00:00:00";
            date = LocalDateTime.parse(param);
        }
        service.syncTicketsFromBangwo8(date);
        return ReturnT.SUCCESS;
    }

    /**
     * 请假申请数据同步定时任务
     *
     * @param param
     * @return
     */
//    @XxlJob(value = applyVacationXxlJobValue)
//    public ReturnT<String> applyVacationXxlJobValue(String param) {
//        userVacationApplyService.syncVacationApplyData(param);
//        return ReturnT.SUCCESS;
//    }

    /**
     * 请假申请明细数据同步定时任务
     *
     * @param param
     * @return
     */
//    @XxlJob(value = applyVacationDetailXxlJobValue)
//    public ReturnT<String> applyVacationDetailXxlJobValue(String param) {
//        userVacationApplyService.syncVacationApplyDetailData(param);
//        return ReturnT.SUCCESS;
//    }

    /**
     * 采购合同信息同步定时任务
     *
     * @param param
     * @return
     */
//    @XxlJob(value = purchaseContractTo5XxlJobValue)
//    public ReturnT<String> syncPurchaseContractTo5(String param) {
//        service.syncPurchaseContractTo5(param);
//        return ReturnT.SUCCESS;
//    }

    /**
     * 采购合同信息同步定时任务
     *
     * @param param
     * @return
     */
//    @XxlJob(value = purchaseContractDetailTo5XxlJobValue)
//    public ReturnT<String> syncPurchaseContractDetailTo5(String param) {
//        service.syncPurchaseContractDetailTo5(param);
//        return ReturnT.SUCCESS;
//    }

    /**
     * 财务年度同步定时任务
     *
     * @param param
     * @return
     */
//    @XxlJob(value = finYearTo5XxlJobValue)
//    public ReturnT<String> syncFinYearTo5(String param) {
//        service.syncFinYearTo5(param);
//        return ReturnT.SUCCESS;
//    }

    /**
     * 财务期间同步定时任务
     *
     * @param param
     * @return
     */
//    @XxlJob(value = finPeriodTo5XxlJobValue)
//    public ReturnT<String> syncFinPeriodTo5(String param) {
//        service.syncFinPeriodTo5(param);
//        return ReturnT.SUCCESS;
//    }


    /**
     * 产品同步定时任务
     *
     * @param param
     * @return
     */
//    @XxlJob(value = productClassTo5XxlJobValue)
//    public ReturnT<String> syncProductClassTo5(String param) {
//        service.syncProductClassTo5(param);
//        return ReturnT.SUCCESS;
//    }

    /**
     * 产品同步定时任务
     *
     * @param param
     * @return
     */
//    @XxlJob(value = productTo5XxlJobValue)
//    public ReturnT<String> syncProductTo5(String param) {
//        service.syncProductTo5(param);
//        return ReturnT.SUCCESS;
//    }

    /**
     * 地址簿同步定时任务
     *
     * @param param
     * @return
     */
//    @XxlJob(value = abTo5XxlJobValue)
//    public ReturnT<String> syncAbTo5(String param) {
//        service.syncAbTo5(param);
//        return ReturnT.SUCCESS;
//    }

//    /**
//     * 业绩统计定时任务
//     * @param param
//     * @return
//     */
//    @XxlJob(value = contractAchieveTo5XxlJobValue)
//    public ReturnT<String> syncContractAchieveTo5(String param){
//        service.syncContractAchieveTo5(param);
//        return ReturnT.SUCCESS;
//    }


    /**
     * 销售合同数据同步定时任务to4
     *
     * @param param
     * @return
     */
//    @XxlJob(value = saleContractDataTo4XxlJobValue)
//    public ReturnT<String> saleContractDataTo4XxlJobValue(String param) {
//        saleConContractService.syncSaleContractDataTo4(param);
//        return ReturnT.SUCCESS;
//    }

    /**
     * 合同收款计划同步到4.0
     *
     * @param param
     * @return
     */
//    @XxlJob(value = contractRecvplanTo4XxlJobValue)
//    public ReturnT<String> contractRecvplanTo4XxlJobValue(String param) {
//        conReceivablePlanService.syncContractRecvplanTo4(param);
//        return ReturnT.SUCCESS;
//    }


    /**
     * 合同开票同步到4.0
     *
     * @param param
     * @return
     */
//    @XxlJob(value = contractInvBatchTo4XxlJobValue)
//    public ReturnT<String> contractInvBatchTo4XxlJobValue(String param) {
//        invBatchService.syncContractInvBatchTo4(param);
//        return ReturnT.SUCCESS;
//    }

    /**
     * 合同开票发票同步到4.0
     *
     * @param param
     * @return
     */
//    @XxlJob(value = contractInvBatchInvdtlTo4XxlJobValue)
//    public ReturnT<String> contractInvBatchInvdtlTo4XxlJobValue(String param) {
//        invBatchService.syncContractInvBatchInvDtlTo4(param);
//        return ReturnT.SUCCESS;
//    }


    /**
     * 合同收款同步到4.0
     *
     * @param param
     * @return
     */
//    @XxlJob(value = conReceivableTo4XxlJobValue)
//    public ReturnT<String> conReceivableTo4XxlJobValue(String param) {
//        conReceivableService.syncConReceivableTo4(param);
//        return ReturnT.SUCCESS;
//    }

    /**
     * 合同收款明细同步到4.0
     *
     * @param param
     * @return
     */
//    @XxlJob(value = conReceivableDTo4XxlJobValue)
//    public ReturnT<String> conReceivableDTo4XxlJobValue(String param) {
//        conReceivableDService.syncConReceivableDTo4(param);
//        return ReturnT.SUCCESS;
//    }

    /**
     * 采购需求处理同步到4.0
     *
     * @param param
     * @return
     */
//    @XxlJob(value = purcDemandTo4XxlJobValue)
//    public ReturnT<String> purcDemandTo4XxlJobValue(String param) {
//        conPurchaseDemandService.syncPurcDemandTo4(param);
//        return ReturnT.SUCCESS;
//    }

    /**
     * 外包费用处理同步到4.0
     *
     * @param param
     * @return
     */
//    @XxlJob(value = costConTo4XxlJobValue)
//    public ReturnT<String> costConTo4XxlJobValue(String param) {
//        conEpibolyCostConService.syncCostConTo4(param);
//        return ReturnT.SUCCESS;
//    }

    /**
     * 业绩统计同步到4.0
     *
     * @param param
     * @return
     */
//    @XxlJob(value = conAchieveTo4XxlJobValue)
//    public ReturnT<String> conAchieveTo4XxlJobValue(String param) {
//        conAchieveService.syncConAchieveTo4(param);
//        return ReturnT.SUCCESS;
//    }


    /**
     * 采购需求处理同步到5.0回显
     *
     * @param param
     * @return
     */
//    @XxlJob(value = purcDemandTo5XxlJobValue)
//    public ReturnT<String> syncPurcDemandTo5(String param) {
//        service.syncPurcDemandTo5(param);
//        return ReturnT.SUCCESS;
//    }

    /**
     * 外包费用处理同步到5.0回显
     *
     * @param param
     * @return
     */
//    @XxlJob(value = costConTo5XxlJobValue)
//    public ReturnT<String> syncCostConTo5(String param) {
//        service.syncCostConTo5(param);
//        return ReturnT.SUCCESS;
//    }

    /**
     * 收款计划处理同步到5.0回显
     *
     * @param param
     * @return
     */
//    @XxlJob(value = recvplanTo5XxlJobValue)
//    public ReturnT<String> syncContractRecvplanTo5(String param) {
//        service.syncContractRecvplanTo5(param);
//        return ReturnT.SUCCESS;
//    }

    /**
     * 工时提醒定时任务(BU/研发BU全员)
     *
     * @return
     */
    @XxlJob(value = timeSheetAlterAllXxlJobValue)
    public ReturnT<String> timeSheetAlterAllXxlJobHandler(String param) {
        Long employeeId = !StringUtils.hasText(param) ? null : Long.parseLong(param);
        String sendUserList = timesheetService.timesheetAlertAll(employeeId);
        XxlJobLogger.log(sendUserList);
        return ReturnT.SUCCESS;
    }

    /**
     * 工时提醒定时任务(BU/研发BU全员)
     *
     * @return
     */
    @XxlJob(value = timeSheetAlterAllBackXxlJobValue)
    public ReturnT<String> timeSheetAlterAllBackXxlJobHandler(String param) {
        Long employeeId = !StringUtils.hasText(param) ? null : Long.parseLong(param);
        String sendUserList = timesheetService.timesheetAlertAllBack(employeeId);
        XxlJobLogger.log(sendUserList);
        return ReturnT.SUCCESS;
    }

    /**
     * 工时提醒定时任务(上级)
     *
     * @return
     */
    @XxlJob(value = timeSheetAlterSuperiorXxlJobValue)
    public ReturnT<String> timeSheetAlterSuperiorXxlJobHandler(String param) {
        String log = timesheetService.timesheetAlertSuperior();
        XxlJobLogger.log(log);
        return ReturnT.SUCCESS;
    }

    /**
     * 工时提醒定时任务(BU领导)
     *
     * @return
     */
    @XxlJob(value = timeSheetAlterBuLeaderXxlJobValue)
    public ReturnT<String> timeSheetAlterBuLeaderXxlJobHandler(String param) {
        String log = timesheetService.timesheetAlertBuLeader();
        XxlJobLogger.log(log);
        return ReturnT.SUCCESS;
    }


    /**
     * 工时审批提醒定时任务
     *
     * @return
     */
    @XxlJob(value = timeSheetApprovingAlterXxlJobValue)
    public ReturnT<String> timeSheetApprovingAlterXxlJobHandler(String param) {
        String log = timesheetService.timesheetApprovingAlert();
        XxlJobLogger.log(log);
        return ReturnT.SUCCESS;
    }

    /**
     * 工作计划从5同步到4
     *
     * @return
     */
//    @XxlJob(value = syncWorkPlanTo4)
//    public ReturnT<String> syncWorkPlanTo4(String param) {
//        timesheetPlanService.syncWorkPlanTo4(param);
//        return ReturnT.SUCCESS;
//    }

    /**
     * 销项发票百望数据同步接口(销项发票，定时从百望获取数据，同步到tw  T_INVBATCH_INVDTL 表中)
     *
     * @param param
     * @return
     */
    @XxlJob(value = INVOICE_FROM_BAIWANG_HANDLE)
    public ReturnT<String> invoiceFromBaiwangHandle(String param) {
        XxlJobLogger.log("[任务 开始] 销项发票百望数据同步接口(销项发票，定时从百望获取数据，同步到tw  T_INVBATCH_INVDTL 表中)..." + INVOICE_FROM_BAIWANG_HANDLE);
//        int n = invBatchService.getInvoicesFromBaiwang();
        XxlJobLogger.log("[任务结束] 销项发票百望数据同步接口(销项发票，定时从百望获取数据，同步到tw  T_INVBATCH_INVDTL 表中)....");
        return ReturnT.SUCCESS;
    }

    /**
     * 百望发票商品数据同步接口(每天凌晨2点 执行，获取百望的自定义商品列表数据)
     *
     * @param param
     * @return
     */
//    @XxlJob(value=INVOICE_ITEM_FROM_BAIWANG_HANDLE)
//    public ReturnT<String> invoiceItemFromBaiwangHandle(String param) {
//        XxlJobLogger.log("从百望获取发票商品信息start....." + INVOICE_ITEM_FROM_BAIWANG_HANDLE);
//        int n = invItemService.getInvoiceItemFromBaiwang();
//        XxlJobLogger.log("从百望获取发票商品信息end.....");
//        return ReturnT.SUCCESS;
//    }


    /**
     * 采购合同自动关闭批处理
     *
     * @param param
     * @return
     */
    @XxlJob(value = purchaseContractCloseBatchXxlJobValue)
    public ReturnT<String> purchaseContractCloseBatch(String param) {
        purchaseContractManagerService.purchaseContractCloseBatch();
        return ReturnT.SUCCESS;
    }

    /**
     * 定时执行项目自动汇报
     *
     * @return
     */
    @XxlJob(value = projectBriefXxlJobValue)
    public ReturnT<String> projectBriefJobHandler(String param) {
        pmsProjectBriefService.projectBriefJobHandler(param);
        return ReturnT.SUCCESS;
    }

    /**
     * 定时执行更新风险
     *
     * @return
     */
    @XxlJob(value = projectRiskLevelXxlJobValue)
    public ReturnT<String> projectRiskLevelJobHandler(String param) {
        pmsProjectService.projectJobHandler();
        return ReturnT.SUCCESS;
    }


    /**
     * 自动创建客户经营(历史数据，目前暂定执行一次)
     *
     * @param param
     * @return
     */
    @XxlJob(value = autoCreateCustOperation)
    public ReturnT<String> autoCustOperation(String param) {
        crmCustomerOperationService.autoCustOperation(param);
        return ReturnT.SUCCESS;
    }

    /**
     * 预期未完善客户经营信息提醒
     *
     * @param param
     * @return
     */
    @XxlJob(value = overdueCompleteCustOperation)
    public ReturnT<String> completeCustOperation(String param) {
        crmCustomerOperationService.overdueCompleteCustOperation(param);
        return ReturnT.SUCCESS;
    }
    /**
     * 业务伙伴主档同步4.0
     *
     * @param param
     * @return
     */
//    @XxlJob(value = businessPartnerXxlJobValue)
//    public ReturnT<String> businessPartnerSyncTw4(String param) {
//        businessPartnerService.businessPartnerSync(param);
//        return ReturnT.SUCCESS;
//    }

    /**
     * 业务伙伴-客户更新同步4.0
     *
     * @param param
     * @return
     */
//    @XxlJob(value = businessCustomerXxlJobValue)
//    public ReturnT<String> businessCustomerSyncTw4(String param) {
//        businessCustomerInfoService.businessCustomerSyncTw4(param);
//        return ReturnT.SUCCESS;
//    }


    /**
     * 资质证照过期提醒
     *
     * @return
     */
    @XxlJob(value = certificationLicenseInvaildAlterXxlJobValue)
    public ReturnT<String> certificationLicenseInvaildAlterXxlJobHandler(String param) {
        certificationLicenseService.certificationLicenseInvaildAlter();
        return ReturnT.SUCCESS;
    }

    /**
     * 定时任务结算
     */
    public final static String taskSettleXxlJobValue = "xxl-job-executor-task-settle";
    private final CalTaskSettleService calTaskSettleService;

    /**
     * 定时任务结算
     *
     * @return
     */
    @XxlJob(value = taskSettleXxlJobValue)
    public ReturnT<String> taskSettleXxlJobValue(String param) {
        calTaskSettleService.taskSettleJobHandler(null);
        return ReturnT.SUCCESS;
    }


    /**
     * 定时任务-试用期考核（中期）
     *
     * @return
     */
    public final static String prdProbationExamMid = "xxl-job-executor-prdProbationExamMid";

    @XxlJob(value = prdProbationExamMid)
    public ReturnT<String> prdProbationExamMid(String param) {
        prdProbationExamService.taskPrdProbationExamMid(param);
        return ReturnT.SUCCESS;
    }


    /**
     * 定时任务-试用期考核（末期）
     *
     * @return
     */
    public final static String prdProbationExamLate = "xxl-job-executor-prdProbationExamLate";

    @XxlJob(value = prdProbationExamLate)
    public ReturnT<String> prdProbationExamLate(String param) {
        prdProbationExamService.taskPrdProbationExamLate(param);
        return ReturnT.SUCCESS;
    }


    /**
     * 定时任务-BaseBu变更-加入日期
     *
     * @return
     */
    public final static String prdBaseBuChange = "xxl-job-executor-prdBaseBuChange";

    @XxlJob(value = prdBaseBuChange)
    public ReturnT<String> prdBaseBuChange(String param) {
        prdBaseBuChangeService.changeByTask(null, LocalDate.now(), param);
        return ReturnT.SUCCESS;
    }


    /**
     * 定时任务-法定假期自动生成工时
     *
     * @return
     */
    public final static String taskGenerateTimesheet = "xxl-job-executor-taskGenerateTimesheet";

    @XxlJob(value = taskGenerateTimesheet)
    public ReturnT<String> taskGenerateTimesheet(String param) {
        vacationService.taskGenerateTimesheet(param);
        return ReturnT.SUCCESS;
    }


    /**
     * 定时任务-法定假期自动审批
     *
     * @return
     */
    public final static String taskApprovalTimesheet = "xxl-job-executor-taskApprovalTimesheet";

    @XxlJob(value = taskApprovalTimesheet)
    public ReturnT<String> taskApprovalTimesheet(String param) {
        timesheetService.taskApprovalTimesheet(param);
        return ReturnT.SUCCESS;
    }


    /**
     * 发送生日祝福邮件
     */
    public final static String PERSON_CARE_AUTO_CREATE = "personCareAutoCreate";

    /**
     * 发送生日祝福邮件
     */
    @XxlJob(value = PERSON_CARE_AUTO_CREATE)
    public ReturnT<String> personCareAutoCreate(String param) {
        XxlJobLogger.log("[任务开始] 员工关怀邮件发送提醒 ...");
        int count = personCareService.taskSendBirthEmailMessage();
        XxlJobLogger.log("[任务处理结果条数：] ：" + count);
        XxlJobLogger.log("[任务结束] 员工关怀邮件发送完成");
        return ReturnT.SUCCESS;
    }

    /**
     * 定时任务-合同催款
     */
//    public final static String prdConPrompt = "xxl-job-executor-prdConPrompt";
//
//    @XxlJob(value = prdConPrompt)
//    public ReturnT<String> prdConPrompt() {
//        XxlJobLogger.log("[合同催款]开始检查···");
//        Integer total = conReceivablePlanService.taskPrdConPrompt();
//        XxlJobLogger.log("[合同催款]检查结束···处理条数：{}", total);
//        return ReturnT.SUCCESS;
//    }
    /**
     * A115 自动检查收款计划情况，并发起 收款计划催款流程 （合同催款业务）
     *
     * @param param
     * @return
     */

    public final static String sysAltRcvpConfirmAutoCreate = "xxl-job-sys-alt-rcvp-confirm-auto-create";

    @XxlJob(value = sysAltRcvpConfirmAutoCreate)
    public ReturnT<String> sysAltRcvpConfirmAutoCreate(String param) {
        XxlJobLogger.log("[任务开始] A115 自动检查收款计划情况，并发起 收款计划催款流程 （合同催款业务） ..." + sysAltRcvpConfirmAutoCreate);
        Long signBuId = null;
        if (StringUtils.hasText(param)) {
            signBuId = Long.valueOf(param);
        }
        final int count = conReceivablePlanConfirmService.autoCreateFlow(signBuId);

//        XxlJobLogger.log("[任务处理结果条数：] ："+count);
        XxlJobLogger.log("[任务结束] A115 自动检查收款计划情况，并发起 收款计划催款流程 （合同催款业务）");
        return ReturnT.SUCCESS;
    }


    /**
     * 预算变更临时表
     *
     * @param param
     * @return
     */
    @XxlJob(value = budgetChangeTmpXxlJobValue)
    public ReturnT<String> budgetChangeTmpXxlJob(String param) {
        XxlJobLogger.log("预算变更临时表数据同步开始");
        budgetService.syncBudgetChangeTmp();
        XxlJobLogger.log("预算变更临时表数据同步结束");
        return ReturnT.SUCCESS;
    }

    /**
     * 资源规划临时表
     *
     * @param param
     * @return
     */
    @XxlJob(value = personPlanTmpXxlJobValue)
    public ReturnT<String> personPlanTmpXxlJobValue(String param) {
        XxlJobLogger.log("资源规划临时表数据同步开始");
        personPlanDtlService.insertPlanTmp();
        XxlJobLogger.log("资源规划临时表数据同步结束");
        return ReturnT.SUCCESS;
    }

    /**
     * 资源规划临时表
     *
     * @param param
     * @return
     */
    @XxlJob(value = synchronousAttendanceInformationHandle)
    public ReturnT<String> synchronousPunchInformationHandle(String param) {
        XxlJobLogger.log("[任务开始] 同步打卡信息定时任务");
        LocalDate today = LocalDate.now();
        attendanceRuleService.updateAttendanceInformation(today);
        XxlJobLogger.log("[任务结束] 同步打卡信息定时任务");
        return ReturnT.SUCCESS;
    }

}
