package com.elitesland.tw.tw5.server.common.funConfig.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import javax.validation.constraints.*;

/**
 * 通用文档配置 业务类型访问权限
 *
 * @author duwh
 * @date 2023-12-11
 */
@Entity
@Table(name = "prd_business_doc_type_config_role_ref", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "prd_business_doc_type_config_role_ref", comment = "通用文档配置 业务类型访问权限")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class BusinessDocTypeConfigRoleRefDO extends BaseModel implements Serializable  {
    /** 文档类型配置 单据类型 */
    @Comment("文档类型配置 单据类型")
    @Column()
    private String docType;
    /** 角色编码 */
    @Comment("角色编码")
    @Column()
    private String roleCode;
    /** 角色名称 */
    @Comment("角色名称")
    @Column()
    private String roleName;
    /** 拓展字段1 */
    @Comment("拓展字段1")
    @Column()
    private String ext1;
    /** 拓展字段2 */
    @Comment("拓展字段2")
    @Column()
    private String ext2;
    /** 拓展字段3 */
    @Comment("拓展字段3")
    @Column()
    private String ext3;

    public void copy(BusinessDocTypeConfigRoleRefDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
