package com.elitesland.tw.tw5.server.openapi.sso;

import com.elitesland.tw.tw5.api.prd.my.service.PrdUserService;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Map;

/**
 * @author zoey
 * @Description:帆软报表单点登录
 * @date 2024/2/29 - 15:20
 */
@Api("帆软报表单点登录")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/report/sso")
@Slf4j
public class FrReportSsoController {

    private final PrdUserService prdUserService;
    /**
     * 单点登录获取token和url
     */

    @GetMapping({"/getSsoToken"})
    public TwOutputUtil getTokenAndUrl() {
        return TwOutputUtil.ok(prdUserService.getFrSsoToken());
    }
}
