package com.elitesland.tw.tw5.server.prd.acc.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimSourceConfigPayload;
import com.elitesland.tw.tw5.api.prd.acc.query.AccReimSourceConfigQuery;
import com.elitesland.tw.tw5.api.prd.acc.service.AccReimSourceConfigService;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimSourceConfigVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 报销金额来源配置管理
 *
 * @author sunxw
 * @date 2023-12-04
 */
@Api(tags = "报销金额来源配置管理")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/acc/accReimSourceConfig")
@Slf4j
public class AccReimSourceConfigController {

    private final AccReimSourceConfigService accReimSourceConfigService;

    /**
     * 报销金额来源配置管理-新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("报销金额来源配置管理-新增")
    public TwOutputUtil<AccReimSourceConfigVO> insert(@RequestBody AccReimSourceConfigPayload payload) {
        return TwOutputUtil.ok(accReimSourceConfigService.insert(payload));
    }

    /**
     * 报销金额来源配置管理-更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("报销金额来源配置管理-更新")
    public TwOutputUtil<AccReimSourceConfigVO> update(@RequestBody AccReimSourceConfigPayload payload) {
        return TwOutputUtil.ok(accReimSourceConfigService.update(payload));
    }

    /**
     * 报销金额来源配置管理-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("报销金额来源配置管理-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody AccReimSourceConfigPayload payload) {
        return TwOutputUtil.ok(accReimSourceConfigService.updateByKeyDynamic(payload));
    }

    /**
     * 报销金额来源配置管理-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("报销金额来源配置管理-主键查询")
    public TwOutputUtil<AccReimSourceConfigVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(accReimSourceConfigService.queryByKey(key));
    }

    /**
     * 报销金额来源配置管理-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("报销金额来源配置管理-分页")
    public TwOutputUtil<PagingVO<AccReimSourceConfigVO>> paging(AccReimSourceConfigQuery query) {
        return TwOutputUtil.ok(accReimSourceConfigService.queryPaging(query));
    }

    /**
     * 报销金额来源配置管理-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("报销金额来源配置管理-查询列表")
    public TwOutputUtil<List<AccReimSourceConfigVO>> queryList(AccReimSourceConfigQuery query) {
        return TwOutputUtil.ok(accReimSourceConfigService.queryListDynamic(query));
    }

    /**
     * 报销金额来源配置管理-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("报销金额来源配置管理-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        accReimSourceConfigService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}

