package com.elitesland.tw.tw5.server.prd.acc.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * @author sunxw
 * @description 报销金额来源配置
 * @Date 2023/12/4
 */
@Entity
@Table(name = "acc_reim_source_config", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "acc_reim_source_config", comment = "报销金额来源配置")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class AccReimSourceConfigDO extends BaseModel implements Serializable {

    @Comment("核算项目(对多个生效时，可以,分割)")
    @Column()
    private String busAccItemCodes;

    @Comment("配置名称")
    @Column()
    private String configName;

    @Comment("是否启用 0-否 1-是")
    @Column()
    private Integer enableFlag;

    @Comment("金额是否必须由计算器得出 0-否 1-是")
    @Column()
    private Integer calcFlag;

    @Comment("配置说明(富文本字段)")
    @Column()
    private String configRemark;

    @Comment("配置类型 INNER-内置制度 HALF-半配置化 ALL-全配置化")
    @Column()
    private String configType;

    public void copy(AccReimSourceConfigDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }

}
