package com.elitesland.tw.tw5.server.prd.administration.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDate;

/**
 * 资质证照
 *
 * @author wangly
 * @date 2023-09-20
 */
@Entity
@Table(name = "certification_license", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "certification_license", comment = "资质证照")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class CertificationLicenseDO extends BaseModel implements Serializable  {
    /** 证件类型 udc[COM:LICENSE_TYPE] */
    @Comment("证件类型 udc[COM:LICENSE_TYPE]")
    @Column()
    private String licenseType;
    /** 证照名称 */
    @Comment("证照名称")
    @Column()
    private String licenseName;
    /** 时间类型 udc[COM:TIME_TYPE] */
    @Comment("时间类型 udc[COM:TIME_TYPE]")
    @Column()
    private String timeType;
    /** 有效日期起 */
    @Comment("有效日期起")
    @Column()
    private LocalDate validDateStart;
    /** 有效日期止 */
    @Comment("有效日期止")
    @Column()
    private LocalDate validDateEnd;
    /** 附件 */
    @Comment("附件")
    @Column()
    private String fileCode;
    /** 证照来源 */
    @Comment("证照来源")
    @Column()
    private String licenseSource;
    /** 证照描述 */
    @Comment("证照描述")
    @Column()
    private String licenseDesc;
    /** 排序号 */
    @Comment("排序号")
    @Column()
    private Integer sortNo;
    /** 扩展字段1 */
    @Comment("扩展字段1")
    @Column()
    private String ext1;
    /** 扩展字段2 */
    @Comment("扩展字段2")
    @Column()
    private String ext2;
    /** 扩展字段3 */
    @Comment("扩展字段3")
    @Column()
    private String ext3;
    /** 扩展字段4 */
    @Comment("扩展字段4")
    @Column()
    private String ext4;
    /** 扩展字段5 */
    @Comment("扩展字段5")
    @Column()
    private String ext5;

    public void copy(CertificationLicenseDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
