package com.elitesland.tw.tw5.server.prd.budget.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.budget.payload.PmsBudgetOccupyPayload;
import com.elitesland.tw.tw5.api.prd.budget.query.PmsBudgetOccupyQuery;
import com.elitesland.tw.tw5.api.prd.budget.service.PmsBudgetOccupyService;
import com.elitesland.tw.tw5.api.prd.budget.vo.PmsBudgetOccupyVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Arrays;
import java.util.List;

/**
 * 预算占用管理
 *
 * @author ben
 * @date 2023-12-05
 */
@Api(tags = "预算占用管理")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/budget/pmsBudgetOccupy")
@Slf4j
public class PmsBudgetOccupyController {

    private final PmsBudgetOccupyService pmsBudgetOccupyService;

    /**
     * 预算占用管理-新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("预算占用管理-新增")
    public TwOutputUtil<PmsBudgetOccupyVO> insert(@RequestBody PmsBudgetOccupyPayload payload) {
        return TwOutputUtil.ok(pmsBudgetOccupyService.insert(payload));
    }

    /**
     * 预算占用管理-更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("预算占用管理-更新")
    public TwOutputUtil<PmsBudgetOccupyVO> update(@RequestBody PmsBudgetOccupyPayload payload) {
        return TwOutputUtil.ok(pmsBudgetOccupyService.update(payload));
    }

    /**
     * 预算占用管理-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("预算占用管理-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody PmsBudgetOccupyPayload payload) {
        return TwOutputUtil.ok(pmsBudgetOccupyService.updateByKeyDynamic(payload));
    }

    /**
     * 预算占用管理-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    @UdcNameClass
    @ApiOperation("预算占用管理-主键查询")
    public TwOutputUtil<PmsBudgetOccupyVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(pmsBudgetOccupyService.queryByKey(key));
    }

    /**
     * 预算占用管理-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    @UdcNameClass
    @ApiOperation("预算占用管理-分页")
    public TwOutputUtil<PagingVO<PmsBudgetOccupyVO>> paging(PmsBudgetOccupyQuery query) {
        return TwOutputUtil.ok(pmsBudgetOccupyService.queryPaging(query));
    }

    /**
     * 预算占用管理-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    @UdcNameClass
    @ApiOperation("预算占用管理-查询列表")
    public TwOutputUtil<List<PmsBudgetOccupyVO>> queryList(PmsBudgetOccupyQuery query) {
        return TwOutputUtil.ok(pmsBudgetOccupyService.queryListDynamic(query));
    }

    /**
     * 预算占用管理-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("预算占用管理-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        pmsBudgetOccupyService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}

