package com.elitesland.tw.tw5.server.prd.budget.service;


import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.budget.payload.BudgetAppropriationDetailPayload;
import com.elitesland.tw.tw5.api.prd.budget.query.BudgetAppropriationDetailQuery;
import com.elitesland.tw.tw5.api.prd.budget.service.BudgetAppropriationDetailService;
import com.elitesland.tw.tw5.api.prd.budget.vo.BudgetAppropriationDetailVO;
import com.elitesland.tw.tw5.server.prd.budget.convert.BudgetAppropriationDetailConvert;
import com.elitesland.tw.tw5.server.prd.budget.dao.BudgetAppropriationDetailDAO;
import com.elitesland.tw.tw5.server.prd.budget.entity.BudgetAppropriationDetailDO;
import com.elitesland.tw.tw5.server.prd.budget.repo.BudgetAppropriationDetailRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

/**
 * 预算拨付明细
 *
 * @author xxb
 * @date 2023-11-01
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class BudgetAppropriationDetailServiceImpl extends BaseServiceImpl implements BudgetAppropriationDetailService {

    private final BudgetAppropriationDetailRepo budgetAppropriationDetailRepo;
    private final BudgetAppropriationDetailDAO budgetAppropriationDetailDAO;

    @Override
    public void batchSave(Long appropriationId, List<BudgetAppropriationDetailPayload> list) {
        if (!ObjectUtils.isEmpty(list)) {
            List<BudgetAppropriationDetailDO> appropriationDetailDOS = new ArrayList<>();
            for (BudgetAppropriationDetailPayload payload : list) {
                BudgetAppropriationDetailDO entityDo = BudgetAppropriationDetailConvert.INSTANCE.toDo(payload);
                entityDo.setAppropriationId(appropriationId);
                appropriationDetailDOS.add(entityDo);
            }
            budgetAppropriationDetailDAO.saveAll(appropriationDetailDOS);
        }
    }

    @Override
    public PagingVO<BudgetAppropriationDetailVO> queryPaging(BudgetAppropriationDetailQuery query) {
        return budgetAppropriationDetailDAO.queryPaging(query);
    }

    @Override
    public List<BudgetAppropriationDetailVO> queryListDynamic(BudgetAppropriationDetailQuery query) {
        return budgetAppropriationDetailDAO.queryListDynamic(query);
    }

    @Override
    public BudgetAppropriationDetailVO queryByKey(Long key) {
        BudgetAppropriationDetailDO entity = budgetAppropriationDetailRepo.findById(key).orElseGet(BudgetAppropriationDetailDO::new);
        Assert.notNull(entity.getId(), "不存在");
        BudgetAppropriationDetailVO vo = BudgetAppropriationDetailConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public BudgetAppropriationDetailVO insert(BudgetAppropriationDetailPayload payload) {
        BudgetAppropriationDetailDO entityDo = BudgetAppropriationDetailConvert.INSTANCE.toDo(payload);
        return BudgetAppropriationDetailConvert.INSTANCE.toVo(budgetAppropriationDetailRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public BudgetAppropriationDetailVO update(BudgetAppropriationDetailPayload payload) {
        BudgetAppropriationDetailDO entity = budgetAppropriationDetailRepo.findById(payload.getId()).orElseGet(BudgetAppropriationDetailDO::new);
        Assert.notNull(entity.getId(), "不存在");
        BudgetAppropriationDetailDO entityDo = BudgetAppropriationDetailConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return BudgetAppropriationDetailConvert.INSTANCE.toVo(budgetAppropriationDetailRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(BudgetAppropriationDetailPayload payload) {
        BudgetAppropriationDetailDO entity = budgetAppropriationDetailRepo.findById(payload.getId()).orElseGet(BudgetAppropriationDetailDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = budgetAppropriationDetailDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            budgetAppropriationDetailDAO.deleteSoft(keys);
        }
    }

    @Override
    public void deleteSoftByAppId(Long appId) {
        budgetAppropriationDetailDAO.deleteSoftByAppId(appId);
    }

}
