package com.elitesland.tw.tw5.server.prd.budget.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.budget.payload.PmsBudgetOccupyPayload;
import com.elitesland.tw.tw5.api.prd.budget.query.PmsBudgetOccupyQuery;
import com.elitesland.tw.tw5.api.prd.budget.service.PmsBudgetOccupyService;
import com.elitesland.tw.tw5.api.prd.budget.vo.PmsBudgetOccupyVO;
import com.elitesland.tw.tw5.server.prd.budget.convert.PmsBudgetOccupyConvert;
import com.elitesland.tw.tw5.server.prd.budget.dao.PmsBudgetOccupyDAO;
import com.elitesland.tw.tw5.server.prd.budget.entity.PmsBudgetOccupyDO;
import com.elitesland.tw.tw5.server.prd.budget.repo.PmsBudgetOccupyRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.Collections;
import java.util.List;

/**
 * 预算占用管理
 *
 * @author ben
 * @date 2023-12-05
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PmsBudgetOccupyServiceImpl extends BaseServiceImpl implements PmsBudgetOccupyService {

    private final PmsBudgetOccupyRepo pmsBudgetOccupyRepo;
    private final PmsBudgetOccupyDAO pmsBudgetOccupyDAO;

    @Override
    public PagingVO<PmsBudgetOccupyVO> queryPaging(PmsBudgetOccupyQuery query) {
        return pmsBudgetOccupyDAO.queryPaging(query);
    }

    @Override
    public List<PmsBudgetOccupyVO> queryListDynamic(PmsBudgetOccupyQuery query) {
        return pmsBudgetOccupyDAO.queryListDynamic(query);
    }

    @Override
    public PmsBudgetOccupyVO queryByKey(Long key) {
        PmsBudgetOccupyDO entity = pmsBudgetOccupyRepo.findById(key).orElseGet(PmsBudgetOccupyDO::new);
        Assert.notNull(entity.getId(), "不存在");
        PmsBudgetOccupyVO vo = PmsBudgetOccupyConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PmsBudgetOccupyVO insert(PmsBudgetOccupyPayload payload) {
        PmsBudgetOccupyDO entityDo = PmsBudgetOccupyConvert.INSTANCE.toDo(payload);
        return PmsBudgetOccupyConvert.INSTANCE.toVo(pmsBudgetOccupyRepo.save(entityDo));
//        long result = saveOrUpdate(payload);
//        log.debug("saveOrUpdate result: {}", result);
//        return new PmsBudgetOccupyVO();
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PmsBudgetOccupyVO update(PmsBudgetOccupyPayload payload) {
        PmsBudgetOccupyDO entity = pmsBudgetOccupyRepo.findById(payload.getId()).orElseGet(PmsBudgetOccupyDO::new);
        Assert.notNull(entity.getId(), "不存在");
        PmsBudgetOccupyDO entityDo = PmsBudgetOccupyConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return PmsBudgetOccupyConvert.INSTANCE.toVo(pmsBudgetOccupyRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(PmsBudgetOccupyPayload payload) {
        PmsBudgetOccupyDO entity = pmsBudgetOccupyRepo.findById(payload.getId()).orElseGet(PmsBudgetOccupyDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = pmsBudgetOccupyDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            pmsBudgetOccupyDAO.deleteSoft(keys);
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long saveOrUpdate(List<PmsBudgetOccupyPayload> payloads) {
        long result = 0;
        for (PmsBudgetOccupyPayload payload : payloads) {
            Long budgetId = payload.getBudgetId();
            String docType = payload.getDocType();
            Long belongToId = payload.getBelongToId();
            String costType = payload.getCostType();
            Long docId = payload.getDocId();
            PmsBudgetOccupyVO entity = pmsBudgetOccupyDAO.queryByBizKey(budgetId, docType, belongToId, costType, docId);
            if (null != entity && null != entity.getId()) {
                log.info("exists entity ID: {}", entity.getId());
                payload.setId(entity.getId());
                result = pmsBudgetOccupyDAO.updateByKeyDynamic(payload);
            } else {
                PmsBudgetOccupyDO entityDo = PmsBudgetOccupyConvert.INSTANCE.toDo(payload);
                pmsBudgetOccupyRepo.save(entityDo);
                result += 1;
            }
            // TODO 关联更新预算明细表 占用数｜已使用数
            // some logic here...

        }
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long cancel(List<PmsBudgetOccupyPayload> payloads) {
        long result = 0;
        for (PmsBudgetOccupyPayload payload : payloads) {
            Long budgetId = payload.getBudgetId();
            String docType = payload.getDocType();
            Long belongToId = payload.getBelongToId();
            String costType = payload.getCostType();
            Long docId = payload.getDocId();
            PmsBudgetOccupyVO entity = pmsBudgetOccupyDAO.queryByBizKey(budgetId, docType, belongToId, costType, docId);
            if (null != entity && null != entity.getId()) {
                pmsBudgetOccupyDAO.deleteSoft(Collections.singletonList(entity.getId()));
                result += 1;
            }
            // TODO 关联更新预算明细表 占用数｜已使用数
            // some logic here...

        }
        return result;
    }

}
