package com.elitesland.tw.tw5.server.prd.cal.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.cal.payload.CalEqvaIncomePayload;
import com.elitesland.tw.tw5.api.prd.cal.query.CalEqvaIncomeQuery;
import com.elitesland.tw.tw5.api.prd.cal.service.CalEqvaIncomeService;
import com.elitesland.tw.tw5.api.prd.cal.service.CalTaskSettleService;
import com.elitesland.tw.tw5.api.prd.cal.vo.CalEqvaIncomeVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 当量收入配置管理
 *
 * @author carl
 * @date 2023-11-07
 */
@Api(tags = "当量收入配置管理")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/cal/calEqvaIncome")
@Slf4j
public class CalEqvaIncomeController {

    private final CalEqvaIncomeService calEqvaIncomeService;
    private final CalTaskSettleService calTaskSettleService;

    /**
     * 当量收入配置管理-新增或修改
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("当量收入配置管理-新增或修改")
    public TwOutputUtil<CalEqvaIncomeVO> insertOrUpdate(@RequestBody CalEqvaIncomePayload payload) {
        return TwOutputUtil.ok(calEqvaIncomeService.insertOrUpdate(payload));
    }


    /**
     * 当量收入配置管理-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    @UdcNameClass
    @ApiOperation("当量收入配置管理-主键查询")
    public TwOutputUtil<CalEqvaIncomeVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(calEqvaIncomeService.queryByKey(key));
    }

    /**
     * 当量收入配置管理-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    @UdcNameClass
    @ApiOperation("当量收入配置管理-分页")
    public TwOutputUtil<PagingVO<CalEqvaIncomeVO>> paging(CalEqvaIncomeQuery query) {
        return TwOutputUtil.ok(calEqvaIncomeService.queryPaging(query));
    }

    /**
     * 当量收入配置管理-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    @UdcNameClass
    @ApiOperation("当量收入配置管理-查询列表")
    public TwOutputUtil<List<CalEqvaIncomeVO>> queryList(CalEqvaIncomeQuery query) {
        return TwOutputUtil.ok(calEqvaIncomeService.queryListDynamic(query));
    }

    /**
     * 当量收入配置管理-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("当量收入配置管理-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        calEqvaIncomeService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    /**
     * 当量收入配置管理-查询外部资源当量价格配置
     *
     * @param resId 资源id
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/queryExternalEqvaIncome")
    @UdcNameClass
    @ApiOperation("当量收入配置管理-查询外部资源当量价格配置")
    public TwOutputUtil<PagingVO<CalEqvaIncomeVO>> queryExternalEqvaIncome(Long resId) {
        return TwOutputUtil.ok(calEqvaIncomeService.queryExternalEqvaIncome(resId));
    }

    /**
     * 保新增外部资源当量价格配置
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping("/saveExterEqvaIncome")
    @ApiOperation("保存外部资源当量价格配置")
    public TwOutputUtil<CalEqvaIncomeVO> saveExterEqvaIncome(@RequestBody CalEqvaIncomePayload payload) {
        return TwOutputUtil.ok(calEqvaIncomeService.saveExterEqvaIncome(payload));
    }

    /**
     * 针对选中外部员工单价任务包结算
     *
     * @param userIds 选中员工userIds 空值默认全部结算
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/taskSettleSingle")
    @ApiOperation("针对选中外部员工进行结算")
    public TwOutputUtil taskSettleSingle(Long[] userIds) {
        List<Long> list = null;
        if (userIds != null && userIds.length > 0) {
            list = Arrays.asList(userIds);
        }
        calTaskSettleService.taskSettleJobHandler(list);
        return TwOutputUtil.ok();
    }

}

