package com.elitesland.tw.tw5.server.prd.common.functionEnum;

import lombok.Getter;
import org.springframework.util.StringUtils;

/**
 * 工时模块相关枚举
 *
 * @author eason.shi
 * @since 2018/12/20
 */
public interface TsEnum {
    /**
     * 业务角色（审批）
     */
    enum TsBussinessRole implements TsEnum {
        business_role1("business_role1", "项目经理"),
        business_role2("business_role2", "交付负责人"),
        business_role3("business_role3", "交付BU Leader"),
        business_role4("business_role4", "交付BU 事业部Leader"),
        business_role5("business_role5", "费用承担BU Leader"),
        business_role6("business_role6", "费用承担BU 事业部Leader"),

        business_role7("business_role7", "签单负责人"),
        business_role8("business_role8", "售前负责人"),
        business_role9("business_role9", "签单BU Leader"),
        business_role10("business_role10", "售前BU Leader"),
        business_role11("business_role11", "签单BU 事业部Leader"),
        business_role12("business_role12", "售前BU 事业部Leader"),
        business_role13("business_role13", "直属上级"),
        business_role14("business_role14", "BU负责人"),
        business_role15("business_role15", "事业部Leader"),

        ;
        /**
         * 状态
         */
        @Getter
        private final String code;

        /**
         * 描述
         */
        @Getter
        private final String desc;

        public String qDesc(String name) {

            String desc = "";
            if (StringUtils.hasText(name)) {
                TsBussinessRole tsBussinessRole = valueOf(name);

                switch (tsBussinessRole) {
                    case business_role1:
                        desc = tsBussinessRole.getDesc();
                        break;
                    case business_role2:
                        return tsBussinessRole.getDesc();
                }
            }

            return desc;
        }

        TsBussinessRole(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }
    }


}
