package com.elitesland.tw.tw5.server.prd.crm.controller;

import com.elitesland.tw.tw5.api.prd.crm.payload.CrmCustomerPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmCustomerQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmCustomerService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmFollowService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmCustomerVO;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemLogQuery;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 客户管理
 *
 * @author carl.wang
 */
@Api("客户管理")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm")
@Slf4j
public class CrmCustomerController {

    private final CrmCustomerService service;
    private final CrmFollowService followService;

    /**
     * 新建
     *
     * @param payload po类
     * @return result
     */
    @PostMapping("/customer/insert")
    public TwOutputUtil insert(CrmCustomerPayload payload) {
        boolean flag = true;
        CrmCustomerVO vo = service.insert(payload,flag);
        return TwOutputUtil.ok(vo);
    }

    @PostMapping("/customer/batchInsert")
    public TwOutputUtil insert(@RequestBody List<CrmCustomerPayload> payloads) {
        service.batchInsert(payloads);
        return TwOutputUtil.ok();
    }


    /**
     * 修改
     *
     * @param payload po类
     * @return result
     */
    @PutMapping("/customer/update")
    public TwOutputUtil update(CrmCustomerPayload payload) {
        service.update(payload);
        return TwOutputUtil.ok();
    }

    /**
     * 省市区修改，需要清空值，新增接口单独处理
     *
     * @param payload po类
     * @return result
     */
    @PutMapping("/customer/updateProvinceCityDistrict")
    public TwOutputUtil updateProvinceCityDistrict(CrmCustomerPayload payload) {
        service.updateProvinceCityDistrict(payload);
        return TwOutputUtil.ok();
    }

    /**
     * 分页查询
     *
     * @param query 查询条件
     * @return result
     */
    @GetMapping("/customer/paging")
    public TwOutputUtil paging(CrmCustomerQuery query) {
        return TwOutputUtil.ok(service.paging(query));
    }

    /**
     * 详情查询
     *
     * @param id 主键
     * @return result
     */
    @GetMapping("/customer/queryByKey/{id}")
    public TwOutputUtil queryByKey(@PathVariable Long id) {
        CrmCustomerVO vo = service.queryDetail(id);
        return TwOutputUtil.ok(vo);
    }

    /**
     * 根据地址薄主键详情查询
     *
     * @param bookId 地址薄主键
     * @return result
     */
    @GetMapping("/customer/queryByBookId")
    public TwOutputUtil queryByBookId(Long bookId) {
        CrmCustomerVO vo = service.queryDetailByBookId(bookId);
        return TwOutputUtil.ok(vo);
    }

    /**
     * 修改激活暂挂状态
     *
     * @param key            主键
     * @param customerStatus 状态
     * @return result
     */
    @GetMapping("/act/updateStatus")
    public TwOutputUtil updateStatus(Long key, String customerStatus) {
        service.updateStatus(key, customerStatus);
        return TwOutputUtil.ok();
    }

    /**
     * 列表查询
     *
     * @return result
     */
    @GetMapping("/customer/queryList")
    public TwOutputUtil queryList() {
        return TwOutputUtil.ok(service.queryList());
    }

    /**
     * 查询修改记录
     *
     * @return result
     */
    @GetMapping("/customer/queryLogList")
    public TwOutputUtil queryLogList(PrdSystemLogQuery query) {
        return TwOutputUtil.ok(service.queryLogList(query));
    }


    /**
     * 客户轨迹列表查询:客户关联线索，商机日志列表
     *
     * @return result
     */
    @GetMapping("/customer/follow/list/{customerId}")
    public TwOutputUtil queryLogList(@PathVariable Long customerId,Boolean withActivityFollows) {
        return TwOutputUtil.ok(service.queryFollowList(customerId,withActivityFollows));
    }


    /**
     * 批量导出excel
     *
     * @return result
     */
    @ApiOperation("批量导出excel")
    @GetMapping("/customer/batchExport")
    public void batchExport(HttpServletResponse response, CrmCustomerQuery query) {
        service.downloadBatch(response, query);
    }


    /**
     * 检查 名称 唯一性
     *
     * @param custName cust名字
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/customer/checkCustNameUnique")
    public TwOutputUtil checkCustNameUnique(String custName) {
        return TwOutputUtil.ok(service.checkCustNameUnique(custName));
    }

}
