package com.elitesland.tw.tw5.server.prd.crm.repo;

import com.elitesland.tw.tw5.server.prd.crm.entity.CrmOffshoreDO;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.EntityGraph;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.lang.Nullable;

import java.util.List;
import java.util.Optional;

/**
 * @author zoey
 * @Description:
 * @date 2022/5/19 - 14:13
 */
public interface CrmOffshoreRepo extends JpaRepository<CrmOffshoreDO,Long>, QuerydslPredicateExecutor<CrmOffshoreDO>, JpaSpecificationExecutor<CrmOffshoreDO> {


    @Override
    @EntityGraph(value = "offshore.rule.list")
    List<CrmOffshoreDO> findAll(@Nullable Specification<CrmOffshoreDO> spec);

    @Override
    @EntityGraph(value = "offshore.rule.list")
    Page<CrmOffshoreDO> findAll(@Nullable Specification<CrmOffshoreDO> spec, Pageable pageable);


    @Override
    @EntityGraph(value = "offshore.rule.detail")
    Optional<CrmOffshoreDO> findById(Long id);


//    int countByOffshoreAdminId(Long userId);
//
//    List<CrmOffshoreDO> findByOffshoreAdminId(Long userId);

    @EntityGraph(value = "offshore.rule.list")
    CrmOffshoreDO findByOffshoreName(String offshoreName);

    @Query(value = "select id from CrmOffshoreDO where offshoreName in ?1")
    List<Long> queryOffshoreIdsByName(List<String> toList);
}
