package com.elitesland.tw.tw5.server.prd.crm.visit.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmCustomerOperationQuery;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOperationPlanDetailQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmCustomerOperationService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmLeadsService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOperationPlanDetailService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpportunityService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmActProjectVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmCustomerOperationVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmLeadsListVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOperationPlanDetailVO;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgDataRefVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeRefVO;
import com.elitesland.tw.tw5.api.prd.partner.common.payload.BusinessPartnerPayload;
import com.elitesland.tw.tw5.api.prd.partner.common.service.BookAddressService;
import com.elitesland.tw.tw5.api.prd.partner.common.service.BookContactsService;
import com.elitesland.tw.tw5.api.prd.partner.common.service.BusinessPartnerService;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BookAddressVO;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BookContactsVO;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BusinessPartnerSimpleVO;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BusinessPartnerVO;
import com.elitesland.tw.tw5.api.prd.partner.identity.service.BusinessCustomerInfoService;
import com.elitesland.tw.tw5.api.prd.partner.identity.vo.BusinessCustomerInfoVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdMessageConfigService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdMessageConfigVO;
import com.elitesland.tw.tw5.api.prd.visit.payload.VisitPlanAutoListPayload;
import com.elitesland.tw.tw5.api.prd.visit.payload.VisitPlanAutoPayload;
import com.elitesland.tw.tw5.api.prd.visit.payload.VisitPlanPayload;
import com.elitesland.tw.tw5.api.prd.visit.query.VisitPlanQuery;
import com.elitesland.tw.tw5.api.prd.visit.service.VisitPlanService;
import com.elitesland.tw.tw5.api.prd.visit.service.VisitTaskService;
import com.elitesland.tw.tw5.api.prd.visit.vo.VisitPlanVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.crontask.CmadCronTask;
import com.elitesland.tw.tw5.server.common.crontask.XxlJobInfo;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.crm.visit.constants.VisitTaskPlanObjTypeEnum;
import com.elitesland.tw.tw5.server.prd.crm.visit.constants.VisitTaskPlanPersonTypeEnum;
import com.elitesland.tw.tw5.server.prd.crm.visit.constants.VisitTaskPlanStatusEnum;
import com.elitesland.tw.tw5.server.prd.crm.visit.constants.VisitTaskPlanTypeEnum;
import com.elitesland.tw.tw5.server.prd.crm.visit.convert.VisitPlanConvert;
import com.elitesland.tw.tw5.server.prd.crm.visit.dao.VisitPlanDAO;
import com.elitesland.tw.tw5.server.prd.crm.visit.dao.VisitPlanDetailDAO;
import com.elitesland.tw.tw5.server.prd.crm.visit.entity.VisitPlanDO;
import com.elitesland.tw.tw5.server.prd.crm.visit.entity.VisitPlanDetailDO;
import com.elitesland.tw.tw5.server.prd.partner.constants.BusinessInsideOrOutSideEnum;
import com.elitesland.tw.tw5.server.prd.partner.constants.BusinessPartnerIdentityEnum;
import com.elitesland.tw.tw5.server.prd.partner.constants.BusinessPartnerTypeEnum;
import com.elitesland.tw.tw5.server.prd.system.convert.PrdMessageConfigConvert;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdMessageConfigDAO;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdMessageConfigDO;
import com.elitesland.tw.tw5.server.prd.system.repo.PrdMessageConfigRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.*;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * 销售拜访计划
 *
 * @author liwenpeng
 * @date 2023-03-14
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class VisitPlanServiceImpl extends BaseServiceImpl implements VisitPlanService {

    private final VisitPlanDAO visitPlanDAO;
    private final VisitPlanDetailDAO visitPlanDetailDAO;
    private final VisitTaskService visitTaskService;
    private final CacheUtil cacheUtil;
    private final PrdOrgEmployeeService prdOrgEmployeeService;
    // private final CrmCustomerService customerService;
    private final BusinessPartnerService businessPartnerService;
    private final BookAddressService bookAddressService;
    private final BookContactsService bookContactsService;

    // private final PrdAbContactsService prdAbContactsService;

    private final CrmLeadsService leadsService;

    private final CrmOpportunityService opportunityService;

    private final PrdMessageConfigService messageConfigService;

    private final PrdMessageConfigRepo repoMessage;

    private final PrdMessageConfigRepo prdMessageConfigRepo;
    private final PrdMessageConfigDAO prdMessageConfigDAO;
    private final CrmOperationPlanDetailService crmOperationPlanDetailService;
    private final CrmCustomerOperationService crmCustomerOperationService;
    private final BusinessCustomerInfoService businessCustomerInfoService;
    @Override
    public PagingVO<VisitPlanVO> queryPaging(VisitPlanQuery query) {
        //数据权限相关
        dataPermissionFlag(query);
        //拜访人员处理
        if (query.getVisitPerson() != null) {
            query.setVisitPersonNameStr(query.getVisitPerson() + ",");
        }
        if (query.getAccompanyPerson() != null) {
            query.setAccompanyPersonNameStr(query.getAccompanyPerson() + ",");
        }

        PagingVO<VisitPlanVO> visitPlanVOPagingVO = visitPlanDAO.queryPaging(query);

        //完善信息
        List<VisitPlanVO> records = visitPlanVOPagingVO.getRecords();
        records.forEach(this::tranVisitPlanVo);

        return visitPlanVOPagingVO;
    }


    @Override
    public VisitPlanVO queryByKey(Long key) {
        VisitPlanVO vo = visitPlanDAO.findByKey(key);
        //完善信息
        tranVisitPlanVo(vo);
        return vo;
    }

    private void tranVisitPlanVo(VisitPlanVO vo) {
        if (StringUtils.hasText(vo.getVisitPlanType())) {
            vo.setVisitPlanTypeDesc(cacheUtil.transferSystemSelection("crm:visit:task_plan:type", vo.getVisitPlanType()));
            if (VisitTaskPlanTypeEnum.general_plan.getCode().equals(vo.getVisitPlanType())) {
                vo.setVisitDate(vo.getVisitDateFrom() == null ? "" : vo.getVisitDateFrom().toString());
            } else {
                String dateFrom = vo.getVisitDateFrom() == null ? "" : vo.getVisitDateFrom().toString();
                String dateTo = vo.getVisitDateTo() == null ? "" : vo.getVisitDateTo().toString();
                vo.setVisitDate(dateFrom + "~" + dateTo);
            }
        }
        if (StringUtils.hasText(vo.getVisitPlanStatus())) {
            vo.setVisitPlanStatus(cacheUtil.transferSystemSelection("crm:visit:task_plan:status", vo.getVisitPlanStatus()));
        }

        if (StringUtils.hasText(vo.getExtString1())) {
            String visitPersonStr = vo.getExtString1().substring(0, vo.getExtString1().length() - 1);
            String visitPersonNameStr = getPersonNameStr(visitPersonStr);
            List<Long> visitPersonList = Stream.of(visitPersonStr.split(",")).map(Long::valueOf).toList();
            vo.setVisitPersonNameStr(visitPersonNameStr);
            vo.setVisitPersonList(visitPersonList);
        }

        if (StringUtils.hasText(vo.getExtString2())) {
            String accompanyPersonStr = vo.getExtString2().substring(0, vo.getExtString2().length() - 1);
            String accompanyPersonNameStr = getPersonNameStr(accompanyPersonStr);
            List<Long> accompanyPersonList = Stream.of(accompanyPersonStr.split(",")).map(Long::valueOf).toList();
            vo.setAccompanyPersonNameStr(accompanyPersonNameStr);
            vo.setAccompanyPersonList(accompanyPersonList);
        }
        if (StringUtils.hasText(vo.getObjType())) {
            vo.setObjTypeDesc(cacheUtil.transferSystemSelection("crm:visit:obj_type", vo.getObjType()));
        }
        //翻译创建人
        if (vo.getCreateUserId() != null) {
            vo.setCreateUserName(cacheUtil.getUserName(vo.getCreateUserId()));
        }
        // 客户信息
//        if(null == vo.getCustomId()){
//            log.warn("销售拜访计划未关联客户；销售拜访计划：{}", vo);
//            return;
//        }
//        final CrmCustomerSimpleVO simpleVO = customerService.querySimpleByKey(vo.getCustomId());
//        if(null != simpleVO){
//            final Long bookId = simpleVO.getBookId();
//            vo.setBookId(bookId);
//            vo.setCompanyAddress(simpleVO.getCompanyAddress());
//            vo.setLongitudeLatitude(simpleVO.getLongitudeLatitude());
//
//            if(null == bookId){
//                log.warn("客户数据异常；找不到bookId;  customId:{}", vo.getCustomId());
//                return;
//            }
//            // 联系人信息
//            PrdAbContactsQuery prdAbContactsQuery = new PrdAbContactsQuery();
//            prdAbContactsQuery.setBookId(bookId);
//            final PagingVO<PrdAbContactsVO> paging = prdAbContactsService.paging(prdAbContactsQuery);
//            if (paging.isNotEmpty()) {
//                final PrdAbContactsVO prdAbContactsVO = paging.getRecords().get(0);
//                vo.setContactsName(prdAbContactsVO.getContactsName());
//                vo.setContactsPhone(prdAbContactsVO.getContactsPhone());
//            }
//        }

        if (null == vo.getPartnerId()) {
            log.warn("销售拜访计划未关联客户；销售拜访计划：{}", vo);
            return;
        }
        final BusinessPartnerVO simpleVO = businessPartnerService.queryByKeySimple(vo.getPartnerId());
        if (null != simpleVO) {
            final Long bookId = simpleVO.getBookId();
            if (null == bookId) {
                log.warn("客户数据异常；找不到bookId;  partnerId:{}", vo.getPartnerId());
                return;
            }
            // 地址信息
            BookAddressVO bookAddressVO = bookAddressService.queryDefaultByBookId(bookId);

            if (bookAddressVO != null) {
                vo.setBookId(bookId);
                vo.setCompanyAddress(bookAddressVO.getDetailAddress());
                vo.setLongitudeLatitude(bookAddressVO.getLongitudeLatitude());
            }
            // 联系人信息
            BookContactsVO bookContactsVO = bookContactsService.queryDefaultByBookId(bookId);
            if (null != bookContactsVO) {
                vo.setContactsName(bookContactsVO.getContactsName());
                vo.setContactsPhone(bookContactsVO.getContactsPhone());
            }
            // 客户阶段
            BusinessCustomerInfoVO businessCustomerInfoVO = businessCustomerInfoService.queryByPartnerId(vo.getPartnerId());
            if(null != businessCustomerInfoVO){
                vo.setCustomerStage(businessCustomerInfoVO.getCustomerStage());
            }
        }

    }

    private String getPersonNameStr(String visitPersonStr) {

        return Stream.of(visitPersonStr.split(",")).map(e -> {
            Long visitPersonId = Long.valueOf(e);
            String userName = cacheUtil.getUserName(visitPersonId);
            return userName == null ? "" : userName;
        }).collect(Collectors.joining(","));

    }

    @Override
    @Transactional(rollbackFor = RuntimeException.class)
    public VisitPlanVO insert(VisitPlanPayload payload) {
//        int countNum = verifyVisitPlanName(payload.getVisitPlanName());
//        if (countNum > 0) {
//            throw TwException.error("", "计划名称不可重复");
//        }
        VisitPlanDO save = commonSaveVisitPlan(payload);
        return VisitPlanConvert.INSTANCE.toVo(save);
    }

    /**
     * 通用保存计划
     *
     * @param payload 有效载荷
     * @return {@link VisitPlanDO}
     */
    private VisitPlanDO commonSaveVisitPlan(VisitPlanPayload payload) {
        //拜访人员和协访人员id排序后存入扩展字段中
        saveVisitPersonStr(payload);

        VisitPlanDO entityDo = VisitPlanConvert.INSTANCE.toDo(payload);
        //新增默认未完成
        entityDo.setVisitPlanStatus(VisitTaskPlanStatusEnum.incomplete.getCode());
        //存储计划
        VisitPlanDO save = visitPlanDAO.save(entityDo);
        //存储人员明细
        saveVisitPlanDetail(payload.getVisitPersonList(), save.getId(), VisitTaskPlanPersonTypeEnum.visit_person.getCode());
        saveVisitPlanDetail(payload.getAccompanyPersonList(), save.getId(), VisitTaskPlanPersonTypeEnum.accompany_person.getCode());

        //调用任务接口生产任务
        visitTaskService.generateTaskByPlanId(save.getId());

        // 消息通知
//        notice(payload, save);

        //消息通知
        createNotice(payload, save);
        accompanyNotice(payload, save);
        visitNotice(payload, save);
        return save;
    }

    /**
     * 自动创建拜访计划 （附近的客户）
     *
     * @param visitPlanAutoPayload 单据数据
     * @return {@link VisitPlanVO}
     */
    @Override
    @Transactional(rollbackFor = RuntimeException.class)
    public VisitPlanVO insertAuto(VisitPlanAutoPayload visitPlanAutoPayload) {
        String partnerName = visitPlanAutoPayload.getPartnerName();

        LocalDateTime now = LocalDateTime.now();
        VisitPlanPayload payload = new VisitPlanPayload();

        if (StringUtils.hasText(partnerName)) {
            // 判断客户名称是否存在
            BusinessPartnerSimpleVO vo = businessPartnerService.queryByPartnerName(partnerName);
            if (null != vo) {
                Long partnerId = vo.getId();
                payload.setPartnerId(partnerId);
            } else {
                // 不存在创建默认的客户
                BusinessPartnerPayload businessPartnerPayload = new BusinessPartnerPayload();
                businessPartnerPayload.setPartnerName(partnerName);
                businessPartnerPayload.setDetailAddress(visitPlanAutoPayload.getCustomAdress());
                businessPartnerPayload.setPartnerIdentity(BusinessPartnerIdentityEnum.CUSTOMER.getCode());
                businessPartnerPayload.setContactsPhone(visitPlanAutoPayload.getContactsPhone());
                businessPartnerPayload.setContactsName(visitPlanAutoPayload.getContactsName());
                businessPartnerPayload.setCountry(visitPlanAutoPayload.getCountry());
                businessPartnerPayload.setProvince(visitPlanAutoPayload.getProvince());
                businessPartnerPayload.setCity(visitPlanAutoPayload.getCity());
                businessPartnerPayload.setDistrict(visitPlanAutoPayload.getDistrict());
                businessPartnerPayload.setProvinceName(visitPlanAutoPayload.getProvinceName());
                businessPartnerPayload.setCityName(visitPlanAutoPayload.getCityName());
                businessPartnerPayload.setDistrictName(visitPlanAutoPayload.getDistrictName());
                businessPartnerPayload.setLongitudeLatitude(visitPlanAutoPayload.getLongitudeLatitude());
                businessPartnerPayload.setCustomerFlag(true);
                businessPartnerPayload.setPartnerType(BusinessPartnerTypeEnum.ORGANIZATION.getCode());
                businessPartnerPayload.setInsideOrOutSide(BusinessInsideOrOutSideEnum.OUTSIDE.getCode());
                BusinessPartnerVO businessPartnerSave = businessPartnerService.insert(businessPartnerPayload);
                payload.setPartnerId(businessPartnerSave.getId());
            }
            Date date = new Date();
//            SimpleDateFormat format = new SimpleDateFormat("yyyyMMddhhmmssS");
            SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");

            String nowStr = format.format(date);
            partnerName = nowStr + "-" + partnerName + "-" + GlobalUtil.getLoginUserName();
        } else {
            throw TwException.error("", "partnerName不能为空");
        }
//        int countNum = verifyVisitPlanName(partnerName);
//        if (countNum > 0) {
//            throw TwException.warn("", "重复添加");
//        }
        payload.setVisitPlanName(partnerName);
        payload.setCustomAdress(visitPlanAutoPayload.getCustomAdress());
        // 拜访时间
        LocalDate visitDate = now.plusDays(7).toLocalDate();
        payload.setVisitDateFrom(visitDate);
        payload.setVisitDateTo(visitDate);
        //提醒时间
        payload.setRemindTime(now.plusDays(6));
        payload.setVisitTimes("1");

        // 拜访成员
        List<Long> visitPersonList = new ArrayList<>();
        visitPersonList.add(GlobalUtil.getLoginUserId());
        payload.setVisitPersonList(visitPersonList);
        payload.setVisitPlanType(VisitTaskPlanTypeEnum.general_plan.getCode());
        // 新增计划
        VisitPlanDO save = commonSaveVisitPlan(payload);
        return VisitPlanConvert.INSTANCE.toVo(save);
    }

    /**
     * 批量新增拜访计划（附近的客户）
     *
     * @param payload 有效载荷
     * @return {@link Object}
     */
    @Override
    @Transactional(rollbackFor = RuntimeException.class)
    public List<VisitPlanVO> insertListAuto(VisitPlanAutoListPayload payload) {
        List<VisitPlanVO> result = new ArrayList<>();
        List<VisitPlanAutoPayload> visitPlanAutoPayloadList = payload.getVisitPlanAutoPayloadList();
        visitPlanAutoPayloadList.forEach(plan -> {
            result.add(insertAuto(plan));
        });
        return result;
    }

    private void notice(VisitPlanPayload payload, VisitPlanDO save) {
        String loginUserName = GlobalUtil.getLoginUserName();
        Long loginUserId = GlobalUtil.getLoginUserId();
        List<Long> noticePersonList = new ArrayList();
        PrdOrgEmployeeRefVO prdOrgEmployeeRefVO = prdOrgEmployeeService.queryEmployeeRef(loginUserId);
        // 创建人上级
        if (prdOrgEmployeeRefVO != null && prdOrgEmployeeRefVO.getParentId() != null) {
            noticePersonList.add(prdOrgEmployeeRefVO.getParentId());
        }
        // 协访成员
        if (payload.getAccompanyPersonList() != null) {
            noticePersonList.addAll(payload.getAccompanyPersonList());
        }
        if (noticePersonList.size() > 0) {
            List<PrdMessageConfigDO> messageConfigDOS = new ArrayList<>();
            noticePersonList.forEach(userId -> {
                String code = generateSeqNum("MESSAGE_CONFIG_NO");
                Long visitPlanId = save.getId();
                String content = loginUserName + " 新增了一条拜访计划 <a href=\"/customerVisit/visitPlanDetail?id=" + visitPlanId + "\">" +
                        save.getVisitPlanName() + "</a> 。";
                PrdMessageConfigDO ado = new PrdMessageConfigDO();
                ado.setMessageCode(code);
                ado.setMessageTitle("新增拜访计划");
                ado.setMessageContent(content);
                ado.setCreateUserId(loginUserId);
                ado.setContentBigType("businessMessage");
                ado.setContentType("systemMessage");
                ado.setCreateSource("新增拜访计划");
                ado.setIsEnable(0);
                ado.setMessageType(2);
                ado.setNoticeScope("appoint_people");
                ado.setNoticeSource(userId + "");
                ado.setNoticeWay("instation");
                ado.setTenantId(save.getTenantId());
                ado.setReleaseSource("profileMessage");
                ado.setReleaseStatus(3);
                ado.setTriggerTime(LocalDateTime.now());
                messageConfigDOS.add(ado);
            });
            //保存消息
            List<PrdMessageConfigDO> messageConfigDOS1 = repoMessage.saveAll(messageConfigDOS);
            //发送消息
            List<PrdMessageConfigVO> messageConfigVOS = messageConfigDOS1.stream().map(PrdMessageConfigConvert.INSTANCE::toVo).collect(Collectors.toList());
            messageConfigService.releaseMessage(messageConfigVOS);
        }
    }

    //发送新建拜访计划消息
    private void createNotice(VisitPlanPayload payload, VisitPlanDO save) {
        String loginUserName = GlobalUtil.getLoginUserName();
        Long loginUserId = GlobalUtil.getLoginUserId();    // 发送人
        List<Long> accompanyPersonList = payload.getAccompanyPersonList();  // 协防成员
        List<Long> visitPersonList = payload.getVisitPersonList();  //拜访成员
        // 拜访成员上级
        Set<Long> visitPersonParentList = prdOrgEmployeeService.queryParentIdByIds(visitPersonList);
        // 1.新建一条拜访计划后，协防成员、拜访成员、拜访成员直属领导收到一条新建拜访计划消息通知
        Set<Long> noticePersonList = new HashSet<>();
        if (!CollectionUtils.isEmpty(accompanyPersonList)) {
            noticePersonList.addAll(accompanyPersonList);
        }
        if (!CollectionUtils.isEmpty(visitPersonParentList)) {
            noticePersonList.addAll(visitPersonParentList);
        }
        if (!CollectionUtils.isEmpty(visitPersonList)) {
            noticePersonList.addAll(visitPersonList);
        }
        // 发送消息1 --- 新建拜访计划
        if (noticePersonList.size() > 0) {
            PrdMessageConfigDO ado = new PrdMessageConfigDO();  //要发送的消息
            ado.setCreateUserId(loginUserId);
            ado.setContentBigType("businessMessage");
            ado.setContentType("visit");
            ado.setCreateSource("个人");
            ado.setIsEnable(0);
            ado.setMessageType(2);
            ado.setObjectId(save.getId());  //业务数据 --- 拜访计划的ID
            ado.setAction("visitPlan");     //业务数据具体业务
            ado.setNoticeScope("appoint_people");
            ado.setNoticeWay("instation");
            ado.setTenantId(save.getTenantId());
            ado.setReleaseSource("profileMessage");
            ado.setReleaseStatus(3);
            String code = generateSeqNum("MESSAGE_CONFIG_NO");
            Long visitPlanId = save.getId();
            String content = loginUserName + " 新建了一条拜访计划 <a href=\"/customerVisit/visitPlanDetail?id=" + visitPlanId + "\">" +
                    save.getVisitPlanName() + "</a> 。";
            ado.setMessageCode(code);
            ado.setMessageTitle("新建拜访计划");
            ado.setMessageContent(content);
            ado.setTriggerTime(LocalDateTime.now());
            StringJoiner noticeSource = new StringJoiner(",");
            noticePersonList.forEach(userId -> {
                noticeSource.add(userId + "");
            });
            ado.setNoticeSource(noticeSource + "");
            //保存消息
            PrdMessageConfigDO save1 = repoMessage.save(ado);
            //发送消息
            messageConfigService.releaseMessage(Arrays.asList(PrdMessageConfigConvert.INSTANCE.toVo(save1)));
        }
    }

    // 发送协防消息  到达拜访任务提醒时间后，拜访成员收到一条拜访任务提醒通知，协防成员收到一条协防提醒消息通知
    public void accompanyNotice(VisitPlanPayload payload, VisitPlanDO save) {
        Long loginUserId = GlobalUtil.getLoginUserId();
        if (payload.getRemindTime() == null) {
            return;
        }
        List<Long> accompanyPersonList = payload.getAccompanyPersonList();  // 协防成员
        PrdMessageConfigDO ado = new PrdMessageConfigDO();  //要发送的消息
        ado.setCreateUserId(loginUserId);
        ado.setContentBigType("businessMessage");
        ado.setContentType("visit");
        ado.setCreateSource("个人");
        ado.setIsEnable(0);
        ado.setObjectId(save.getId());  //业务数据 --- 拜访计划的ID
        ado.setAction("visitPlan");     //业务数据具体业务
        ado.setMessageType(2);
        ado.setNoticeScope("appoint_people");
        ado.setNoticeWay("instation");
        ado.setTriggerWay("timing");
        ado.setTenantId(save.getTenantId());
        ado.setReleaseSource("profileMessage");
        ado.setReleaseStatus(0);
        String code = generateSeqNum("MESSAGE_CONFIG_NO");
        String content = "您有一条拜访计划待协访，请注意时间";
        ado.setMessageCode(code);
        ado.setMessageTitle("协访提醒");
        ado.setMessageContent(content);
        ado.setTriggerTime(payload.getRemindTime());
        if (accompanyPersonList != null && accompanyPersonList.size() > 0) {
            StringJoiner noticeSource = new StringJoiner(",");
            accompanyPersonList.forEach(userId -> {
                noticeSource.add(userId + "");
            });
            ado.setNoticeSource(String.valueOf(noticeSource));
            messageConfigService.insert(PrdMessageConfigConvert.INSTANCE.toPayload(ado));
        }
    }

    // 到达拜访任务提醒时间后，拜访成员收到一条拜访任务提醒通知，协防成员收到一条协访提醒消息通知
    public void visitNotice(VisitPlanPayload payload, VisitPlanDO save) {
        if (payload.getRemindTime() == null) {
            return;
        }
        Long loginUserId = GlobalUtil.getLoginUserId();
        List<Long> visitPersonList = payload.getVisitPersonList();  //拜访成员
        PrdMessageConfigDO ado = new PrdMessageConfigDO();  //要发送的消息
        ado.setCreateUserId(loginUserId);
        ado.setContentBigType("businessMessage");
        ado.setContentType("visit");
        ado.setCreateSource("个人");
        ado.setIsEnable(0);
        ado.setObjectId(save.getId());  //业务数据 --- 拜访计划的ID
        ado.setAction("visitPlan");     //业务数据具体业务
        ado.setMessageType(2);
        ado.setNoticeScope("appoint_people");
        ado.setNoticeWay("instation");
        ado.setTriggerWay("timing");
        ado.setTenantId(save.getTenantId());
        ado.setReleaseSource("profileMessage");
        ado.setReleaseStatus(0);
        String code = generateSeqNum("MESSAGE_CONFIG_NO");
        String content = "您有一条拜访任务待执行，请注意时间";
        ado.setMessageCode(code);
        ado.setMessageTitle("拜访任务提醒");
        ado.setMessageContent(content);
        ado.setTriggerTime(payload.getRemindTime());
        if (visitPersonList != null && visitPersonList.size() > 0) {
            StringJoiner noticeSource = new StringJoiner(",");
            visitPersonList.forEach(userId -> {
                noticeSource.add(userId + "");
            });
            ado.setNoticeSource(String.valueOf(noticeSource));
            messageConfigService.insert(PrdMessageConfigConvert.INSTANCE.toPayload(ado));
        }
    }


    private void saveVisitPersonStr(VisitPlanPayload payload) {
        List<Long> visitPersonList = payload.getVisitPersonList();
        if (visitPersonList == null || visitPersonList.size() < 1) {
            throw new RuntimeException("新建计划 拜访成员必填");
        }
        String visitPersonStr = visitPersonList.stream().sorted().map(Object::toString).collect(Collectors.joining(",", "", ","));
        payload.setExtString1(visitPersonStr);
        List<Long> accompanyPersonList = payload.getAccompanyPersonList();
        if (accompanyPersonList != null && accompanyPersonList.size() > 0) {
            String accompanyPersonStr = accompanyPersonList.stream().sorted().map(Object::toString).collect(Collectors.joining(",", "", ","));
            payload.setExtString2(accompanyPersonStr);
        }
        //拜访成员的上级 存起来 数据权限用
        String visitPersonParentStr = visitPersonList.stream().map(visitPersonId -> {
            PrdOrgDataRefVO defaultOrgInfoByUserId = cacheUtil.getDefaultOrgInfoByUserId(visitPersonId);
            if (defaultOrgInfoByUserId == null) {
                return -1L;
            } else {
                return defaultOrgInfoByUserId.getParentId() == null ? -1L : defaultOrgInfoByUserId.getParentId();
            }
        }).map(Object::toString).distinct().collect(Collectors.joining(",", "", ","));
        payload.setExtString3(visitPersonParentStr);
    }

    private void saveVisitPlanDetail(List<Long> visitPersonList, Long visitPlanId, String visitTaskPlanPersonType) {
        if (visitPersonList != null && visitPersonList.size() > 0) {
            //存储人员明细
            for (Long visitPersonId : visitPersonList) {
                VisitPlanDetailDO ado = new VisitPlanDetailDO();
                ado.setVisitPlanId(visitPlanId);
                ado.setVisitPersonId(visitPersonId);
                ado.setVisitPersonType(visitTaskPlanPersonType);
                visitPlanDetailDAO.save(ado);
            }
        }

    }

    @Override
    @Transactional(rollbackFor = RuntimeException.class)
    public long update(VisitPlanPayload payload) {
        if (payload.getId() == null || payload.getId() < 0) {
            throw TwException.error("1", "拜访计划id有误");
        }
        //只有创建人可以修改计划 只有计划下的任务都是未开始状态才可以修改计划
        Boolean rolePermission = cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SYS.getCode()));
        if (!rolePermission) {
            Long userId = GlobalUtil.getLoginUserId();
            VisitPlanVO vo = visitPlanDAO.findByKey(payload.getId());
            if (!userId.equals(vo.getCreateUserId())) {
                throw TwException.error("1", "只有创建人可以修改计划，当前登陆用户不是创建人");
            }
        }

        long count = visitTaskService.countByPlanId(payload.getId());
        if (count > 0) {
            throw TwException.error("1", "该计划下的任务已经开始执行，不能修改计划");
        }
        //拜访人员和协访人员id排序后存入扩展字段中
        saveVisitPersonStr(payload);
        long l = visitPlanDAO.updateByKeyDynamic(payload);

        //更新明细信息
        visitPlanDetailDAO.deleteByVisitPlanId(payload.getId());
        //存储人员明细
        saveVisitPlanDetail(payload.getVisitPersonList(), payload.getId(), VisitTaskPlanPersonTypeEnum.visit_person.getCode());
        saveVisitPlanDetail(payload.getAccompanyPersonList(), payload.getId(), VisitTaskPlanPersonTypeEnum.accompany_person.getCode());
        //同步修改任务
        visitTaskService.generateTaskByPlanId(payload.getId());
        // todo 同步修改消息的定时任务
        List<PrdMessageConfigDO> prdMessageConfigDOS = repoMessage.findByObjectIdAndAction(payload.getId(), "visitPlan");
        prdMessageConfigDOS.stream()
                .filter(prdMessageConfigDO -> !"新建拜访计划".equals(prdMessageConfigDO.getMessageTitle()))   // 过滤掉”新建拜访计划的消息“
                .forEach(prdMessageConfigDO -> {
                    if ("拜访任务提醒".equals(prdMessageConfigDO.getMessageTitle())) {    //设置”拜访任务提醒“的通知资源
                        List<Long> visitPersonList = payload.getVisitPersonList();      //拜访成员
                        StringJoiner noticeSource = new StringJoiner(",");
                        if (visitPersonList != null && visitPersonList.size() > 0)
                            visitPersonList.forEach(userId -> noticeSource.add(userId + ""));
                        else noticeSource.setEmptyValue("");
                        prdMessageConfigDO.setNoticeSource(String.valueOf(noticeSource));
                    } else if ("协访提醒".equals(prdMessageConfigDO.getMessageTitle())) {        //设置”协访提醒“的通知资源
                        List<Long> accompanyPersonList = payload.getAccompanyPersonList();    // 协访成员
                        StringJoiner noticeSource = new StringJoiner(",");
                        if (accompanyPersonList != null && accompanyPersonList.size() > 0)
                            accompanyPersonList.forEach(userId -> noticeSource.add(userId + ""));
                        else noticeSource.setEmptyValue("");
                        prdMessageConfigDO.setNoticeSource(String.valueOf(noticeSource));
                    }
                    // 判断消息有没有被发送过，发送过了就重新发送，否则就修改
                    if (prdMessageConfigDO.getReleaseStatus() == 3) {
                        if (!"".equals(prdMessageConfigDO.getNoticeSource())    // 如果通知资源为”“，就不需要再重新发送消息了
                                && !payload.getRemindTime().truncatedTo(ChronoUnit.HOURS).isEqual(prdMessageConfigDO.getTriggerTime().truncatedTo(ChronoUnit.HOURS))) { // 如果提醒时间没变化，也不需要重新发消息
                            PrdMessageConfigDO ado = new PrdMessageConfigDO();  //要发送的消息
                            BeanUtils.copyProperties(prdMessageConfigDO, ado);
                            ado.setTriggerTime(payload.getRemindTime());
                            ado.setId(null);
                            ado.setReleaseStatus(0);
                            String code = generateSeqNum("MESSAGE_CONFIG_NO");
                            ado.setMessageCode(code);
                            ado.setCreateTime(null);
                            PrdMessageConfigDO save = prdMessageConfigRepo.save(ado);
                            XxlJobInfo xxlJobInfo = new XxlJobInfo();
                            xxlJobInfo.setAuthor(save.getCreator());
                            xxlJobInfo.setJobGroup(3);
                            xxlJobInfo.setJobCron(save.getTriggerTimeExpression());
                            xxlJobInfo.setJobDesc(save.getMessageTitle());
                            xxlJobInfo.setExecutorHandler(CmadCronTask.messageXxlJobValue);
                            xxlJobInfo.setExecutorParam(save.getId() + "");
                            xxlJobInfo.setTriggerStatus(save.getIsEnable() == 0 ? 1 : 0);
                            prdMessageConfigDAO.saveXxlJob(xxlJobInfo);
                        }
                    } else {
                        prdMessageConfigDO.setTriggerTime(payload.getRemindTime());
                        messageConfigService.update(PrdMessageConfigConvert.INSTANCE.toPayload(prdMessageConfigDO));
                    }
                });
        return l;
    }

    @Override
    @Transactional(rollbackFor = RuntimeException.class)
    public long completeVisitPlan(Long visitPlanId) {
        if (visitPlanId == null) {
            throw TwException.error("1", "拜访计划id不能为空");
        }
        return visitPlanDAO.completeVisitPlan(visitPlanId);
    }

    @Override
    @Transactional(rollbackFor = RuntimeException.class)
    public void deleteSoft(List<Long> keys) {
        //只有创建人可以删除计划 前端控制

        // 校验任务状态
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                final VisitPlanVO visitPlanVO = visitPlanDAO.queryByKey(id);
                if (!visitPlanVO.getCreateUserId().equals(GlobalUtil.getLoginUserId())) {
                    throw TwException.error("1", "只有创建人可以删除计划，当前登陆用户不是创建人");
                }
                long count = visitTaskService.countByPlanId(id);
                if (count > 0) {
//                    throw TwException.error("1", "该计划【" + visitPlanVO.getVisitPlanName() + "】下的任务已开始/已完成，不能删除");
                    throw TwException.error("1", "拜访任务已开始/已完成，不能删除拜访计划");
                }
            });
        }
        if (!keys.isEmpty()) {
            visitPlanDAO.deleteSoft(keys);
            // 删除拜访任务
            keys.stream().forEach(id -> {
                visitTaskService.deleteSoftByPlanId(id);
            });

        }
    }

//    @Override
//    @Transactional
//    public int verifyVisitPlanName(String visitPlanName) {
//        //验证重名数据 返回重名数据的数量
//        if (StringUtils.hasText(visitPlanName)){
//            return visitPlanDAO.verifyVisitPlanName(visitPlanName);
//        }
//        return 0;
//    }

    @Override
    public Map<String, Integer> visitPlanCount() {
        Map<String, Integer> result = new HashMap<>();

        //数据权限相关
        VisitPlanQuery query = new VisitPlanQuery();
        dataPermissionFlag(query);
        //拜访人员处理
        if (query.getVisitPerson()!=null){
            query.setVisitPersonNameStr(query.getVisitPerson()+",");
        }
        if (query.getAccompanyPerson()!=null){
            query.setAccompanyPersonNameStr(query.getAccompanyPerson()+",");
        }
        //总拜访计划
        List<VisitPlanVO> visitPlans = visitPlanDAO.queryListDynamic(query);
        result.put("visitPlan_count", visitPlans.size());

        //待完成计划
        long count = visitPlans.stream()
                .filter(e -> e.getVisitPlanStatus().equals(VisitTaskPlanStatusEnum.incomplete.getCode()))
                .count();
        result.put("incomplete_VisitPlan_count", (int) count);


        //常规、周期、销访计划
        Map<String, Long> collect = visitPlans.stream()
                .collect(Collectors.groupingBy(VisitPlanVO::getVisitPlanType, Collectors.counting()));
        // collect.forEach((k,v)->result.put(k+"_count",v.intValue()));
        //循环枚举类 返回常规、周期、销访计划
        Arrays.stream(VisitTaskPlanTypeEnum.values()).forEach(key -> {
            if (collect.containsKey(key.getCode())) {
                result.put(key.getCode() + "_count", collect.get(key.getCode()).intValue());
            } else {
                result.put(key.getCode() + "_count", 0);

            }
        });
        return result;
    }

    @Override
    public String getVisitCustomAddress(Long bookId) {
        BookAddressVO bookAddressVO = bookAddressService.queryDefaultByBookId(bookId);
        if (bookAddressVO == null) {
            return null;
        }
        return bookAddressVO.getDetailAddress();
    }

    @Override
    public List<BookAddressVO> getVisitCustomAddressList(Long bookId) {
        List<BookAddressVO> bookAddressVOS = bookAddressService.queryByBookId(bookId);
        if (bookAddressVOS == null) {
            return null;
        }
        return bookAddressVOS;
    }

    @Override
    public List<Map<String, Object>> visitCustomRelationInfo(Long partnerId, String objType) {
        // 线索
        if (VisitTaskPlanObjTypeEnum.LEAD.getCode().equals(objType)) {
            // CrmCustomerVO crmCustomerVO = customerService.queryDetail(partnerId);
            BusinessPartnerVO businessPartnerVO = businessPartnerService.queryByKey(partnerId);
            String customerName = businessPartnerVO.getPartnerName();
            List<CrmLeadsListVO> crmLeadsListVOS = leadsService.queryListByCustomName(customerName);
            List<Map<String, Object>> list = crmLeadsListVOS.stream().map(e -> {
                Map<String, Object> result = new HashMap<>();
                result.put("id", e.getId());
                result.put("name", e.getLeadsName());
                return result;
            }).toList();
            return list;
        } else if (VisitTaskPlanObjTypeEnum.OPPO.getCode().equals(objType)) {
            List<CrmActProjectVO> crmActProjectVOS = opportunityService.queryListByCustomId(partnerId);
            List<Map<String, Object>> list = crmActProjectVOS.stream().map(e -> {
                Map<String, Object> result = new HashMap<>();
                result.put("id", e.getId());
                result.put("name", e.getProjectName());
                return result;
            }).toList();
            return list;
        } else {
            CrmCustomerOperationQuery crmCustomerOperationQuery = new CrmCustomerOperationQuery();
            crmCustomerOperationQuery.setCustomerId(partnerId);
            List<CrmCustomerOperationVO> crmCustomerOperationVOS = crmCustomerOperationService.queryList(crmCustomerOperationQuery);
            if (!CollectionUtils.isEmpty(crmCustomerOperationVOS)) {
                CrmOperationPlanDetailQuery crmOperationPlanDetailQuery = new CrmOperationPlanDetailQuery();
                List<Long> collect = crmCustomerOperationVOS.stream().map(p -> p.getId()).collect(Collectors.toList());
                crmOperationPlanDetailQuery.setOperIdList(collect);
                List<CrmOperationPlanDetailVO> operationPlanByCustomId = crmOperationPlanDetailService.queryList(crmOperationPlanDetailQuery);
                List<Map<String, Object>> list = operationPlanByCustomId.stream().map(e -> {
                    Map<String, Object> result = new HashMap<>();
                    result.put("id", e.getId());
                    result.put("name", e.getPlanName());
                    return result;
                }).toList();
                return list;
            }

            return null;
        }
    }

    //权限处理
    private void dataPermissionFlag(VisitPlanQuery query) {
        Long userId = GlobalUtil.getLoginUserId();
        Boolean rolePermission = cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SYS.getCode(),RoleEnum.OPS.getCode(), RoleEnum.PLAT_BUSINESS_PIC.getCode(), RoleEnum.PLAT_ALL_PIC.getCode(), RoleEnum.SALE_VISIT_PIC.getCode(), RoleEnum.SALE_ADMIN.getCode()));
        query.setPermissionFlag(!rolePermission);
        if (!rolePermission) {
            query.setLoginUserId(userId);
        }

    }
}
