package com.elitesland.tw.tw5.server.prd.humanresources.ability.service;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdLevelConfigDtlPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdLevelConfigPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdLevelConfigDtlQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdLevelConfigQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdLevelConfigDtlService;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdLevelConfigService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdLevelConfigDtlVO;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdLevelConfigVO;
import com.elitesland.tw.tw5.server.prd.humanresources.ability.entity.PrdLevelConfigDO;

import com.elitesland.tw.tw5.server.prd.humanresources.ability.dao.PrdLevelConfigDtlDao;
import com.elitesland.tw.tw5.server.prd.humanresources.ability.repo.PrdLevelConfigRepo;
import com.elitesland.tw.tw5.server.prd.humanresources.ability.dao.PrdLevelConfigDao;


import com.elitesland.tw.tw5.server.prd.humanresources.convert.PrdLevelConfigConvert;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.collection.CollectionUtil;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;


/**
 * @author : WWW
 * @date : 2023-10-18
 * @desc : 级别维护表Service
 */

@Slf4j
@Service
@RequiredArgsConstructor
public class PrdLevelConfigServiceImpl implements PrdLevelConfigService {


    private final PrdLevelConfigDao prdLevelConfigDao;

    private final PrdLevelConfigRepo prdLevelConfigRepo;

    private final PrdLevelConfigDtlDao prdLevelConfigDtlDao;

    private final PrdLevelConfigDtlService prdLevelConfigDtlService;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PrdLevelConfigVO save(PrdLevelConfigPayload prdLevelConfigPayload) {

        checkData(prdLevelConfigPayload);
        if (null==prdLevelConfigPayload.getId()){
            // 校验名称重复
            PrdLevelConfigQuery prdLevelConfigQuery = new PrdLevelConfigQuery();
            prdLevelConfigQuery.setName(prdLevelConfigPayload.getName());
            Long count = prdLevelConfigDao.count(prdLevelConfigQuery);
            if (count > 0) {
                throw new BusinessException("级别名称重复，请检查");
            }
        }
        // 明细编号唯一
        List<PrdLevelConfigDtlPayload> prdLevelConfigDtlPayloadList = prdLevelConfigPayload.getPrdLevelConfigDtlPayloadList();
        List<String> docNoList = prdLevelConfigDtlPayloadList.stream().map(x -> x.getDocNo()).collect(Collectors.toList());
        Set<String> hdocNoSet = new HashSet<>(docNoList);
        if (hdocNoSet.size() != docNoList.size()) {
            throw new BusinessException("明细编号不能重复");
        }
        // 明细名称唯一
        List<String> nameList = prdLevelConfigDtlPayloadList.stream().map(x -> x.getName()).collect(Collectors.toList());
        Set<String> hnameSet = new HashSet<>(nameList);
        if (hnameSet.size() != nameList.size()) {
            throw new BusinessException("明细名称不能重复");
        }
        PrdLevelConfigDO prdLevelConfigDO = new PrdLevelConfigDO();
        prdLevelConfigDO = PrdLevelConfigConvert.INSTANCE.p2d(prdLevelConfigPayload);
        // 设置仅有一条默认为是
        if (prdLevelConfigDO.getDefFlag()) {
            changeDef();
        }
        PrdLevelConfigDO res = prdLevelConfigRepo.save(prdLevelConfigDO);

        // 明细信息
        for (PrdLevelConfigDtlPayload dtlPayload : prdLevelConfigPayload.getPrdLevelConfigDtlPayloadList()) {
            dtlPayload.setMasId(res.getId());
            prdLevelConfigDtlService.save(dtlPayload);
        }
        return PrdLevelConfigConvert.INSTANCE.d2v(res);

    }

    @Transactional(rollbackFor = Exception.class)
    public void changeDef() {
        prdLevelConfigDao.changeDef();
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public PrdLevelConfigVO update(PrdLevelConfigPayload prdLevelConfigPayload) {

        Assert.notNull(prdLevelConfigPayload.getId(), "id is null");
        // 校验级别名称重复
        PrdLevelConfigVO prdLevelConfigVO = get(prdLevelConfigPayload.getId());
        if (!prdLevelConfigVO.getName().equals(prdLevelConfigPayload.getName())) {
            // 校验名称重复
            PrdLevelConfigQuery prdLevelConfigQuery = new PrdLevelConfigQuery();
            prdLevelConfigQuery.setName(prdLevelConfigPayload.getName());
            Long count = prdLevelConfigDao.count(prdLevelConfigQuery);
            if (count > 0) {
                throw new BusinessException("级别名称重复，请检查");
            }
        }
        // 更新明细信息
        prdLevelConfigDtlService.delByMasId(prdLevelConfigPayload.getId());
        PrdLevelConfigVO res = save(prdLevelConfigPayload);

        return res;

    }


    @Override
    public PrdLevelConfigVO get(Long id) {

        if (null == id) {
            return null;
        }
        PrdLevelConfigVO res = prdLevelConfigDao.get(id);
        // 查询明细信息
        PrdLevelConfigDtlQuery prdLevelConfigDtlQuery = new PrdLevelConfigDtlQuery();
        prdLevelConfigDtlQuery.setMasId(id);
        List<PrdLevelConfigDtlVO> dtlVOList = prdLevelConfigDtlDao.getList(prdLevelConfigDtlQuery);
        res.setPrdLevelConfigDtlVOList(dtlVOList);
        return res;

    }


    @Override
    public PagingVO<PrdLevelConfigVO> page(PrdLevelConfigQuery prdLevelConfigQuery) {

        PagingVO<PrdLevelConfigVO> res = prdLevelConfigDao.page(prdLevelConfigQuery);
        return res;

    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long del(List<Long> ids) {

        if (CollectionUtil.isEmpty(ids)) {
            return 0L;
        }
        Long res = prdLevelConfigDao.del(ids);
        return res;

    }

    @Override
    public List<PrdLevelConfigVO> getList(PrdLevelConfigQuery prdLevelConfigQuery) {
        prdLevelConfigQuery.setState(1);
        List<PrdLevelConfigVO> res = prdLevelConfigDao.getList(prdLevelConfigQuery);
        return res;
    }


    /**
     * 数据校验
     *
     * @param prdLevelConfigPayload
     */
    private void checkData(PrdLevelConfigPayload prdLevelConfigPayload) {

        if (StringUtils.isBlank(prdLevelConfigPayload.getName())) {
            throw new BusinessException("名称不能为空");
        }

    }


}

