package com.elitesland.tw.tw5.server.prd.humanresources.basebu.entity;

import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import lombok.Data;
import org.hibernate.annotations.Where;
import com.elitescloud.boot.model.entity.BaseModel;


 /**
 * @author : WWW
 * @date : 2023-11-7
 * @desc : baseBU变更待办事项
 */
 
@Entity
@Table(name="prd_bu_change_todo")
@org.hibernate.annotations.Table(appliesTo = "prd_bu_change_todo", comment = "baseBU变更待办事项")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0")
public class PrdBuChangeTodoDO extends BaseModel {


    /**
     * 变更主键
     */
    @Column(name = "change_id", columnDefinition = "bigint(20) comment '变更主键'")
    private Long changeId;
    
    /**
     * 检查事项
     */
    @Column(name = "todo_title", columnDefinition = "int(11) comment '检查事项'")
    private Integer todoTitle;
    
    /**
     * 检查说明
     */
    @Column(name = "todo_desc", columnDefinition = "int(11) comment '检查说明'")
    private Integer todoDesc;
    
    /**
     * 状态
     */
    @Column(name = "state", columnDefinition = "int(11) comment '状态'")
    private Integer state;
    
    /**
     * 备注
     */
    @Column(name = "todo_remark", columnDefinition = "varchar(255) comment '备注'")
    private String todoRemark;
    

}

