package com.elitesland.tw.tw5.server.prd.humanresources.examination.entity;

import com.elitesland.tw.tw5.server.prd.humanresources.base.WorkflowBaseDO;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalDate;

import org.hibernate.annotations.Where;
import com.elitescloud.boot.model.entity.BaseModel;


/**
 * @author : WWW
 * @date : 2023-11-15
 * @desc : 绩效考核结果
 */

@Entity
@Table(name = "prd_performance_exam_result")
@org.hibernate.annotations.Table(appliesTo = "prd_performance_exam_result", comment = "绩效考核结果")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0")
public class PrdPerformanceExamResultDO extends WorkflowBaseDO {


    /**
     * 绩效考核id
     */
    @Column(name = "exam_id", columnDefinition = "bigint(20) comment '绩效考核id'")
    private Long examId;

    /**
     * 考核名称
     */
    @Column(name = "exam_name", columnDefinition = "varchar(255) comment '考核名称'")
    private String examName;

    /**
     * 考核开始时间
     */
    @Column(name = "exam_start_period", columnDefinition = "date comment '考核开始时间'")
    private LocalDate examStartPeriod;

    /**
     * 考核结束时间
     */
    @Column(name = "exam_end_period", columnDefinition = "date comment '考核结束时间'")
    private LocalDate examEndPeriod;

    /**
     * 考核员工资源id
     */
    @Column(name = "emp_id", columnDefinition = "bigint(20) comment '考核员工资源id'")
    private Long empId;

    /**
     * 考核员工资源名称
     */
    @Column(name = "emp_name", columnDefinition = "varchar(255) comment '考核员工资源名称'")
    private String empName;

    /**
     * 考核用户id
     */
    @Column(name = "user_id", columnDefinition = "bigint(20) comment '考核用户id'")
    private Long userId;

    /**
     * 资源类型
     */
    @Column(name = "res_type", columnDefinition = "varchar(50) comment '资源类型'")
    private String resType;

    /**
     * BaseBu
     */
    @Column(name = "base_bu_id", columnDefinition = "bigint(20) comment 'BaseBu'")
    private Long baseBuId;

    /**
     * BaseBu
     */
    @Column(name = "base_bu_name", columnDefinition = "varchar(255) comment 'BaseBu'")
    private String baseBuName;

    /**
     * 合作方式
     */
    @Column(name = "coop_type", columnDefinition = "varchar(50) comment '合作方式'")
    private String coopType;

    /**
     * 考核说明
     */
    @Column(name = "exam_desc", columnDefinition = "varchar(2000) comment '考核说明'")
    private String examDesc;

    /**
     * 考核发起人id
     */
    @Column(name = "exam_creat_user_id", columnDefinition = "bigint(20) comment '考核发起人id'")
    private Long examCreatUserId;

    /**
     * 考核发起人
     */
    @Column(name = "exam_creat_user", columnDefinition = "varchar(255) comment '考核发起人'")
    private String examCreatUser;

    /**
     * 考核发起时间
     */
    @Column(name = "exam_creat_time", columnDefinition = "datetime(6) comment '考核发起时间'")
    private LocalDateTime examCreatTime;

    /**
     * 评分结果
     */
    @Column(name = "score_res", columnDefinition = "decimal(20,2) comment '评分结果'")
    private BigDecimal scoreRes;

    /**
     * 等级结果
     */
    @Column(name = "grade_res", columnDefinition = "varchar(255) comment '等级结果'")
    private String gradeRes;

    /**
     * 最终评分说明
     */
    @Column(name = "score_final_desc", columnDefinition = "varchar(2000) comment '最终评分说明'")
    private String scoreFinalDesc;

    /**
     * 状态
     */
    @Column(name = "state", columnDefinition = "varchar(255) comment '状态'")
    private String state;

    /**
     * 流程编号
     */
    @Column(name = "flow_doc_no", columnDefinition = "varchar(255) comment '流程编号'")
    private String flowDocNo;

    /**
     * 分数下限
     */
    @Column(name = "score_min", columnDefinition = "decimal(20,2) comment '分数下限'")
    private BigDecimal scoreMin;

    /**
     * 分数上限
     */
    @Column(name = "score_max", columnDefinition = "decimal(20,2) comment '分数上限'")
    private BigDecimal scoreMax;

    /**
     * 考核范围id
     */
    @Column(name = "range_id", columnDefinition = "bigint(20) comment '考核范围id'")
    private Long rangeId;
}

