package com.elitesland.tw.tw5.server.prd.humanresources.resource.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitesland.workflow.enums.ProcInstStatus;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

@Entity
@Table(name = "external_res_apply")
@org.hibernate.annotations.Table(appliesTo = "external_res_apply", comment = "外部资源引入申请表")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0")
public class ExternalResApplyDO extends BaseModel {

    @Comment("personId")
    @Column()
    private Long personId;

    @Comment("员工ID")
    @Column()
    private Long employeeId;

    @Comment("姓名")
    @Column()
    private String personName;

    @Comment("性别")
    @Column()
    private String sex;

    @Comment("手机号")
    @Column()
    private String mobile;

    @Comment("资源类型一")
    @Column()
    private String resType1;

    @Comment("资源类型二")
    @Column()
    private String resType2;

    @Comment("BaseBu")
    @Column()
    private Long orgId;

    @Comment("BaseBu名称")
    @Column()
    private String orgName;

    @Comment("上级id")
    @Column()
    private Long parentId;

    @Comment("合作方式")
    @Column()
    private String cooperationMode;

    @Comment("结算方式")
    @Column()
    private String settleMethod;

    @Comment("单位当量收入")
    @Column()
    private Double preeqvaAmt;

    @Comment("当量系数")
    @Column()
    private BigDecimal eqvaRatio;

    @Comment("是否开通邮箱")
    @Column()
    private Boolean emailFlag;

    @Comment("是否开通E-learning账号")
    @Column()
    private Boolean elpFlag;

    @Comment("邮箱")
    @Column()
    private String email;

    @Comment("E-learning账号")
    @Column()
    private String elpId;

    @Comment("tw账号")
    @Column()
    private String twId;

    @Comment("入职类型")
    @Column()
    private String entryType;

    @Comment("长期/短期")
    @Column()
    private String periodFlag;

    @Comment("预计入场时间")
    @Column()
    private LocalDate expectedStartDate;

    @Comment("预计离场时间")
    @Column()
    private LocalDate expectedEndDate;

    @Comment("岗位分类一")
    @Column()
    private String jobClass1;

    @Comment("岗位分类二")
    @Column()
    private String jobClass2;

    @Comment("复合能力")
    @Column()
    private Long capasetLevelId;

    @Comment("流程实例ID")
    @Column()
    private String procInstId;

    @Comment("流程审批状态")
    @Column()
    @Enumerated(EnumType.STRING)
    private ProcInstStatus procInstStatus;

    @Comment("审批时间")
    @Column()
    private LocalDateTime approvedTime;

    @Comment("员工编号")
    @Column()
    private String employeeNo;

}
