package com.elitesland.tw.tw5.server.prd.inv.service;


import com.elitesland.tw.tw5.api.prd.inv.payload.InvInvoiceAttachedPayload;
import com.elitesland.tw.tw5.api.prd.inv.query.InvInvoiceAttachedQuery;
import com.elitesland.tw.tw5.api.prd.inv.service.InvInvoiceAttachedService;
import com.elitesland.tw.tw5.api.prd.inv.vo.InvInvoiceAttachedVO;
import com.elitesland.tw.tw5.server.prd.inv.convert.InvInvoiceAttachedConvert;
import com.elitesland.tw.tw5.server.prd.inv.dao.InvInvoiceAttachedDAO;
import com.elitesland.tw.tw5.server.prd.inv.entity.InvInvoiceAttachedDO;
import com.elitesland.tw.tw5.server.prd.inv.repo.InvInvoiceAttachedRepo;
import org.springframework.stereotype.Service;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import org.springframework.transaction.annotation.Transactional;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import javax.servlet.http.HttpServletResponse;
import java.util.*;

/**
 * 发票扩展表
 *
 * @author zoey
 * @date 2023-12-06
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class InvInvoiceAttachedServiceImpl extends BaseServiceImpl implements InvInvoiceAttachedService {

    private final InvInvoiceAttachedRepo invInvoiceAttachedRepo;
    private final InvInvoiceAttachedDAO invInvoiceAttachedDAO;

    @Override
    public PagingVO<InvInvoiceAttachedVO> queryPaging(InvInvoiceAttachedQuery query){
        return invInvoiceAttachedDAO.queryPaging(query);
    }

    @Override
    public List<InvInvoiceAttachedVO> queryListDynamic(InvInvoiceAttachedQuery query){
        return invInvoiceAttachedDAO.queryListDynamic(query);
    }

    @Override
    public InvInvoiceAttachedVO queryByKey(Long key) {
        InvInvoiceAttachedDO entity = invInvoiceAttachedRepo.findById(key).orElseGet(InvInvoiceAttachedDO::new);
        Assert.notNull(entity.getId(), "不存在");
        InvInvoiceAttachedVO vo = InvInvoiceAttachedConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public InvInvoiceAttachedVO insert(InvInvoiceAttachedPayload payload) {
        InvInvoiceAttachedDO entityDo = InvInvoiceAttachedConvert.INSTANCE.toDo(payload);
        return InvInvoiceAttachedConvert.INSTANCE.toVo(invInvoiceAttachedRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public InvInvoiceAttachedVO update(InvInvoiceAttachedPayload payload) {
        InvInvoiceAttachedDO entity = invInvoiceAttachedRepo.findById(payload.getId()).orElseGet(InvInvoiceAttachedDO::new);
        Assert.notNull(entity.getId(), "不存在");
        InvInvoiceAttachedDO entityDo = InvInvoiceAttachedConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return InvInvoiceAttachedConvert.INSTANCE.toVo(invInvoiceAttachedRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(InvInvoiceAttachedPayload payload) {
        InvInvoiceAttachedDO entity = invInvoiceAttachedRepo.findById(payload.getId()).orElseGet(InvInvoiceAttachedDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = invInvoiceAttachedDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            invInvoiceAttachedDAO.deleteSoft(keys);
        }
    }

}
