package com.elitesland.tw.tw5.server.prd.my.controller;

import com.elitesland.tw.tw5.api.prd.my.payload.AbnormalWorkApplyDetailPayload;
import com.elitesland.tw.tw5.api.prd.my.query.AbnormalWorkApplyDetailQuery;
import com.elitesland.tw.tw5.api.prd.my.vo.AbnormalWorkApplyDetailVO;
import com.elitesland.tw.tw5.api.prd.my.service.AbnormalWorkApplyDetailService;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import com.elitescloud.cloudt.common.base.PagingVO;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 远程办公申请明细
 *
 * @folder 远程办公申请明细
 * @author wangly
 * @date 2024-06-12
 */
@Api(tags = "远程办公申请明细")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/abnormalWorkApplyDetail")
@Slf4j
public class AbnormalWorkApplyDetailController {

private final AbnormalWorkApplyDetailService abnormalWorkApplyDetailService;

    /**
     * 远程办公申请明细-新增
     *
     * @folder 远程办公申请明细
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("远程办公申请明细-新增")
    public TwOutputUtil<AbnormalWorkApplyDetailVO> insert(@RequestBody AbnormalWorkApplyDetailPayload payload){
         return TwOutputUtil.ok(abnormalWorkApplyDetailService.insert(payload));
    }

    /**
     * 远程办公申请明细-更新
     *
         * @folder 远程办公申请明细
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("远程办公申请明细-更新")
    public TwOutputUtil<AbnormalWorkApplyDetailVO> update(@RequestBody AbnormalWorkApplyDetailPayload payload){
        return TwOutputUtil.ok(abnormalWorkApplyDetailService.update(payload));
    }

    /**
     * 远程办公申请明细-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @folder 远程办公申请明细
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("远程办公申请明细-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody AbnormalWorkApplyDetailPayload payload){
        return TwOutputUtil.ok(abnormalWorkApplyDetailService.updateByKeyDynamic(payload));
    }

    /**
     * 远程办公申请明细-主键查询
     *
     * @folder 远程办公申请明细
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    @UdcNameClass
    @ApiOperation("远程办公申请明细-主键查询")
    public TwOutputUtil<AbnormalWorkApplyDetailVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(abnormalWorkApplyDetailService.queryByKey(key));
    }

    /**
     * 远程办公申请明细-分页
     *
         * @folder 远程办公申请明细
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    @UdcNameClass
    @ApiOperation("远程办公申请明细-分页")
    public TwOutputUtil<PagingVO<AbnormalWorkApplyDetailVO>> paging(AbnormalWorkApplyDetailQuery query) {
        return TwOutputUtil.ok(abnormalWorkApplyDetailService.queryPaging(query));
    }

    /**
     * 远程办公申请明细-查询列表
     *
     * @folder 远程办公申请明细
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    @UdcNameClass
    @ApiOperation("远程办公申请明细-查询列表")
    public TwOutputUtil<List<AbnormalWorkApplyDetailVO>> queryList(AbnormalWorkApplyDetailQuery query) {
        return TwOutputUtil.ok(abnormalWorkApplyDetailService.queryListDynamic(query));
    }

    /**
     * 远程办公申请明细-删除
     *
         * @folder 远程办公申请明细
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("远程办公申请明细-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
         abnormalWorkApplyDetailService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}

