package com.elitesland.tw.tw5.server.prd.my.controller;

import com.elitesland.tw.tw5.api.prd.my.query.MobAttendanceRuleQuery;
import com.elitesland.tw.tw5.api.prd.my.service.TAttendanceRuleService;
import com.elitesland.tw.tw5.api.prd.my.vo.MobAttendanceRuleVO;
import com.elitesland.tw.tw5.api.prd.my.vo.MobAttendanceVO;
import com.elitesland.tw.tw5.api.prd.my.vo.TAttendanceNormalVO;
import com.elitesland.tw.tw5.api.prd.my.vo.TAttendanceRuleVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.web.bind.annotation.*;

import java.time.LocalDate;
import java.util.List;

@Api(tags = "打卡规则")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/tAttendanceRules")
@Slf4j
public class TAttendanceRulesController {

    private final TAttendanceRuleService attendanceRuleService;


    /**
     * 获取打卡规则列表
     */
    @GetMapping("/list")
    @ApiOperation("获取打卡规则列表")
    public TwOutputUtil<List<TAttendanceRuleVO>> getResAttendanceRuleList() {
        return TwOutputUtil.ok(attendanceRuleService.getAttendanceRule());
    }


    /**
     * 获取当前人所有的打卡规则
     */
    @GetMapping("/getCurrentUser")
    @ApiOperation("获取当前人所有的打卡规则")
    public TwOutputUtil<List<MobAttendanceRuleVO>> getResAttendanceRule() {
        Long userId = GlobalUtil.getLoginUserId();
        return TwOutputUtil.ok(attendanceRuleService.getAttendanceRule(userId));
    }


    @PutMapping("/attendance/res/todayAttendanceData")
    @ApiOperation("资源打卡签到")
    public TwOutputUtil resTodayAttendance(@RequestBody MobAttendanceVO vo) {
        Long userId = GlobalUtil.getLoginUserId();
        vo.setAttendanceResId(userId);
        return TwOutputUtil.ok(attendanceRuleService.resAttendanceInfo(vo));
    }

    @GetMapping("/attendance/res/todayAttendanceData")
    @ApiOperation("获取当前人今日打卡数据")
    public TwOutputUtil getResTodayAttendanceData() {
        Long userId = GlobalUtil.getLoginUserId();
        LocalDate attendanceDate = LocalDate.now();
        return TwOutputUtil.ok(attendanceRuleService.getResAttendanceInfo(userId, attendanceDate));
    }


    @GetMapping("/attendance/res/log")
    @ApiOperation("资源打卡记录")
    public TwOutputUtil getResAttendanceRule(MobAttendanceRuleQuery query) {
        Long userId = GlobalUtil.getLoginUserId();
        return TwOutputUtil.ok(attendanceRuleService.resAttendanceLog(userId, query.getAttendanceDateStart(), query.getAttendanceDateEnd()));
    }

    /**
     * 打卡异常更新说明
     */
    @PutMapping("/attendance/res/reason")
    @ApiOperation("打卡异常更新说明")
    public TwOutputUtil getResAttendanceRule(TAttendanceNormalVO vo) {
        return TwOutputUtil.ok(attendanceRuleService.resAttendanceReason(vo));
    }


    /**
     * 打卡结果更新
     */
    @PostMapping("/attendance/information/update")
    @ApiOperation("打卡结果更新")
    public TwOutputUtil updateAttendacneInformation(@DateTimeFormat(pattern = "yyyy-MM-dd") LocalDate date) {
        attendanceRuleService.updateAttendanceInformation(date);
        return TwOutputUtil.ok();
    }
}
