package com.elitesland.tw.tw5.server.prd.my.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.TDeviceApplyPayload;
import com.elitesland.tw.tw5.api.prd.my.query.TDeviceApplyQuery;
import com.elitesland.tw.tw5.api.prd.my.service.TDeviceApplyService;
import com.elitesland.tw.tw5.api.prd.my.vo.TDeviceApplyVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.seata.spring.annotation.GlobalTransactional;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 自购电脑申请
 *
 * @author lemon
 * @date 2023-09-19
 */
@Api(tags = "自购电脑申请")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/tDeviceApply")
@Slf4j
public class TDeviceApplyController {

private final TDeviceApplyService tDeviceApplyService;

    /**
     * 自购电脑申请-新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @GlobalTransactional
    @ApiOperation("自购电脑申请-新增")
    public TwOutputUtil<TDeviceApplyVO> insert(@RequestBody TDeviceApplyPayload payload){
         return TwOutputUtil.ok(tDeviceApplyService.insert(payload));
    }

    /**
     * 自购电脑申请-更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("自购电脑申请-更新")
    public TwOutputUtil<TDeviceApplyVO> update(@RequestBody TDeviceApplyPayload payload){
        return TwOutputUtil.ok(tDeviceApplyService.update(payload));
    }

    /**
     * 自购电脑申请-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("自购电脑申请-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody TDeviceApplyPayload payload){
        return TwOutputUtil.ok(tDeviceApplyService.updateByKeyDynamic(payload));
    }

    /**
     * 自购电脑申请-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    @UdcNameClass
    @ApiOperation("自购电脑申请-主键查询")
    public TwOutputUtil<TDeviceApplyVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(tDeviceApplyService.queryByKey(key));
    }

    /**
     * 自购电脑申请-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
     @UdcNameClass
    @ApiOperation("自购电脑申请-分页")
    public TwOutputUtil<PagingVO<TDeviceApplyVO>> paging(TDeviceApplyQuery query) {
        return TwOutputUtil.ok(tDeviceApplyService.queryPaging(query));
    }

    /**
     * 自购电脑申请-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
     @UdcNameClass
    @ApiOperation("自购电脑申请-查询列表")
    public TwOutputUtil<List<TDeviceApplyVO>> queryList(TDeviceApplyQuery query) {
        return TwOutputUtil.ok(tDeviceApplyService.queryListDynamic(query));
    }

    /**
     * 自购电脑申请-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("自购电脑申请-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
         tDeviceApplyService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}

