package com.elitesland.tw.tw5.server.prd.my.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.TDeviceApplyPayload;
import com.elitesland.tw.tw5.api.prd.my.query.TDeviceApplyQuery;
import com.elitesland.tw.tw5.api.prd.my.vo.TDeviceApplyVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.my.entity.QTDeviceApplyDO;
import com.elitesland.tw.tw5.server.prd.my.entity.TDeviceApplyDO;
import com.elitesland.tw.tw5.server.prd.my.repo.TDeviceApplyRepo;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgEmployeeDO;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 自购电脑申请
 *
 * @author lemon
 * @date 2023-09-19
 */
@Repository
@RequiredArgsConstructor
public class TDeviceApplyDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final TDeviceApplyRepo repo;
    private final QTDeviceApplyDO qdo = QTDeviceApplyDO.tDeviceApplyDO;

    private final QPrdOrgEmployeeDO orgEmployee = QPrdOrgEmployeeDO.prdOrgEmployeeDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<TDeviceApplyVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(TDeviceApplyVO.class,
                qdo.id,
                //qdo.remark,
                //qdo.createUserId,
                //qdo.creator,
                //qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 申请单号
                qdo.applyNo,
                // 申请状态
                qdo.applyStatus,
                // 申请日期
                qdo.applyDate,
                // 申请人资源ID
                qdo.applyResId,
                // 每月补贴金额
                qdo.monthlyAmt,
                // 票据号
                qdo.billNo,
                // 品牌型号及颜色
                qdo.deviceDesc,
                // 内存
                qdo.memSize,
                // 硬盘
                qdo.hdSize,
                // 购置价格
                qdo.devicePrice,
                // 购置日期
                qdo.buyDate,
                // 补贴起始月份
                qdo.startPeriodId,
                // 申请理由
                qdo.applyDesc,
                // 申请人BU_ID
                qdo.resBuId,
                // 流程实例ID
                qdo.procInstId,
                // 流程审批状态
                qdo.procInstStatus,
                // 提交时间
                qdo.submitTime,
                // 审批时间
                qdo.approvedTime,
                // 附件
                qdo.fileCode,
                orgEmployee.extString5.as("baseCity")
        )).from(qdo).leftJoin(orgEmployee).on(qdo.applyResId.longValue().eq(orgEmployee.userId));
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<TDeviceApplyVO> getJpaQueryWhere(TDeviceApplyQuery query) {
        JPAQuery<TDeviceApplyVO> jpaQuery = getJpaQuerySelect();
        // 条件封装
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(TDeviceApplyQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
                .select(qdo.count())
                .from(qdo);
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(TDeviceApplyQuery query){
        List<Predicate> list = new ArrayList<>();
        /** 记录唯一ID 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 申请单号 精确 */
        if (!ObjectUtils.isEmpty(query.getApplyNo())) {
            list.add(qdo.applyNo.eq(query.getApplyNo()));
        }
        /** 申请状态 精确 */
        if (!ObjectUtils.isEmpty(query.getApplyStatus())) {
            list.add(qdo.applyStatus.eq(query.getApplyStatus()));
        }
        /** 申请日期 精确 */
        if (!ObjectUtils.isEmpty(query.getApplyDate())) {
            list.add(qdo.applyDate.eq(query.getApplyDate()));
        }
        /** 申请人资源ID 精确 */
        if (!ObjectUtils.isEmpty(query.getApplyResId())) {
            list.add(qdo.applyResId.eq(query.getApplyResId()));
        }
        /** 每月补贴金额 精确 */
        if (!ObjectUtils.isEmpty(query.getMonthlyAmt())) {
            list.add(qdo.monthlyAmt.eq(query.getMonthlyAmt()));
        }
        /** 票据号 精确 */
        if (!ObjectUtils.isEmpty(query.getBillNo())) {
            list.add(qdo.billNo.eq(query.getBillNo()));
        }
        /** 品牌型号及颜色 精确 */
        if (!ObjectUtils.isEmpty(query.getDeviceDesc())) {
            list.add(qdo.deviceDesc.eq(query.getDeviceDesc()));
        }
        /** 内存 精确 */
        if (!ObjectUtils.isEmpty(query.getMemSize())) {
            list.add(qdo.memSize.eq(query.getMemSize()));
        }
        /** 硬盘 精确 */
        if (!ObjectUtils.isEmpty(query.getHdSize())) {
            list.add(qdo.hdSize.eq(query.getHdSize()));
        }
        /** 购置价格 精确 */
        if (!ObjectUtils.isEmpty(query.getDevicePrice())) {
            list.add(qdo.devicePrice.eq(query.getDevicePrice()));
        }
        /** 购置日期 精确 */
        if (!ObjectUtils.isEmpty(query.getBuyDate())) {
            list.add(qdo.buyDate.eq(query.getBuyDate()));
        }
        /** 补贴起始月份 精确 */
        if (!ObjectUtils.isEmpty(query.getStartPeriodId())) {
            list.add(qdo.startPeriodId.eq(query.getStartPeriodId()));
        }
        /** 申请理由 精确 */
        if (!ObjectUtils.isEmpty(query.getApplyDesc())) {
            list.add(qdo.applyDesc.eq(query.getApplyDesc()));
        }
        /** 申请人BU_ID 精确 */
        if (!ObjectUtils.isEmpty(query.getResBuId())) {
            list.add(qdo.resBuId.eq(query.getResBuId()));
        }
        /** 流程实例ID 精确 */
        if (!ObjectUtils.isEmpty(query.getProcInstId())) {
            list.add(qdo.procInstId.eq(query.getProcInstId()));
        }
        /** 流程审批状态 精确 */
        if (!ObjectUtils.isEmpty(query.getProcInstStatus())) {
            list.add(qdo.procInstStatus.eq(ProcInstStatus.valueOf(query.getProcInstStatus())));
        }
        /** 提交时间 精确 */
        if (!ObjectUtils.isEmpty(query.getSubmitTime())) {
            list.add(qdo.submitTime.eq(query.getSubmitTime()));
        }
        /** 审批时间 精确 */
        if (!ObjectUtils.isEmpty(query.getApprovedTime())) {
            list.add(qdo.approvedTime.eq(query.getApprovedTime()));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public TDeviceApplyVO queryByKey(Long id) {
        JPAQuery<TDeviceApplyVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.eq(id));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<TDeviceApplyVO> queryListDynamic(TDeviceApplyQuery query) {
        JPAQuery<TDeviceApplyVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<TDeviceApplyVO> queryPaging(TDeviceApplyQuery query) {
        long total = count(query);
        if (total == 0) {
            return PagingVO.empty();
        }
        JPAQuery<TDeviceApplyVO> jpaQuery = getJpaQueryWhere(query);
        List<TDeviceApplyVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<TDeviceApplyVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public TDeviceApplyDO save(TDeviceApplyDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<TDeviceApplyDO> saveAll(List<TDeviceApplyDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(TDeviceApplyPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(payload.getId()));
        // 记录唯一ID
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 申请单号
        if (payload.getApplyNo() != null) {
            update.set(qdo.applyNo, payload.getApplyNo());
        }
        // 申请状态
        if (payload.getApplyStatus() != null) {
            update.set(qdo.applyStatus, payload.getApplyStatus());
        }
        // 申请日期
        if (payload.getApplyDate() != null) {
            update.set(qdo.applyDate, payload.getApplyDate());
        }
        // 申请人资源ID
        if (payload.getApplyResId() != null) {
            update.set(qdo.applyResId, payload.getApplyResId());
        }
        // 每月补贴金额
        if (payload.getMonthlyAmt() != null) {
            update.set(qdo.monthlyAmt, payload.getMonthlyAmt());
        }
        // 票据号
        if (payload.getBillNo() != null) {
            update.set(qdo.billNo, payload.getBillNo());
        }
        // 品牌型号及颜色
        if (payload.getDeviceDesc() != null) {
            update.set(qdo.deviceDesc, payload.getDeviceDesc());
        }
        // 内存
        if (payload.getMemSize() != null) {
            update.set(qdo.memSize, payload.getMemSize());
        }
        // 硬盘
        if (payload.getHdSize() != null) {
            update.set(qdo.hdSize, payload.getHdSize());
        }
        // 购置价格
        if (payload.getDevicePrice() != null) {
            update.set(qdo.devicePrice, payload.getDevicePrice());
        }
        // 购置日期
        if (payload.getBuyDate() != null) {
            update.set(qdo.buyDate, payload.getBuyDate());
        }
        // 补贴起始月份
        if (payload.getStartPeriodId() != null) {
            update.set(qdo.startPeriodId, payload.getStartPeriodId());
        }
        // 申请理由
        if (payload.getApplyDesc() != null) {
            update.set(qdo.applyDesc, payload.getApplyDesc());
        }
        // 申请人BU_ID
        if (payload.getResBuId() != null) {
            update.set(qdo.resBuId, payload.getResBuId());
        }
        // 申请人BU_ID
        if (payload.getFileCode() != null) {
            update.set(qdo.fileCode, payload.getFileCode());
        }
        // 流程实例ID
        if (payload.getProcInstId() != null) {
            update.set(qdo.procInstId, payload.getProcInstId());
        }
        // 流程审批状态
        if (payload.getProcInstStatus() != null) {
            update.set(qdo.procInstStatus, payload.getProcInstStatus());
        }
        // 提交时间
        if (payload.getSubmitTime() != null) {
            update.set(qdo.submitTime, payload.getSubmitTime());
        }
        // 审批时间
        if (payload.getApprovedTime() != null) {
            update.set(qdo.approvedTime, payload.getApprovedTime());
        }
        // 删除标志
        if (payload.getDeleteFlag() != null) {
            update.set(qdo.deleteFlag, payload.getDeleteFlag());
        }
        if (payload.getRemark() != null) {
            update.set(qdo.remark, payload.getRemark());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 记录唯一ID
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 申请单号
            if (nullFields.contains("applyNo")) {
                update.setNull(qdo.applyNo);
            }
            // 申请状态
            if (nullFields.contains("applyStatus")) {
                update.setNull(qdo.applyStatus);
            }
            // 申请日期
            if (nullFields.contains("applyDate")) {
                update.setNull(qdo.applyDate);
            }
            // 申请人资源ID
            if (nullFields.contains("applyResId")) {
                update.setNull(qdo.applyResId);
            }
            // 每月补贴金额
            if (nullFields.contains("monthlyAmt")) {
                update.setNull(qdo.monthlyAmt);
            }
            // 票据号
            if (nullFields.contains("billNo")) {
                update.setNull(qdo.billNo);
            }
            // 品牌型号及颜色
            if (nullFields.contains("deviceDesc")) {
                update.setNull(qdo.deviceDesc);
            }
            // 内存
            if (nullFields.contains("memSize")) {
                update.setNull(qdo.memSize);
            }
            // 硬盘
            if (nullFields.contains("hdSize")) {
                update.setNull(qdo.hdSize);
            }
            // 购置价格
            if (nullFields.contains("devicePrice")) {
                update.setNull(qdo.devicePrice);
            }
            // 购置日期
            if (nullFields.contains("buyDate")) {
                update.setNull(qdo.buyDate);
            }
            // 补贴起始月份
            if (nullFields.contains("startPeriodId")) {
                update.setNull(qdo.startPeriodId);
            }
            // 申请理由
            if (nullFields.contains("applyDesc")) {
                update.setNull(qdo.applyDesc);
            }
            // 申请人BU_ID
            if (nullFields.contains("resBuId")) {
                update.setNull(qdo.resBuId);
            }
            // 附件
            if (nullFields.contains("fileCode")) {
                update.setNull(qdo.fileCode);
            }
            // 流程实例ID
            if (nullFields.contains("procInstId")) {
                update.setNull(qdo.procInstId);
            }
            // 流程审批状态
            if (nullFields.contains("procInstStatus")) {
                update.setNull(qdo.procInstStatus);
            }
            // 提交时间
            if (nullFields.contains("submitTime")) {
                update.setNull(qdo.submitTime);
            }
            // 审批时间
            if (nullFields.contains("approvedTime")) {
                update.setNull(qdo.approvedTime);
            }
            // 审批时间
            if (nullFields.contains("deleteFlag")) {
                update.setNull(qdo.deleteFlag);
            }
            if (nullFields.contains("remark")) {
                update.setNull(qdo.remark);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

}

