package com.elitesland.tw.tw5.server.prd.office.models.configurations;

import lombok.Getter;
import lombok.Setter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

/**
 * "customization": {//定制部分允许自定义编辑器界面，使其看起来像您的其他产品，并更改是否存在其他按钮，链接，更改徽标和编辑者所有者详细信息。
 * "help": true, //定义是显示还是隐藏“帮助”菜单按钮。默认值为true。
 * "hideRightMenu": false, //定义在第一次加载时是显示还是隐藏右侧菜单。默认值为false。
 * "autosave": true,//定义是启用还是禁用“自动保存”菜单选项。请注意，如果您在菜单中更改此选项，它将被保存到浏览器的localStorage中。默认值为true。
 * "forcesave": true, //定义保存按钮是否显示默认false
 * "chat": true, //定义“聊天”菜单按钮是显示还是隐藏；请注意，如果您隐藏“聊天”按钮，则相应的聊天功能也将被禁用。默认值为true。
 * "commentAuthorOnly": false, //定义用户是否只能编辑和删除他的评论。默认值为false。
 * "comments": true, //定义是显示还是隐藏“注释”菜单按钮；请注意，如果您隐藏“评论”按钮，则相应的评论功能将仅可用于查看，评论的添加和编辑将不可用。默认值为true。
 * "compactHeader": false, //定义是否将菜单栏放在在徽标旁边使界面更加紧凑默认false。
 * "compactToolbar": false, //定义显示的顶部工具栏类型是完整（false）还是紧凑true。默认值为false 多余菜单将在右侧折叠点击显示。
 * "compatibleFeatures": false, //定义仅与OOXML格式兼容的功能的使用。例如，不要在整个文档上使用注释。默认值为false。
 * "macros": true, //定义是否将运行文档宏以及可用的宏设置。默认值为true。
 * "macrosMode": "warn", //定义是否将运行文档宏。可以采用以下值： disable -根本不运行；enable -自动运行所有宏；warn -警告宏并请求允许运行。默认值为original。
 * "plugins": true, //定义是否将启动插件并可用。默认值为true。
 * "showReviewChanges": false, //定义在加载编辑器时是否自动显示或隐藏审阅更改面板。默认值为false。
 * "spellcheck": true, //定义在加载编辑器时是否自动打开或关闭拼写检查器。拼写检查器仅适用于文档编辑器和演示文稿编辑器。默认值为true。
 * "toolbarNoTabs": false, //定义是突出显示顶部工具栏选项卡样式。默认值为false。
 * "unit": "cm", //定义在标尺和对话框中使用的度量单位。可以采用以下值：cm -厘米，pt-点，inch -英寸。默认值为厘米（cm）。
 * "zoom": 100, //定义以百分比为单位的文档显示缩放值。可以取大于0的值。对于文本文档和演示文稿，可以将此参数设置为-1（使文档适合页面选项）或-2（使文档页面宽度适合编辑器页面）。默认值为100。
 * "customer": { //关于 文档编辑器的显示信息
 * "address": "My City, 123a-45", //有权访问编辑或编辑作者的公司或个人的邮政地址，
 * "info": "Some additional information", //有关您希望其他人认识的公司或个人的一些其他信息，
 * "logo": "https://example.com/logo-big.png", //图片徽标的路径（此文件没有特别建议，但是如果使用透明背景的.png格式会更好）。图片必须具有以下尺寸：432x70，
 * "mail": "john@example.com", //有权访问编辑者或编辑者的公司或个人的电子邮件地址
 * "name": "欧阳锋", //该公司或个人的谁可以访问编辑或编辑作者，名称
 * "www": "example.com" //以上公司或个人的家庭网站地址，
 * },
 * "feedback": { //反馈配置信息
 * "url": "https://example.com", //单击“反馈和支持”菜单按钮时将打开的网站地址的绝对URL ，
 * "visible": true //显示或隐藏“反馈和支持”菜单按钮，
 * },
 * "goback": { //定义“打开文件位置”菜单按钮和右上角按钮的设置。该对象具有以下参数：
 * "blank": true, //在新的浏览器选项卡/窗口（如果值设置为true）或当前选项卡（如果值设置为false）中打开网站。默认值为true，
 * "requestClose": false, //定义如果单击“打开文件位置”按钮，则调用events.onRequestClose事件，而不是打开浏览器选项卡或窗口。默认值为false，
 * "text": "Open file location", //将在“打开文件位置”菜单按钮和右上角按钮（即，而不是“转到文档”）上显示的文本，
 * "url": "https://example.com" //单击“打开文件位置”菜单按钮时将打开的网站地址的绝对URL ，
 * },
 * "logo": {
 * "image": "https://example.com/logo.png", //图像文件的路径，用于在普通工作模式下显示（即，在所有编辑器的查看和编辑模式下）。图片必须具有以下尺寸：172x40，
 * "imageEmbedded": "https://example.com/logo_em.png", //用于以嵌入式模式显示的图像文件的路径（请参阅config部分以了解如何定义嵌入式文档类型）。图片必须具有以下尺寸：248x40，
 * "url": "https://www.baidu.com" //某人单击徽标图像时将使用的绝对URL（可用于转到您的网站等）。保留为空字符串或null以使徽标不可单击，
 * },
 * },
 *
 * @author duwh
 * @date 2022/09/28
 */
@Component
@Scope("prototype")
@Getter
@Setter
public class Customization {  // the parameters which allow to customize the editor interface so that it looked like your other products (if there are any) and change the presence or absence of the additional buttons, links, change logos and editor owner details
    @Autowired
    private Logo logo;  // the image file at the top left corner of the Editor header
    //@Autowired
    //private Goback goback;  // the settings for the Open file location menu button and upper right corner button
    private Boolean autosave = true;  // if the Autosave menu option is enabled or disabled
    private Boolean comments = true;  // if the Comments menu button is displayed or hidden
    private Boolean compactHeader = false;  // if the additional action buttons are displayed in the upper part of the editor window header next to the logo (false) or in the toolbar (true)
    private Boolean compactToolbar = false;  // if the top toolbar type displayed is full (false) or compact (true)
    private Boolean compatibleFeatures = false;  // the use of functionality only compatible with the OOXML format
    private Boolean forcesave = false;  // add the request for the forced file saving to the callback handler when saving the document within the document editing service
    private Boolean help = false;  //  if the Help menu button is displayed or hidden
    private Boolean hideRightMenu = false;  // if the right menu is displayed or hidden on first loading
    private Boolean hideRulers = false;  // if the editor rulers are displayed or hidden
    private Boolean submitForm = false;  // if the Submit form button is displayed or hidden
    private Boolean about = true;
    private Boolean feedback = true;
    //定义在加载编辑器时是否自动打开或关闭拼写检查器。拼写检查器仅适用于文档编辑器和演示文稿编辑器。默认值为true。
    private Boolean spellcheck = false;
}
