package com.elitesland.tw.tw5.server.prd.partner.identity.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitesland.tw.tw5.api.common.annotation.FieldCreateLog;
import com.elitesland.tw.tw5.api.common.annotation.FieldUpdateLog;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDate;

/**
 * 业务伙伴-经销商信息
 *
 * @author wangly
 * @date 2023-05-16
 */
@Entity
@Table(name = "com_business_distributor_info", indexes = {
        @Index(name = "index_partner_id", columnList = "partner_id"),
        @Index(name="index_book_id",columnList = "book_id")

})
@org.hibernate.annotations.Table(appliesTo = "com_business_distributor_info", comment = "业务伙伴-经销商信息")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class BusinessDistributorInfoDO extends BaseModel implements Serializable {
    /**
     * 业务伙伴id business_partner.id
     */
    @Comment("业务伙伴id")
    @Column(name = "partner_id")
    private Long partnerId;

    /**
     * 地址薄id
     */
    @Comment("地址薄id")
    @Column(name = "book_id")
    private Long bookId;

    /**
     * 经销商状态 udc[CRM:BUSINESS_PARTNER:STATUS]
     */
    @Comment("经销商状态 udc[CRM:BUSINESS_PARTNER:STATUS]")
    @Column()
    @FieldUpdateLog(fieldName = "经销商状态", selectionKey = "CRM:BUSINESS_PARTNER:STATUS")
    @FieldCreateLog(fieldName = "经销商状态", selectionKey = "CRM:BUSINESS_PARTNER:STATUS")
    private String dealerStatus;
    /**
     * 经销商等级 udc[crm:customer_grade]
     */
    @Comment("经销商等级 udc[crm:customer_grade]")
    @Column()
    @FieldUpdateLog(fieldName = "经销商等级", selectionKey = "crm:customer_grade")
    @FieldCreateLog(fieldName = "经销商等级", selectionKey = "crm:customer_grade")
    private String dealerGradle;
    /**
     * 授权产品
     */
    @Comment("授权产品")
    @Column()
    private String authProduct;
    /**
     * 销售区域
     */
    @Comment("销售区域")
    @Column()
    @FieldCreateLog(fieldName = "销售区域")
    @FieldUpdateLog(fieldName = "销售区域")
    private String salesArea;
    /**
     * 授权开始时间
     */
    @Comment("授权开始时间")
    @Column()
    @FieldCreateLog(fieldName = "授权开始时间")
    @FieldUpdateLog(fieldName = "授权开始时间")
    private LocalDate startTime;
    /**
     * 授权结束时间
     */
    @Comment("授权结束时间")
    @Column()
    @FieldCreateLog(fieldName = "授权结束时间")
    @FieldUpdateLog(fieldName = "授权结束时间")
    private LocalDate endTime;
    /**
     * 授权期间说明
     */
    @Comment("授权期间说明")
    @Column()
    @FieldCreateLog(fieldName = "授权期间说明")
    @FieldUpdateLog(fieldName = "授权期间说明")
    private String collaborateDescription;
    /**
     * 审核材料附件
     */
    @Comment("审核材料附件")
    @Column()
    private String fileCodes1;
    /**
     * 实地考察附件
     */
    @Comment("实地考察附件")
    @Column()
    private String fileCodes2;
    /**
     * 扩展字段1
     */
    @Comment("扩展字段1")
    @Column()
    private String ext1;
    /**
     * 扩展字段2
     */
    @Comment("扩展字段2")
    @Column()
    private String ext2;
    /**
     * 扩展字段3
     */
    @Comment("扩展字段3")
    @Column()
    private String ext3;
    /**
     * 扩展字段4
     */
    @Comment("扩展字段4")
    @Column()
    private String ext4;
    /**
     * 扩展字段5
     */
    @Comment("扩展字段5")
    @Column()
    private String ext5;

    public void copy(BusinessDistributorInfoDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
