package com.elitesland.tw.tw5.server.prd.pay.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pay.payload.TDocHistPayload;
import com.elitesland.tw.tw5.api.prd.pay.query.TDocHistQuery;
import com.elitesland.tw.tw5.api.prd.pay.service.TDocHistService;
import com.elitesland.tw.tw5.api.prd.pay.vo.TDocHistVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 支付管理-支付履历
 *
 * @folder 支付管理-支付履历
 * @author wangly
 * @date 2023-12-12
 */
@Api(tags = "支付管理-支付履历")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/tDocHist")
@Slf4j
public class TDocHistController {

private final TDocHistService tDocHistService;

    /**
     * 支付管理-支付履历-新增
     *
     * @folder 支付管理-支付履历
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("支付管理-支付履历-新增")
    public TwOutputUtil<TDocHistVO> insert(@RequestBody TDocHistPayload payload){
         return TwOutputUtil.ok(tDocHistService.insert(payload));
    }

    /**
     * 支付管理-支付履历-更新
     *
         * @folder 支付管理-支付履历
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("支付管理-支付履历-更新")
    public TwOutputUtil<TDocHistVO> update(@RequestBody TDocHistPayload payload){
        return TwOutputUtil.ok(tDocHistService.update(payload));
    }

    /**
     * 支付管理-支付履历-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @folder 支付管理-支付履历
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("支付管理-支付履历-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody TDocHistPayload payload){
        return TwOutputUtil.ok(tDocHistService.updateByKeyDynamic(payload));
    }

    /**
     * 支付管理-支付履历-主键查询
     *
     * @folder 支付管理-支付履历
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    @UdcNameClass
    @ApiOperation("支付管理-支付履历-主键查询")
    public TwOutputUtil<TDocHistVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(tDocHistService.queryByKey(key));
    }

    /**
     * 支付管理-支付履历-分页
     *
         * @folder 支付管理-支付履历
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    @UdcNameClass
    @ApiOperation("支付管理-支付履历-分页")
    public TwOutputUtil<PagingVO<TDocHistVO>> paging(TDocHistQuery query) {
        return TwOutputUtil.ok(tDocHistService.queryPaging(query));
    }

    /**
     * 支付管理-支付履历-查询列表
     *
     * @folder 支付管理-支付履历
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    @UdcNameClass
    @ApiOperation("支付管理-支付履历-查询列表")
    public TwOutputUtil<List<TDocHistVO>> queryList(TDocHistQuery query) {
        return TwOutputUtil.ok(tDocHistService.queryListDynamic(query));
    }

    /**
     * 支付管理-支付履历-删除
     *
         * @folder 支付管理-支付履历
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("支付管理-支付履历-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
         tDocHistService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}

