package com.elitesland.tw.tw5.server.prd.personplan.service;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdAbilityLevelQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdCompositeAbilityQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdAbilityLevelService;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdCompositeAbilityService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdAbilityLevelVO;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdCompositeAbilityVO;
import com.elitesland.tw.tw5.api.prd.my.service.VacationService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.api.prd.personplan.payload.PersonPlanDtlPayload;
import com.elitesland.tw.tw5.api.prd.personplan.query.PersonPlanDtlQuery;
import com.elitesland.tw.tw5.api.prd.personplan.service.PersonPlanDtlService;
import com.elitesland.tw.tw5.api.prd.personplan.service.PersonPlanService;
import com.elitesland.tw.tw5.api.prd.personplan.vo.DayJsonVO;
import com.elitesland.tw.tw5.api.prd.personplan.vo.PersonPlanDtlVO;
import com.elitesland.tw.tw5.api.prd.personplan.vo.PersonPlanVO;
import com.elitesland.tw.tw5.api.prd.personplan.vo.ProjectPersonPlanVO;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemSelectionService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemSelectionVO;
import com.elitesland.tw.tw5.server.common.ExcelUtil;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.FunctionSelectionEnum;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgSyncLogDAO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgSyncLogDO;
import com.elitesland.tw.tw5.server.prd.personplan.constants.PersonPlanUomEnum;
import com.elitesland.tw.tw5.server.prd.personplan.convert.PersonPlanDtlConvert;
import com.elitesland.tw.tw5.server.prd.personplan.dao.PersonPlanDtlDao;
import com.elitesland.tw.tw5.server.prd.personplan.dao.PersonPlanTmpDAO;
import com.elitesland.tw.tw5.server.prd.personplan.entity.PersonPlanDtlDO;
import com.elitesland.tw.tw5.server.prd.personplan.entity.PersonPlanTmpDO;
import com.elitesland.tw.tw5.server.prd.personplan.repo.PersonPlanDtlRepo;
import com.elitesland.tw.tw5.server.udc.UdcUtil;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAdjusters;
import java.util.*;
import java.util.stream.Collectors;


/**
 * @author : WWW
 * @date : 2024-2-21
 * @desc : 人员规划明细Service
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class PersonPlanDtlServiceImpl implements PersonPlanDtlService {


    private final PersonPlanDtlDao personPlanDtlDao;

    private final PersonPlanDtlRepo personPlanDtlRepo;
    private final ExcelUtil excelUtil;
    @Autowired
    @Lazy
    private PersonPlanService personPlanService;
    private final UdcUtil udcUtil;
    private final CacheUtil cacheUtil;
    private final VacationService vacationService;
    private final PrdAbilityLevelService prdAbilityLevelService;
    private final PrdCompositeAbilityService prdCompositeAbilityService;
    private final PrdSystemSelectionService selectionService;
    private static final BigDecimal hours = new BigDecimal(8);
    private static final BigDecimal jsonDay = BigDecimal.ONE;
    private static final int startDynamicColumn = 4;

    private final PersonPlanTmpDAO planTmpDAO;

    private final PrdOrgSyncLogDAO logDAO;

    private final PmsProjectService pmsProjectService;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PersonPlanDtlVO save(PersonPlanDtlPayload personPlanDtlPayload) {

        checkData(personPlanDtlPayload);
        PersonPlanDtlDO personPlanDtlDO = PersonPlanDtlConvert.INSTANCE.p2d(personPlanDtlPayload);
        PersonPlanDtlDO res = personPlanDtlRepo.save(personPlanDtlDO);
        return PersonPlanDtlConvert.INSTANCE.d2v(res);

    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public List<PersonPlanDtlVO> saveAll(List<PersonPlanDtlPayload> personPlanDtlPayloadList, Long planId) {
        List<PersonPlanDtlDO> res = new ArrayList<>();
        for (PersonPlanDtlPayload personPlanDtlPayload : personPlanDtlPayloadList) {
            checkData(personPlanDtlPayload);
            PersonPlanDtlDO personPlanDtlDO = PersonPlanDtlConvert.INSTANCE.p2d(personPlanDtlPayload);
            res.add(personPlanDtlDO);
        }
        personPlanDtlRepo.saveAll(res);

        PersonPlanDtlQuery personPlanDtlQuery = new PersonPlanDtlQuery();
        personPlanDtlQuery.setPlanId(planId);
        List<PersonPlanDtlVO> personPlanDtlList = getList(personPlanDtlQuery);

        if (!CollectionUtils.isEmpty(personPlanDtlList)) {
            // 校验是否有重复的员工
            checkRepeatedUser(personPlanDtlList);
            translateSystemSelection(personPlanDtlList);
        }
        return personPlanDtlList;
    }

    @Override
    @Transactional
    public void delByNotInIdList(List<Long> idNotInList) {
        personPlanDtlDao.delByNotInIdList(idNotInList);
    }

    // 校验是否有重复的员工
    private void checkRepeatedUser(List<PersonPlanDtlVO> personPlanDtlList) {

        Set set = new HashSet<>();
        Set repeatedUser = new HashSet<>();
        personPlanDtlList.forEach(x -> {
            if (x.getResId() != null) {
                if (set.contains(x.getResId())) {
                    String userName = cacheUtil.getUserName(x.getResId());

                    repeatedUser.add(userName);
                } else {
                    set.add(x.getResId());
                }
            }
        });
        if (!CollectionUtils.isEmpty(repeatedUser)) {
            StringBuilder stringBuilder = new StringBuilder();
            repeatedUser.stream().forEach(e -> {
                stringBuilder.append(e + ",");
            });
            String substring = stringBuilder.substring(0, stringBuilder.length() - 1);
            throw TwException.error("", "人员规划明细中" + substring + "存在重复的员工，请检查");
        }

    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PersonPlanDtlVO updateAll(PersonPlanDtlPayload personPlanDtlPayload) {

        Assert.notNull(personPlanDtlPayload.getId(), "id is null");
        PersonPlanDtlVO res = save(personPlanDtlPayload);
        return res;

    }


    @Override
    public PersonPlanDtlVO get(Long id) {

        if (null == id) {
            return null;
        }
        PersonPlanDtlVO res = personPlanDtlDao.get(id);
        if (res != null) {
            translateSystemSelection(Collections.singletonList(res));
        }
        return res;

    }


    @Override
    public PagingVO<PersonPlanDtlVO> page(PersonPlanDtlQuery personPlanDtlQuery) {

        PagingVO<PersonPlanDtlVO> res = personPlanDtlDao.page(personPlanDtlQuery);
        if (!CollectionUtils.isEmpty(res.getRecords())) {
            translateSystemSelection(res.getRecords());
        }
        return res;

    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long del(List<Long> ids) {

        if (CollectionUtil.isEmpty(ids)) {
            return 0L;
        }
        Long res = personPlanDtlDao.del(ids);
        return res;

    }

    @Override
    public List<PersonPlanDtlVO> getList(PersonPlanDtlQuery personPlanDtlQuery) {

        List<PersonPlanDtlVO> res = personPlanDtlDao.getList(personPlanDtlQuery);
        if (!CollectionUtils.isEmpty(res)) {
            translateSystemSelection(res);
        }
        return res;

    }


    private void translateSystemSelection(List<PersonPlanDtlVO> personPlanDtlVOS) {
        // 复合能力翻译
        List<Long> capasetLevelIds = personPlanDtlVOS.stream().filter(e -> !ObjectUtils.isEmpty(e.getCapasetLevelId())).map(p -> p.getCapasetLevelId()).collect(Collectors.toList());
        if (!ObjectUtils.isEmpty(capasetLevelIds)) {
            // 先查询能力级别
            PrdAbilityLevelQuery abilityLevelQuery = new PrdAbilityLevelQuery();
            abilityLevelQuery.setIds(capasetLevelIds);
            List<PrdAbilityLevelVO> abilityLevelVOS = prdAbilityLevelService.getList(abilityLevelQuery);

            Map<Long, String> levelMap = new HashMap<>();
            Map<Long, Long> abilityMap = new HashMap<>();
            for (PrdAbilityLevelVO levelVO : abilityLevelVOS) {
                levelMap.put(levelVO.getId(), levelVO.getLevelDtlName());
                abilityMap.put(levelVO.getId(), levelVO.getAbilityId());
            }

            List<Long> abilityIds = abilityLevelVOS.stream().map(e -> e.getAbilityId()).collect(Collectors.toList());
            // 查询 复合能力
            PrdCompositeAbilityQuery prdCompositeAbilityQuery = new PrdCompositeAbilityQuery();
            prdCompositeAbilityQuery.setIds(abilityIds);
            List<PrdCompositeAbilityVO> levelVOS = prdCompositeAbilityService.getList(prdCompositeAbilityQuery);

            Map<Long, String> compositeAbilityMap = new HashMap<>();
            for (PrdCompositeAbilityVO compositeAbilityVO : levelVOS) {
                compositeAbilityMap.put(compositeAbilityVO.getId(), compositeAbilityVO.getName());
            }

            personPlanDtlVOS.forEach(v -> {
                Long capasetLevelId = v.getCapasetLevelId();
                if (!ObjectUtils.isEmpty(capasetLevelId)) {
                    //级别
                    String levelDesc = levelMap.get(capasetLevelId);
                    //复合能力
                    Long compositeAbilityId = abilityMap.get(capasetLevelId);
                    if (compositeAbilityId != null) {
                        String compositeAbilityName = compositeAbilityMap.get(compositeAbilityId);
                        v.setCapasetLevelIdDesc(compositeAbilityName + "-" + levelDesc);
                    }
                }
            });
        }
    }

    /**
     * 数据校验
     *
     * @param personPlanDtlPayload
     */
    private void checkData(PersonPlanDtlPayload personPlanDtlPayload) {

//        Assert.notEmpty(personPlanDtlPayload.getType(), "类型不能为空");
//        Assert.notNull(personPlanDtlPayload.getUserId(), "用户id不能为空");

    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long update(PersonPlanDtlPayload personPlanDtlPayload) {
        Assert.notNull(personPlanDtlPayload.getId(), "id不能为空");
        Long res = personPlanDtlDao.update(personPlanDtlPayload);
        return res;
    }

    @Override
    @Transactional
    public void deleteByPlanIds(List<Long> planIds) {
        personPlanDtlDao.deleteByPlanIds(planIds);
    }


    @Override
    public void tmpDownload(HttpServletResponse response, Long planId) {
        Workbook workbook = getVol(planId);
        String fileName = "商机资源规划模板-" + LocalDate.now();
        ExcelUtil.writeResponse(response, fileName, workbook);
    }

    //导入
    @Override
    @Transactional
    public String batchImport(MultipartFile file, Long planId) {
        if (file == null) {
            throw TwException.error("", "上传文件异常，请联系管理员");
        }
        Workbook workbook = null;
        try {
            workbook = WorkbookFactory.create(file.getInputStream());
        } catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
            throw TwException.error("", "文件解析异常，请联系管理员");
        }
        Sheet sheet = workbook.getSheet("导入模板");
        if (sheet == null) {
            throw TwException.error("", "导入模板sheet页不存在，请重新下载模板");
        }
        int dataStartRow = 1;

        PersonPlanVO personPlanVO = personPlanService.get(planId);
        if (personPlanVO == null) {
            throw TwException.error("", "资源规划数据为空，请联系管理员");
        }

        String uom = personPlanVO.getUom();
        // 持续周期
        Integer duration = Integer.valueOf(personPlanVO.getDuration());
        TemporalAdjuster adjuster = null;
        String title = "";
        if (PersonPlanUomEnum.week.getCode().equals(uom)) {
            adjuster = TemporalAdjusters.next(DayOfWeek.SUNDAY);
            title = "W";
        }
        if (PersonPlanUomEnum.month.getCode().equals(uom)) {
            adjuster = TemporalAdjusters.lastDayOfMonth();
            title = "M";
        }
        if (PersonPlanUomEnum.year.getCode().equals(uom)) {
            adjuster = TemporalAdjusters.lastDayOfYear();
            title = "Y";
        }
        if (adjuster == null) {
            throw TwException.error("", "周期单位错误");
        }

        //判断模版格式是否正确
        Row firstRow = sheet.getRow(0);
        String cellFormatValue = ExcelUtil.getCellFormatValue(firstRow.getCell(startDynamicColumn));
        if (!StringUtils.hasText(cellFormatValue) || !title.equals(cellFormatValue.substring(0, 1))) {
            throw TwException.error("", "模版格式与资源规划周期不匹配，请重新导出模板");
        }
        Map<Integer, String> columnMap = new HashMap<>();
        for (int j = startDynamicColumn; j < startDynamicColumn + duration; j++) {
            String columnName = ExcelUtil.getCellFormatValue(firstRow.getCell(j));
            columnMap.put(j, columnName);
        }
        // 查询开始结束日期所有的工作日
        List<LocalDate> workLocalDay = vacationService.findWorkLocalDay(personPlanVO.getStartDate(), personPlanVO.getEndDate());
        Set<LocalDate> set = new HashSet<>(workLocalDay);
        //计算时间内的周期
        List<Map<String, String>> dataRangeList = dataRange(personPlanVO.getStartDate(), personPlanVO.getEndDate(), adjuster);
        List<PersonPlanDtlPayload> personPlanDtlPayloadList = new ArrayList<>();
        // List<PersonPlanDtlPayload> personPlanDtlUpdatePayloadList = new ArrayList<>();
        StringBuilder stringBuilder = new StringBuilder();
        //角色下拉导入处理
        Set resNameSet = new HashSet();
        Map<String, String> roleMap = new HashMap();
        PrdSystemSelectionVO systemSelection = cacheUtil.getSystemSelection(FunctionSelectionEnum.PMS_RESOURCE_PLAN_ROLE.getCode());
        if (systemSelection != null) {
            List<PrdSystemSelectionVO> children = new ArrayList<>();
            cacheUtil.getAllChildren(systemSelection, children);
            if (children != null && children.size() > 0) {
                for (PrdSystemSelectionVO selectionView : children) {
                    roleMap.put(selectionView.getSelectionName(), selectionView.getSelectionValue());
                }
            }
        }
        //复合能力导入处理
        // 查询复合能力
        List<PrdCompositeAbilityVO> compositeAbilityVOS = prdCompositeAbilityService.levelList(new PrdCompositeAbilityQuery());
        Map<String, Long> compositeAbilityMap = new HashMap<>();
        compositeAbilityVOS.stream().forEach(item -> {
            String abilityLevelName = item.getJobType1Desc() + "-" + item.getJobType2Desc() + "-" + item.getLevelDtlName();
            item.setAbilityLevelName(abilityLevelName);
            compositeAbilityMap.put(abilityLevelName, item.getAbilityLevelId());
        });

        List<Long> idList = new ArrayList();
        for (int i = dataStartRow; i <= sheet.getLastRowNum(); i++) {
            Row row = sheet.getRow(i);
            PersonPlanDtlPayload personPlanDtlPayload = new PersonPlanDtlPayload();
            // 资源规划id
            personPlanDtlPayload.setPlanId(planId);
            personPlanDtlPayloadList.add(personPlanDtlPayload);
            String id = ExcelUtil.getCellFormatValue(row.getCell(0));
            if (StringUtils.hasText(id)) {
                personPlanDtlPayload.setId(Long.parseLong(id));
                idList.add(Long.valueOf(id));
            }
            // 角色
            String roleName = ExcelUtil.getCellFormatValue(row.getCell(1));
            if (StringUtils.hasText(roleName)) {
                if (roleMap.containsKey(roleName)) {
                    personPlanDtlPayload.setRoleCode(roleMap.get(roleName));
                } else {
                    stringBuilder.append("第" + (i + 1) + "行的角色名称未查询到对应的角色 \n");
                }
            }
            // 资源
            String resName = ExcelUtil.getCellFormatValue(row.getCell(2));
            // 当量系数
            BigDecimal eqvaRatio = BigDecimal.ZERO;
            if (StringUtils.hasText(resName)) {
                Long userId = cacheUtil.getUserIdByName(resName);
                if(userId != null){
                    PrdOrgEmployeeVO employee = cacheUtil.getEmployee(userId);
                    // 系数
                    eqvaRatio =  employee.getEqvaRatio() == null ? BigDecimal.ZERO : employee.getEqvaRatio();
                    resNameSet.add(resName);
                    personPlanDtlPayload.setDistributeRate(eqvaRatio);
                    personPlanDtlPayload.setResId(userId);
                }else{
                    stringBuilder.append("第"+(i+1)+"行的资源名称未查询到对应的员工 \n");
                }
            }

            // 复合能力
            String compositeAbilityName = ExcelUtil.getCellFormatValue(row.getCell(3));
            if (StringUtils.hasText(compositeAbilityName)) {
                if (compositeAbilityMap.containsKey(compositeAbilityName)) {
                    personPlanDtlPayload.setCapasetLevelId(compositeAbilityMap.get(compositeAbilityName));
                } else {
                    stringBuilder.append("第" + (i + 1) + "行的复合能力名称未查询到对应的复合能力 \n");
                }
            }
            if (!StringUtils.hasText(compositeAbilityName) && !StringUtils.hasText(roleName)) {
                throw TwException.error("", "第" + (i + 1) + "行的复合能力名称和角色名称不能同时为空");
            }
            //备注
            String remark = ExcelUtil.getCellFormatValue(row.getCell(4));
            personPlanDtlPayload.setRemark(remark);
            List<DayJsonVO> dayJsonVOList = new ArrayList<>();
            // 动态字段
            int index = 0;
            BigDecimal days = BigDecimal.ZERO;
            for (int j = startDynamicColumn; j < startDynamicColumn + duration; j++) {
                Map<String, String> stringStringMap = dataRangeList.get(index);
                String day = ExcelUtil.getCellFormatValue(row.getCell(j));
                if (StringUtils.hasText(day)) {
                    BigDecimal bigDecimal = BigDecimal.ZERO;
                    String columnName = columnMap.get(j);
                    try {
                        bigDecimal = new BigDecimal(day);
//
                    } catch (Exception e) {
                        stringBuilder.append("第" + (i + 1) + "行的" + columnName + "列数据格式有误 \n");
                        continue;
                    }
                    if (bigDecimal.compareTo(BigDecimal.ZERO) > 0) {
                        // 生成每个周期的json
                        generateDaysJson(stringStringMap, bigDecimal, dayJsonVOList, set, i, stringBuilder, columnName);
                    } else if (bigDecimal.compareTo(BigDecimal.ZERO) < 0) {
                        stringBuilder.append("第" + (i + 1) + "行的" + columnName + "列数据格式有误,请勿输入负数 \n");
                        continue;
                    }
                    days = days.add(bigDecimal);
                }
                index++;
            }
            // 人天合计
            personPlanDtlPayload.setDays(days);
            // 当量合计

            personPlanDtlPayload.setTotalEqva(eqvaRatio.multiply(days));

            personPlanDtlPayload.setDaysJson(JSONUtil.toJsonStr(dayJsonVOList));

        }
        // 重名判断
        StringBuilder stringBuilderResName = new StringBuilder();
        if (!CollectionUtils.isEmpty(resNameSet)) {
            List<String> resNameList = new ArrayList<>(resNameSet);
            List<String> repeatedName = cacheUtil.queryRepeatedNameByUserName(resNameList);
            if (!CollectionUtils.isEmpty(repeatedName)) {
                for (int i = 0; i < repeatedName.size(); i++) {
                    if (i == repeatedName.size() - 1) {
                        stringBuilderResName.append(repeatedName.get(i) + "资源名称存在重名,如需修改请手动在页面调整");
                    } else {
                        stringBuilderResName.append(repeatedName.get(i) + "\n");
                    }
                }
            }
        }
        if (StringUtils.hasText(stringBuilder)) {
            throw TwException.error("", "导入结果有误:{" + stringBuilder + "}");
        }
        // 保存数据
        if (!CollectionUtil.isEmpty(personPlanDtlPayloadList)) {
            saveAll(personPlanDtlPayloadList, planId);
        }

        return stringBuilderResName.toString();
    }

    private Workbook getVol(Long planId) {
        ClassPathResource classPathResource = new ClassPathResource("template/oppoResourcePlanBatch.xlsx");
        PersonPlanVO personPlanVO = personPlanService.get(planId);
        LocalDate startDate = personPlanVO.getStartDate();
        LocalDate endDate = personPlanVO.getEndDate();
        // 持续时间
        int duration = Integer.valueOf(personPlanVO.getDuration());
        String uom = personPlanVO.getUom();
        TemporalAdjuster adjuster = null;
        // 查询复合能力
        List<PrdCompositeAbilityVO> compositeAbilityVOS = prdCompositeAbilityService.levelList(new PrdCompositeAbilityQuery());

        // excel表头名称
        String title = "";
        if (PersonPlanUomEnum.week.getCode().equals(uom)) {
            adjuster = TemporalAdjusters.next(DayOfWeek.SUNDAY);
            title = "W";
        }
        if (PersonPlanUomEnum.month.getCode().equals(uom)) {
            adjuster = TemporalAdjusters.lastDayOfMonth();
            title = "M";
        }
        if (PersonPlanUomEnum.year.getCode().equals(uom)) {
            adjuster = TemporalAdjusters.lastDayOfYear();
            title = "Y";
        }
        if (adjuster == null) {
            throw TwException.error("", "周期单位错误");
        }
        // 查询开始结束日期内的工作日
        List<LocalDate> workLocalDay = vacationService.findWorkLocalDay(personPlanVO.getStartDate(), personPlanVO.getEndDate());
        Set<LocalDate> workLocalDaySet = new HashSet(workLocalDay);
        //计算时间内的周期
        List<Map<String, String>> dataRangeList = dataRange(startDate, endDate, adjuster);
        // 查询资源规划明细
        PersonPlanDtlQuery personPlanDtlQuery = new PersonPlanDtlQuery();
        personPlanDtlQuery.setPlanId(planId);
        List<PersonPlanDtlVO> list = personPlanDtlDao.getList(personPlanDtlQuery);
        try {
            InputStream inputStream = classPathResource.getInputStream();
            Workbook workbook = WorkbookFactory.create(inputStream);
            XSSFSheet dataSheet = (XSSFSheet) workbook.getSheet("导入模板");
            Sheet compositeAbilitySheet = workbook.getSheet("复合能力");
            Sheet roleSheet = workbook.getSheet("角色列表");

            Map abilityLeveMap = new HashMap();
            compositeAbilityVOS.stream().forEach(item -> {
                String abilityLevelName = item.getJobType1Desc() + "-" + item.getJobType2Desc() + "-" + item.getLevelDtlName();
                item.setAbilityLevelName(abilityLevelName);
                abilityLeveMap.put(item.getAbilityLevelId(), abilityLevelName);
            });

            // 先处理第一行的表头
            XSSFRow firstRow = dataSheet.getRow(0);
            int index = 0;
            for (int i = startDynamicColumn; i < startDynamicColumn + duration; i++) {
                Map<String, String> stringStringMap = dataRangeList.get(index);
                List<String> collect = stringStringMap.keySet().stream().collect(Collectors.toList());
                String start = collect.get(0);
                String end = stringStringMap.get(start);
                int workDayCount = getWorkDayCount(workLocalDaySet, LocalDate.parse(start, DateTimeFormatter.ofPattern("yyyy-MM-dd")), LocalDate.parse(end, DateTimeFormatter.ofPattern("yyyy-MM-dd")));
                if (PersonPlanUomEnum.month.getCode().equals(uom)) {
                    LocalDate monthDate = LocalDate.parse(start, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                    DateTimeFormatter outputFormatter = DateTimeFormatter.ofPattern("yy-MM");
                    start = monthDate.format(outputFormatter);
                }
                if (PersonPlanUomEnum.year.getCode().equals(uom)) {
                    LocalDate yearDate = LocalDate.parse(start, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                    DateTimeFormatter outputFormatter = DateTimeFormatter.ofPattern("yyyy");
                    start = yearDate.format(outputFormatter);
                }
                String columnName = title + (index + 1) + " " + start;
                excelUtil.setCellValueNew(firstRow, i, columnName);
                index++;
            }
            // 处理剩余的数据
            if (!CollectionUtil.isEmpty(list)) {
                list = udcUtil.translateList(list);
                int nextRow = 1;
                for (PersonPlanDtlVO personPlanDtlVO : list) {
                    XSSFRow row = dataSheet.createRow(nextRow);
                    // id
                    excelUtil.setCellValueNew(row, 0, personPlanDtlVO.getId());
                    // 角色
                    excelUtil.setCellValueNew(row, 1, personPlanDtlVO.getRoleName());

                    // 资源
                    excelUtil.setCellValueNew(row, 2, personPlanDtlVO.getResName());

                    // 复合能力
                    excelUtil.setCellValueNew(row, 3, abilityLeveMap.get(personPlanDtlVO.getCapasetLevelId()));
                    // 备注
                    excelUtil.setCellValueNew(row, 4, personPlanDtlVO.getRemark());

                    String daysJson = personPlanDtlVO.getDaysJson();
                    if (StringUtils.hasText(daysJson)) {
                        // 转换为List<Map<String, Bigdecimal>>
                        List<DayJsonVO> dayJsonVOS = JSON.parseArray(daysJson, DayJsonVO.class);
                        index = 0;
                        for (int i = startDynamicColumn; i < startDynamicColumn + duration; i++) {
                            Map<String, String> stringStringMap = dataRangeList.get(index);
                            // String start = stringStringMap.keySet().stream().findFirst().toString();
                            List<String> collect = stringStringMap.keySet().stream().collect(Collectors.toList());
                            String start = collect.get(0);
                            String end = stringStringMap.get(start);
                            LocalDate startDateOne = LocalDate.parse(start, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                            LocalDate endDateOne = LocalDate.parse(end, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                            BigDecimal days = BigDecimal.ZERO;
                            for (DayJsonVO dayJsonVO : dayJsonVOS) {
                                LocalDate date = LocalDate.parse(dayJsonVO.getDate(), DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                                if (date.isEqual(startDateOne) || date.isEqual(endDateOne) || (date.isAfter(startDateOne) && date.isBefore(endDateOne))) {
                                    days = days.add(dayJsonVO.getHour().divide(hours, 2, RoundingMode.HALF_UP));
                                }
                            }

                            excelUtil.setCellValueNew(row, i, days);
                            // todo 如果不要支持导入小数
                            //   excelUtil.setCellValueNew(row, i, days.intValue());
                            index++;
                        }
                    }
                    nextRow++;
                }
            }
            //复合能力下拉处理
            excelUtil.insertListData(compositeAbilitySheet, compositeAbilityVOS, "abilityLevelId", "abilityLevelName", 0);
            excelUtil.generateRangeList(dataSheet, 3, 1, "复合能力", 2, "A");

            // 人员角色处理
            List<PrdSystemSelectionVO> roleVOS = selectionService.selectByCondition(FunctionSelectionEnum.PMS_RESOURCE_PLAN_ROLE.getCode());
            excelUtil.insertLOVdata(roleSheet, roleVOS, 0);
            excelUtil.generateRangeList(dataSheet, 1, 1, "角色列表", 2, "A");

            return workbook;
        } catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage(), e);
        }
        return null;
    }

    // 获取开始和结束时间之间的日期map
    @Override
    public List<Map<String, String>> dataRange(LocalDate startDate, LocalDate endDate, TemporalAdjuster adjuster) {

        List<Map<String, String>> list = new ArrayList();
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        // 获取周期最后一天
        LocalDate sunDay = startDate.with(adjuster);
        if (sunDay.isAfter(endDate) || sunDay.isEqual(endDate)) {
            Map<String, String> map = new HashMap<>();
            map.put(startDate.format(dateTimeFormatter), endDate.format(dateTimeFormatter));
            list.add(map);
            return list;
        } else {
            Map<String, String> map = new HashMap<>();
            map.put(startDate.format(dateTimeFormatter), sunDay.format(dateTimeFormatter));
            list.add(map);
            generateDateList(list, sunDay, endDate, dateTimeFormatter, adjuster);
        }
        return list;
    }

    // 获取开始时间到结束时间所有uom的数组
    public void generateDateList(List<Map<String, String>> list, LocalDate sunDayDate, LocalDate endDate, DateTimeFormatter dateTimeFormatter, TemporalAdjuster adjuster) {
        Map<String, String> map = new HashMap<>();
        LocalDate monDayDate = sunDayDate.plusDays(1);
        LocalDate date = monDayDate.with(adjuster);
        // 如果结束时间在周末之前 递归调用
        if (endDate.isAfter(date)) {
            map.put(monDayDate.format(dateTimeFormatter), date.format(dateTimeFormatter));
            list.add(map);
            generateDateList(list, date, endDate, dateTimeFormatter, adjuster);
        } else {
            map.put(monDayDate.format(dateTimeFormatter), endDate.format(dateTimeFormatter));
            list.add(map);
        }
    }

    // 通过日期和天数生成 某月的规划
    private void generateDaysJson(Map<String, String> stringStringMap, BigDecimal planDay, List<DayJsonVO> dayJsonVOList, Set<LocalDate> workDaySet, int row, StringBuilder stringBuilder, String columnName) {
        List<String> collect = stringStringMap.keySet().stream().collect(Collectors.toList());
        String start = collect.get(0);
        String end = stringStringMap.get(start);
        LocalDate startDate = LocalDate.parse(start, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        LocalDate endDate = LocalDate.parse(end, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        BigDecimal days = new BigDecimal(ChronoUnit.DAYS.between(startDate, endDate)).add(BigDecimal.ONE);
        if (planDay.compareTo(days) > 0) {
            stringBuilder.append("第" + (row + 1) + "行" + columnName + "列的日期天数大于自然日天数 \n");
            return;
        }
        // 计算出总工作日的小时数 通过尾差处理天数为小数的问题 例如 3.5天 总小时数为28小时 第四天为4小时
        BigDecimal workHours = planDay.multiply(hours);
        BigDecimal workDays = planDay;

        BigDecimal checkDate = BigDecimal.ONE;
        // 从开始时间到结束时间循环 获取dayInt个日期
        for (LocalDate dt = startDate; dt.isBefore(endDate) || dt.isEqual(endDate); dt = dt.plusDays(1)) {
            DayJsonVO dayJsonVO = new DayJsonVO();
            dayJsonVO.setDate(dt.toString());
            // 天数
            if (workDays.compareTo(jsonDay) > 0) {
                dayJsonVO.setDay(jsonDay);
                workDays = workDays.subtract(jsonDay);
            } else {
                dayJsonVO.setDay(workDays);
            }
            if (workHours.compareTo(hours) > 0) {
                dayJsonVO.setHour(hours);
                // 每次减8小时
                workHours = workHours.subtract(hours);
            } else {
                dayJsonVO.setHour(workHours);
            }
            dayJsonVOList.add(dayJsonVO);
            // 如果天数大于等于计划天数 则跳出循环
            if (checkDate.compareTo(planDay) >= 0) {
                break;
            }
            checkDate = checkDate.add(BigDecimal.ONE);
        }
    }


    private int getWorkDayCount(Set workDateSet, LocalDate startDate, LocalDate endDate) {
        return (int) workDateSet.stream().filter(date -> {
            LocalDate date1 = (LocalDate) date;
            return (date1.isAfter(startDate) || date1.isEqual(startDate)) && (date1.isBefore(endDate) || date1.isEqual(endDate));
        }).count();
    }

    @Override
    @Transactional
    public void insertPlanTmp() {

        String syncType = "person_plan_dtl";
        LocalDateTime localDateTime = logDAO.queryOrgSyncLog(syncType);
        if (localDateTime == null) {
            localDateTime = LocalDateTime.of(1970, 1, 1, 0, 0);
        } else {
            //将同步时间提前10秒，防止拉数据遗漏
            localDateTime = localDateTime.minusSeconds(180);
        }

        List<ProjectPersonPlanVO> projectPersonPlanVOS = personPlanDtlDao.queryPlanDtlList(localDateTime);
        for (ProjectPersonPlanVO projectPersonPlanVO : projectPersonPlanVOS) {
            PmsProjectVO pmsProjectVO = pmsProjectService.queryByContractId(projectPersonPlanVO.getProjectId());
            if (!ObjectUtils.isEmpty(pmsProjectVO)) {
                projectPersonPlanVO.setProjectId(pmsProjectVO.getId());
            } else {
                projectPersonPlanVO.setProjectId(null);
            }
        }

        // 循环规划数据
        if (!ObjectUtils.isEmpty(projectPersonPlanVOS)) {
            for (ProjectPersonPlanVO pmsPersonPlanAndActualVO : projectPersonPlanVOS) {

                planTmpDAO.deleteAllByDtlId(pmsPersonPlanAndActualVO.getPlanDtlId());

                TemporalAdjuster adjuster = TemporalAdjusters.lastDayOfMonth();
                List<Map<String, String>> dataRangeList = dataRange(pmsPersonPlanAndActualVO.getStartDate(), pmsPersonPlanAndActualVO.getEndDate(), adjuster);

                Long resId = pmsPersonPlanAndActualVO.getResId();
                List<DayJsonVO> dayJsonVOS;

                String daysJson = pmsPersonPlanAndActualVO.getDaysJson();
                dayJsonVOS = JSON.parseArray(daysJson, DayJsonVO.class);

                // 开始循环月份
                for (Map<String, String> stringMap : dataRangeList) {
                    ProjectPersonPlanVO pmsPlanJsonVO = new ProjectPersonPlanVO();
                    pmsPlanJsonVO.setResId(resId);

                    List<String> collect = stringMap.keySet().stream().toList();
                    String start = collect.get(0);
                    String end = stringMap.get(start);
                    LocalDate startDateOne = LocalDate.parse(start, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                    LocalDate endDateOne = LocalDate.parse(end, DateTimeFormatter.ofPattern("yyyy-MM-dd"));

                    PersonPlanTmpDO projectPersonPlanDO = new PersonPlanTmpDO();
                    projectPersonPlanDO.setProjectId(pmsPersonPlanAndActualVO.getProjectId());
                    projectPersonPlanDO.setResId(pmsPersonPlanAndActualVO.getResId());
                    String userName = cacheUtil.getUserName(pmsPersonPlanAndActualVO.getResId());
                    projectPersonPlanDO.setResName(userName);
                    projectPersonPlanDO.setYear(startDateOne.getYear());
                    projectPersonPlanDO.setMonth(startDateOne.getMonthValue());
                    projectPersonPlanDO.setPlanDtlId(pmsPersonPlanAndActualVO.getPlanDtlId());

                    // 计算规划的天数
                    if (!CollectionUtils.isEmpty(dayJsonVOS)) {
                        // 因为规划的都是每天八小时 所以直接按日期来算天数就可以
                        BigDecimal days = BigDecimal.ZERO;
                        for (DayJsonVO dayJsonVO : dayJsonVOS) {
                            LocalDate date = LocalDate.parse(dayJsonVO.getDate(), DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                            if (date.isEqual(startDateOne) || date.isEqual(endDateOne) || (date.isAfter(startDateOne) && date.isBefore(endDateOne))) {
                                days = days.add(dayJsonVO.getDay()).setScale(2, RoundingMode.HALF_UP);
                            }
                        }
                        projectPersonPlanDO.setDays(days);
                    }
                    planTmpDAO.save(projectPersonPlanDO);
                }
            }
        }
        PrdOrgSyncLogDO logDO = new PrdOrgSyncLogDO();
        logDO.setSyncType(syncType);
        logDAO.save(logDO);
    }
}

