package com.elitesland.tw.tw5.server.prd.pms.controller;


import com.elitesland.tw.tw5.api.prd.pms.payload.PmsDistributeRespondPayload;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsDistributeRespondService;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.RespondEnum;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;
import java.util.List;

/**
 * 派发响应
 *
 * @author xxb
 * @date 2023-10-08
 */
@Api(tags = "派发响应")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/pmsDistributeRespond")
@Slf4j
public class PmsDistributeRespondController {

    private final PmsDistributeRespondService pmsDistributeRespondService;

    /**
     * 感兴趣
     *
     * @param list
     * @return
     */
    @PatchMapping("/dist/respond/interested")
    @ApiOperation("感兴趣")
    public TwOutputUtil specifyIntereste(@RequestBody List<PmsDistributeRespondPayload> list) {
        pmsDistributeRespondService.respond(list, RespondEnum.INTERESTED.getCode());
        return TwOutputUtil.ok();
    }

    /**
     * 不感兴趣
     *
     * @param list
     * @return
     */
    @PatchMapping("/dist/respond/notApplicable")
    @ApiOperation("不感兴趣")
    public TwOutputUtil specifyNotApplicable(@RequestBody List<PmsDistributeRespondPayload> list) {
        pmsDistributeRespondService.respond(list, RespondEnum.INTERESTED.getCode());
        return TwOutputUtil.ok();
    }

    /**
     * 批量谢绝
     * @param ids
     * @return
     */
    @PatchMapping("/dist/respond/reject")
    @ApiOperation("谢绝")
    public TwOutputUtil  rejectRespond(List<Long> ids){
        pmsDistributeRespondService.rejectRespond(ids);
        return TwOutputUtil.ok();
    }


//    /**
//     * 派发响应-分页
//     *
//     * @param query 查询
//     * @return {@link TwOutputUtil}
//     */
//    @GetMapping("/paging")
//    // @UdcNameClass
//    @ApiOperation("派发响应-分页")
//    public TwOutputUtil<PagingVO<PmsDistributeRespondVO>> paging(PmsDistributeRespondQuery query) {
//        return TwOutputUtil.ok(pmsDistributeRespondService.queryPaging(query));
//    }

//    /**
//     * 派发响应-新增
//     *
//     * @param payload 有效载荷
//     * @return {@link TwOutputUtil}
//     */
//    @PostMapping
//    @ApiOperation("派发响应-新增")
//    public TwOutputUtil<PmsDistributeRespondVO> insert(@RequestBody PmsDistributeRespondPayload payload) {
//        return TwOutputUtil.ok(pmsDistributeRespondService.insert(payload));
//    }
//
//    /**
//     * 派发响应-更新
//     *
//     * @param payload 有效载荷
//     * @return {@link TwOutputUtil}
//     */
//    @PutMapping
//    @ApiOperation("派发响应-更新")
//    public TwOutputUtil<PmsDistributeRespondVO> update(@RequestBody PmsDistributeRespondPayload payload) {
//        return TwOutputUtil.ok(pmsDistributeRespondService.update(payload));
//    }
//
//    /**
//     * 派发响应-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
//     *
//     * @param payload 有效载荷
//     * @return {@link TwOutputUtil}
//     */
//    @PutMapping("update")
//    @ApiOperation("派发响应-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
//    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody PmsDistributeRespondPayload payload) {
//        return TwOutputUtil.ok(pmsDistributeRespondService.updateByKeyDynamic(payload));
//    }
//
//    /**
//     * 派发响应-主键查询
//     *
//     * @param key 关键
//     * @return {@link TwOutputUtil}
//     */
//    @GetMapping("/{key}")
//    // @UdcNameClass
//    @ApiOperation("派发响应-主键查询")
//    public TwOutputUtil<PmsDistributeRespondVO> queryOneByKey(@PathVariable Long key) {
//        return TwOutputUtil.ok(pmsDistributeRespondService.queryByKey(key));
//    }
//
//
//    /**
//     * 派发响应-查询列表
//     *
//     * @param query 查询
//     * @return {@link TwOutputUtil}
//     */
//    @GetMapping("/list")
//    // @UdcNameClass
//    @ApiOperation("派发响应-查询列表")
//    public TwOutputUtil<List<PmsDistributeRespondVO>> queryList(PmsDistributeRespondQuery query) {
//        return TwOutputUtil.ok(pmsDistributeRespondService.queryListDynamic(query));
//    }
//
//    /**
//     * 派发响应-删除
//     *
//     * @param keys 主键id
//     * @return result
//     */
//    @DeleteMapping("/deleteSoft")
//    @ApiOperation("派发响应-删除")
//    public TwOutputUtil deleteSoft(Long[] keys) {
//        pmsDistributeRespondService.deleteSoft(Arrays.asList(keys));
//        return TwOutputUtil.ok();
//    }

}
