package com.elitesland.tw.tw5.server.prd.pms.controller;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsInspectionItemConfigPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsInspectionItemConfigQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsInspectionItemConfigService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsInspectionItemConfigVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 结项检查项配置
 *
 * @author xxb
 * @date 2023-11-27
 */
@Api(tags = "结项检查项配置")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/pms/pmsInspectionItemConfig")
@Slf4j
public class PmsInspectionItemConfigController {

    private final PmsInspectionItemConfigService pmsInspectionItemConfigService;

    @PostMapping("/batch")
    @ApiOperation("结项检查项配置-批量保存")
    public TwOutputUtil<List<PmsInspectionItemConfigVO>> batchInsertOrUpdate(@RequestBody List<PmsInspectionItemConfigPayload> payloads) {
        pmsInspectionItemConfigService.batchSave(payloads);
        return TwOutputUtil.ok();
    }

    /**
     * 结项检查项配置-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    @UdcNameClass
    @ApiOperation("结项检查项配置-分页")
    public TwOutputUtil<PagingVO<PmsInspectionItemConfigVO>> paging(PmsInspectionItemConfigQuery query) {
        return TwOutputUtil.ok(pmsInspectionItemConfigService.queryPaging(query));
    }

    /**
     * 结项检查项配置-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    @UdcNameClass
    @ApiOperation("结项检查项配置-查询列表")
    public TwOutputUtil<List<PmsInspectionItemConfigVO>> queryList(PmsInspectionItemConfigQuery query) {
        return TwOutputUtil.ok(pmsInspectionItemConfigService.queryListDynamic(query));
    }

//    /**
//     * 结项检查项配置-主键查询
//     *
//     * @param key 关键
//     * @return {@link TwOutputUtil}
//     */
//    @GetMapping("/{key}")
//    @UdcNameClass
//    @ApiOperation("结项检查项配置-主键查询")
//    public TwOutputUtil<PmsInspectionItemConfigVO> queryOneByKey(@PathVariable Long key) {
//        return TwOutputUtil.ok(pmsInspectionItemConfigService.queryByKey(key));
//    }

//    /**
//     * 结项检查项配置-删除
//     *
//     * @param keys 主键id
//     * @return result
//     */
//    @DeleteMapping("/deleteSoft")
//    @ApiOperation("结项检查项配置-删除")
//    public TwOutputUtil deleteSoft(Long[] keys) {
//        pmsInspectionItemConfigService.deleteSoft(Arrays.asList(keys));
//        return TwOutputUtil.ok();
//    }

}
