package com.elitesland.tw.tw5.server.prd.pms.dao;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsDistributePayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsDistributeQuery;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsDistributeVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.pms.entity.PmsDistributeDO;
import com.elitesland.tw.tw5.server.prd.pms.entity.QPmsDistBroadcastDO;
import com.elitesland.tw.tw5.server.prd.pms.entity.QPmsDistributeDO;
import com.elitesland.tw.tw5.server.prd.pms.entity.QPmsDistributeRespondDO;
import com.elitesland.tw.tw5.server.prd.pms.repo.PmsDistributeRepo;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 派发
 *
 * @author xxb
 * @date 2023-08-07
 */
@Repository
@RequiredArgsConstructor
public class PmsDistributeDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final PmsDistributeRepo repo;
    private final QPmsDistributeDO qdo = QPmsDistributeDO.pmsDistributeDO;

    private final QPmsDistributeRespondDO respondQdo = QPmsDistributeRespondDO.pmsDistributeRespondDO;

    private final QPmsDistBroadcastDO broadQdo = QPmsDistBroadcastDO.pmsDistBroadcastDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PmsDistributeVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(PmsDistributeVO.class,
                qdo.id,
                //qdo.remark,
                //qdo.createUserId,
                //qdo.creator,
                qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 派发类型
                qdo.reasonType,
                // 派发事由ID
                qdo.reasonId,
                // 派发事由
                qdo.reasonName,
                // 派发编号
                qdo.distNo,
                // 指派资源ID
                qdo.disterResId,
                // 接收资源ID
                qdo.receiverResId,
                // 派发状态
                qdo.distStatus,
                // 审批状态
                qdo.apprStatus,
                // 派发方式
                qdo.distMethod,
                // 派发说明
                qdo.distDesc,
                // 复合能力
                qdo.capasetLevelId,
                // 单项能力
                qdo.capaIds,
                // 预计开始日期
                qdo.planStartDate,
                // 预计结束日期
                qdo.planEndDate,
                // 流程实例ID
                qdo.procInstId,
                // 流程审批状态
                qdo.procInstStatus
        )).from(qdo);
    }

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PmsDistributeVO> distInnerJoinRespond() {
        return jpaQueryFactory.select(Projections.bean(PmsDistributeVO.class,
                qdo.id,
                //qdo.remark,
                //qdo.createUserId,
                //qdo.creator,
                qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 派发类型
                qdo.reasonType,
                // 派发事由ID
                qdo.reasonId,
                // 派发事由
                qdo.reasonName,
                // 派发编号
                qdo.distNo,
                // 指派资源ID
                qdo.disterResId,
                // 接收资源ID
                qdo.receiverResId,
                // 派发状态
                qdo.distStatus,
                // 审批状态
                qdo.apprStatus,
                // 派发方式
                qdo.distMethod,
                // 派发说明
                qdo.distDesc,
                // 复合能力
                qdo.capasetLevelId,
                // 单项能力
                qdo.capaIds,
                // 预计开始日期
                qdo.planStartDate,
                // 预计结束日期
                qdo.planEndDate,
                //响应描述
                respondQdo.respDesc,
                //响应状态
                respondQdo.respStatus,
                //响应时间
                respondQdo.respTime,
                //响应资源ID
                respondQdo.respondentResId,
                //是否邀请
                respondQdo.inviteFlag,
                //派发id
                respondQdo.id.as("respondId")
        )).from(qdo).innerJoin(respondQdo).on(qdo.id.eq(respondQdo.distId));
    }


    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PmsDistributeVO> broadcastJoinDist() {
        return jpaQueryFactory.select(Projections.bean(PmsDistributeVO.class,
                qdo.id,
                //qdo.remark,
                //qdo.createUserId,
                //qdo.creator,
                qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 派发类型
                qdo.reasonType,
                // 派发事由ID
                qdo.reasonId,
                // 派发事由
                qdo.reasonName,
                // 派发编号
                qdo.distNo,
                // 指派资源ID
                qdo.disterResId,
                // 接收资源ID
                qdo.receiverResId,
                // 派发状态
                qdo.distStatus,
                // 审批状态
                qdo.apprStatus,
                // 派发方式
                qdo.distMethod,
                // 派发说明
                qdo.distDesc,
                // 复合能力
                qdo.capasetLevelId,
                // 单项能力
                qdo.capaIds,
                // 预计开始日期
                qdo.planStartDate,
                // 预计结束日期
                qdo.planEndDate,
                // 工作地国家
                qdo.workCountry,
                // 工作地省
                qdo.workProvince,
                // 现场远程
                qdo.workStyle,
                // 时间要求
                qdo.timeRequirement,
                // 兼职|全职
                qdo.workMethod,
                // 工作地
                qdo.workPlace
        )).from(broadQdo).innerJoin(qdo).on(qdo.id.eq(broadQdo.distId));
    }

    private JPAQuery<PmsDistributeVO> respondInnerJoinDist() {
        return jpaQueryFactory.select(Projections.bean(PmsDistributeVO.class,
                qdo.id,
                //qdo.remark,
                //qdo.createUserId,
                //qdo.creator,
                qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 派发类型
                qdo.reasonType,
                // 派发事由ID
                qdo.reasonId,
                // 派发事由
                qdo.reasonName,
                // 派发编号
                qdo.distNo,
                // 指派资源ID
                qdo.disterResId,
                // 接收资源ID
                qdo.receiverResId,
                // 派发状态
                qdo.distStatus,
                // 审批状态
                qdo.apprStatus,
                // 派发方式
                qdo.distMethod,
                // 派发说明
                qdo.distDesc,
                // 复合能力
                qdo.capasetLevelId,
                // 单项能力
                qdo.capaIds,
                // 预计开始日期
                qdo.planStartDate,
                // 预计结束日期
                qdo.planEndDate,
                // 工作地国家
                qdo.workCountry,
                // 工作地省
                qdo.workProvince,
                // 现场远程
                qdo.workStyle,
                // 时间要求
                qdo.timeRequirement,
                // 兼职|全职
                qdo.workMethod,
                // 工作地
                qdo.workPlace
        )).from(respondQdo).innerJoin(qdo).on(qdo.id.eq(respondQdo.distId));
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<PmsDistributeVO> getJpaQueryWhere(PmsDistributeQuery query) {
        JPAQuery<PmsDistributeVO> jpaQuery = query.getDistInnerJoinRespondFlag() ? distInnerJoinRespond() : query.getRespondInnerJoinDistFlag() ? respondInnerJoinDist() : query.getBroadcastJoinDistFlag() ? broadcastJoinDist() : getJpaQuerySelect();
        // 条件封装
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(PmsDistributeQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
                .select(qdo.count())
                .from(qdo);
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(PmsDistributeQuery query) {
        List<Predicate> list = new ArrayList<>();
        /** 记录唯一ID 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 派发类型 精确 */
        if (!ObjectUtils.isEmpty(query.getReasonType())) {
            list.add(qdo.reasonType.eq(query.getReasonType()));
        }
        /** 派发事由ID 精确 */
        if (!ObjectUtils.isEmpty(query.getReasonId())) {
            list.add(qdo.reasonId.eq(query.getReasonId()));
        }
        /** 派发事由 模糊 */
        if (!ObjectUtils.isEmpty(query.getReasonName())) {
            list.add(qdo.reasonName.like(SqlUtil.toSqlLikeString(query.getReasonName())));
        }
        /** 派发编号 模糊 */
        if (!ObjectUtils.isEmpty(query.getDistNo())) {
            list.add(qdo.distNo.like(SqlUtil.toSqlLikeString(query.getDistNo())));
        }
        /** 指派资源ID 精确 */
        if (!ObjectUtils.isEmpty(query.getDisterResId())) {
            list.add(qdo.disterResId.eq(query.getDisterResId()));
        }
        /** 接收资源ID 精确 */
        if (!ObjectUtils.isEmpty(query.getReceiverResId())) {
            list.add(qdo.receiverResId.eq(query.getReceiverResId()));
        }
        /**
         * 只查 接收人是自己
         */
        if (query.getMyDistFlag()) {
            list.add(qdo.receiverResId.eq(GlobalUtil.getLoginUserId()));
        }
        /** 派发状态 精确 */
        if (!ObjectUtils.isEmpty(query.getDistStatus())) {
            if (!ObjectUtils.isEmpty(query.getDistStatusType())) {
                if ("0".equals(query.getDistStatusType())) {
                    list.add(qdo.distStatus.ne(query.getDistStatus()));
                } else {
                    list.add(qdo.distStatus.eq(query.getDistStatus()));
                }
            }
        }
        /** 审批状态 精确 */
        if (!ObjectUtils.isEmpty(query.getApprStatus())) {
            list.add(qdo.apprStatus.eq(query.getApprStatus()));
        }
        /** 派发方式 精确 */
        if (!ObjectUtils.isEmpty(query.getDistMethod())) {
            list.add(qdo.distMethod.eq(query.getDistMethod()));
        }
        /** 派发说明 精确 */
        if (!ObjectUtils.isEmpty(query.getDistDesc())) {
            list.add(qdo.distDesc.eq(query.getDistDesc()));
        }
        /** 复合能力 精确 */
        if (!ObjectUtils.isEmpty(query.getCapasetLevelId())) {
            list.add(qdo.capasetLevelId.eq(query.getCapasetLevelId()));
        }
        /** 预计开始日期 精确 */
        if (!ObjectUtils.isEmpty(query.getPlanStartDate())) {
            list.add(qdo.planStartDate.eq(query.getPlanStartDate()));
        }
        /** 预计结束日期 精确 */
        if (!ObjectUtils.isEmpty(query.getPlanEndDate())) {
            list.add(qdo.planEndDate.eq(query.getPlanEndDate()));
        }
        /** 现场远程 精确 */
        if (!ObjectUtils.isEmpty(query.getWorkStyle())) {
            list.add(qdo.workStyle.eq(query.getWorkStyle()));
        }
        /** 时间要求 精确 */
        if (!ObjectUtils.isEmpty(query.getTimeRequirement())) {
            list.add(qdo.timeRequirement.eq(query.getTimeRequirement()));
        }
        /** 工作地国家 精确 */
        if (!ObjectUtils.isEmpty(query.getWorkCountry())) {
            list.add(qdo.workCountry.eq(query.getWorkCountry()));
        }
        /** 工作地省 精确 */
        if (!ObjectUtils.isEmpty(query.getWorkProvince())) {
            list.add(qdo.workProvince.eq(query.getWorkProvince()));
        }
        /** 工作地 精确 */
        if (!ObjectUtils.isEmpty(query.getWorkPlace())) {
            list.add(qdo.workPlace.eq(query.getWorkPlace()));
        }
        /** 派发时间 精确 */
        if (!ObjectUtils.isEmpty(query.getStartDate()) && !ObjectUtils.isEmpty(query.getEndDate())) {
            list.add(qdo.createTime.between(query.getStartDate().atStartOfDay(), query.getEndDate().atStartOfDay()));
        }

        /** 响应表条件 精确 */
        if (query.getRespondInnerJoinDistFlag() || query.getDistInnerJoinRespondFlag()) {
            if (!ObjectUtils.isEmpty(query.getRespondentResId())) {
                list.add(respondQdo.respondentResId.eq(query.getRespondentResId()));
            }
            if (!ObjectUtils.isEmpty(query.getInviteFlag())) {
                list.add(respondQdo.inviteFlag.eq(query.getInviteFlag()));
            }
            if (!ObjectUtils.isEmpty(query.getRespStatus())) {
                list.add(respondQdo.respStatus.eq(query.getRespStatus()));
            }
        }

        /** 广播表条件 精确 */
        if (query.getBroadcastJoinDistFlag()) {
            if (!ObjectUtils.isEmpty(query.getNotInIds())) {
                list.add(broadQdo.id.notIn(query.getNotInIds()));
            }
        }
        //需要权限
        if (query.getPermissionFlag()) {
            //研发需求：#7514 派发列表 -> 除运维管理员外，所有用户仅看自己作为派发资源或接收资源的数据
            list.add(qdo.disterResId.eq(query.getLoginUserId()).or(qdo.receiverResId.eq(query.getLoginUserId())));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public PmsDistributeVO queryByKey(Long id) {
        JPAQuery<PmsDistributeVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.eq(id));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 根据主键查询
     *
     * @param ids 主键
     * @return 结果
     */
    public List<PmsDistributeVO> queryByKeys(List<Long> ids) {
        JPAQuery<PmsDistributeVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.in(ids));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetch();
    }


    /**
     * 根据 派发类型  和 派发事由ID  查询
     *
     * @param reasonId   派发事由ID
     * @param reasonType 派发类型
     * @return
     */
    public PmsDistributeVO queryByReason(Long reasonId, String reasonType) {
        JPAQuery<PmsDistributeVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.reasonId.eq(reasonId));
        jpaQuery.where(qdo.reasonType.eq(reasonType));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }


    /**
     * 根据 派发类型  和 派发事由ID  查询
     *
     * @param reasonId   派发事由ID
     * @param reasonType 派发类型
     * @return
     */
    public List<PmsDistributeVO> queryByReasons(List<Long> reasonId, String reasonType) {
        JPAQuery<PmsDistributeVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.reasonId.in(reasonId));
        jpaQuery.where(qdo.reasonType.eq(reasonType));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetch();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<PmsDistributeVO> queryListDynamic(PmsDistributeQuery query) {
        JPAQuery<PmsDistributeVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<PmsDistributeVO> queryPaging(PmsDistributeQuery query) {
        long total = count(query);
        if (total == 0) {
            return PagingVO.empty();
        }
        JPAQuery<PmsDistributeVO> jpaQuery = getJpaQueryWhere(query);
        List<PmsDistributeVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<PmsDistributeVO>builder().records(result).total(total).build();
    }


    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public PmsDistributeDO save(PmsDistributeDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<PmsDistributeDO> saveAll(List<PmsDistributeDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(PmsDistributePayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(payload.getId()));
        // 记录唯一ID
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 派发类型
        if (payload.getReasonType() != null) {
            update.set(qdo.reasonType, payload.getReasonType());
        }
        // 派发事由ID
        if (payload.getReasonId() != null) {
            update.set(qdo.reasonId, payload.getReasonId());
        }
        // 派发编号
        if (payload.getDistNo() != null) {
            update.set(qdo.distNo, payload.getDistNo());
        }
        // 接收资源ID
        if (payload.getDisterResId() != null) {
            update.set(qdo.disterResId, payload.getDisterResId());
        }
        // 接收资源ID
        if (payload.getReceiverResId() != null) {
            update.set(qdo.receiverResId, payload.getReceiverResId());
        }
        // 派发状态
        if (payload.getDistStatus() != null) {
            update.set(qdo.distStatus, payload.getDistStatus());
        }
        // 审批状态
        if (payload.getApprStatus() != null) {
            update.set(qdo.apprStatus, payload.getApprStatus());
        }
        // 派发方式
        if (payload.getDistMethod() != null) {
            update.set(qdo.distMethod, payload.getDistMethod());
        }
        // 派发说明
        if (payload.getDistDesc() != null) {
            update.set(qdo.distDesc, payload.getDistDesc());
        }
        // 预计开始日期
        if (payload.getPlanStartDate() != null) {
            update.set(qdo.planStartDate, payload.getPlanStartDate());
        }
        // 预计结束日期
        if (payload.getPlanEndDate() != null) {
            update.set(qdo.planEndDate, payload.getPlanEndDate());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 记录唯一ID
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 派发类型
            if (nullFields.contains("reasonType")) {
                update.setNull(qdo.reasonType);
            }
            // 派发事由ID
            if (nullFields.contains("reasonId")) {
                update.setNull(qdo.reasonId);
            }
            // 派发编号
            if (nullFields.contains("distNo")) {
                update.setNull(qdo.distNo);
            }
            // 接收资源ID
            if (nullFields.contains("disterResId")) {
                update.setNull(qdo.disterResId);
            }
            // 接收资源ID
            if (nullFields.contains("receiverResId")) {
                update.setNull(qdo.receiverResId);
            }
            // 派发状态
            if (nullFields.contains("distStatus")) {
                update.setNull(qdo.distStatus);
            }
            // 审批状态
            if (nullFields.contains("apprStatus")) {
                update.setNull(qdo.apprStatus);
            }
            // 派发方式
            if (nullFields.contains("distMethod")) {
                update.setNull(qdo.distMethod);
            }
            // 派发说明
            if (nullFields.contains("distDesc")) {
                update.setNull(qdo.distDesc);
            }
            // 预计开始日期
            if (nullFields.contains("planStartDate")) {
                update.setNull(qdo.planStartDate);
            }
            // 预计结束日期
            if (nullFields.contains("planEndDate")) {
                update.setNull(qdo.planEndDate);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }


    /**
     * 变更工作流相关数据
     *
     * @param payload
     * @return
     */
    @Transactional
    public long updateWorkFlow(PmsDistributePayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(payload.getId()));

        // 流程实例id
        if (!ObjectUtils.isEmpty(payload.getProcInstId())) {
            update.set(qdo.procInstId, payload.getProcInstId());
        }
        // 审批状态
        if (!ObjectUtils.isEmpty(payload.getProcInstStatus())) {
            update.set(qdo.procInstStatus, payload.getProcInstStatus());
        }
        // 提审时间
        if (!ObjectUtils.isEmpty(payload.getSubmitTime())) {
            update.set(qdo.submitTime, payload.getSubmitTime());
        }
        // 审批结束时间
        if (!ObjectUtils.isEmpty(payload.getApprovedTime())) {
            update.set(qdo.approvedTime, payload.getApprovedTime());
        }
        // 派发状态
        if (!ObjectUtils.isEmpty(payload.getDistStatus())) {
            update.set(qdo.distStatus, payload.getDistStatus());
        }
        // 删除标识
        if (!ObjectUtils.isEmpty(payload.getDeleteFlag())) {
            update.set(qdo.deleteFlag, payload.getDeleteFlag());
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

}

