package com.elitesland.tw.tw5.server.prd.pms.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeEqvaRatioService;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsResourcePlanPayload;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsResourcePlanRolePayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectQuery;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsResourcePlanDaysQuery;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsResourcePlanQuery;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsResourcePlanRoleQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsResourcePlanDaysService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsResourcePlanRoleService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsResourcePlanService;
import com.elitesland.tw.tw5.api.prd.pms.vo.*;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.PmsReasonTypeEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.ProjectStatusEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.ResourcePlanningCycleEnum;
import com.elitesland.tw.tw5.server.prd.pms.convert.PmsResourcePlanConvert;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsProjectDAO;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsProjectTemplateDAO;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsResourcePlanDAO;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsResourcePlanRoleDAO;
import com.elitesland.tw.tw5.server.prd.pms.entity.PmsResourcePlanDO;
import com.elitesland.tw.tw5.server.prd.pms.repo.PmsResourcePlanRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 资源规划
 *
 * @author xxb
 * @date 2023-08-11
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PmsResourcePlanServiceImpl extends BaseServiceImpl implements PmsResourcePlanService {

    private final PmsResourcePlanRepo pmsResourcePlanRepo;
    private final PmsResourcePlanDAO pmsResourcePlanDAO;

    private final PmsProjectDAO pmsProjectDAO;

    private final PmsProjectTemplateDAO pmsProjectTemplateDAO;

    private final CacheUtil cacheUtil;

    private final PmsResourcePlanRoleService resourcePlanRoleService;
    private final PmsResourcePlanDaysService resourcePlanDaysService;
    private final PmsResourcePlanRoleDAO pmsResourcePlanRoleDAO;
    private final PrdOrgEmployeeEqvaRatioService prdOrgEmployeeEqvaRatioService;

    //@Override
    public PagingVO<PmsResourcePlanVO> queryPaging(PmsResourcePlanQuery query) {
        return pmsResourcePlanDAO.queryPaging(query);
    }

    //@Override
    public List<PmsResourcePlanVO> queryListDynamic(PmsResourcePlanQuery query) {
        return pmsResourcePlanDAO.queryListDynamic(query);
    }

    //@Override
    public PmsResourcePlanVO queryByKey(Long key) {
        PmsResourcePlanDO entity = pmsResourcePlanRepo.findById(key).orElseGet(PmsResourcePlanDO::new);
        Assert.notNull(entity.getId(), "不存在");
        PmsResourcePlanVO vo = PmsResourcePlanConvert.INSTANCE.toVo(entity);
        // 资源规划状态只有正常
        vo.setPlanningStatus("0");
        vo.setPlanningStatusDesc("正常");
        vo.setCreator(cacheUtil.getUserName(vo.getCreateUserId()));
        return vo;
    }

    //@Override
    public PmsResourcePlanVO queryByObjId(PmsResourcePlanQuery query) {
//        if (ObjectUtils.isEmpty(query.getPlanType())) {
//            throw TwException.error("", "计划类型不能为空!");
//        }
        if (ObjectUtils.isEmpty(query.getObjId())) {
            throw TwException.error("", "关联对象ID不能为空!");
        }
        PmsResourcePlanVO resourcePlanVO = null;
        List<PmsResourcePlanVO> list = pmsResourcePlanDAO.queryListDynamic(query);
        if (ObjectUtils.isEmpty(list)) {
            PmsProjectVO pmsProjectVO = pmsProjectDAO.queryByKey(query.getObjId());
            resourcePlanVO = fromProject(query.getObjId(), PmsReasonTypeEnum.PROJ_CONTRACT.getCode(), pmsProjectVO);
        } else {
            resourcePlanVO = list.get(0);
        }
        resourcePlanVO.setPlanningStatusDesc("正常");
        resourcePlanVO.setCreator(cacheUtil.getUserName(resourcePlanVO.getCreateUserId()));
        return resourcePlanVO;
    }

    //@Override
    public Long countByObjId(PmsResourcePlanQuery query) {
        return pmsResourcePlanDAO.count(query);
    }


    //@Override
    @Transactional(rollbackFor = Exception.class)
    public PmsResourcePlanVO insertOrUpdate(PmsResourcePlanPayload payload) {
        // 数据验空
        if (ObjectUtils.isEmpty(payload.getPlanType()) || ObjectUtils.isEmpty(payload.getObjId()) || ObjectUtils.isEmpty(payload.getObjName())) {
            throw TwException.error("", "计划类型、关联对象ID、关联对象不能为空!");
        }
        if (ObjectUtils.isEmpty(payload.getStartDate()) || ObjectUtils.isEmpty(payload.getEndDate())) {
            throw TwException.error("", "开始日期、结束日期不能为空!");
        }
        // 开始日期 不能大于结束日期
        if (payload.getStartDate().isAfter(payload.getEndDate())) {
            throw TwException.error("", "开始日期不能大于结束日期!");
        }
        // 资源规划周期 不能为空
        if (ObjectUtils.isEmpty(payload.getResourcePlanningCycle())) {
            throw TwException.error("", "资源规划周期不能为空!");
        }
        if (ObjectUtils.isEmpty(payload.getDuration())) {
            throw TwException.error("", "持续时长不能为空!");
        }
        // 创建人、更新时间、持续时间不能为空
        if (ObjectUtils.isEmpty(payload.getCreateUserId()) || ObjectUtils.isEmpty(payload.getModifyTime())) {
            throw TwException.error("", "创建人、更新人 不能为空!");
        }
        // 根据 资源规划周期 计算持续 年周
        if (ResourcePlanningCycleEnum.WEEK.getCode().equals(payload.getResourcePlanningCycle())) {
//            List<LocalDate> weeks = resourcePlanRoleService.calculateWeeksBetweenLocalDates(payload.getStartDate(), payload.getEndDate());
//            if (payload.getDuration() != weeks.size()) {
//                throw TwException.error("", "持续周数计算不对！");
//            }
        } else {
//            List<LocalDate> months = resourcePlanRoleService.calculateMonthsBetweenLocalDates(payload.getStartDate(), payload.getEndDate());
//            if (payload.getDuration() != months.size()) {
//                throw TwException.error("", "持续月数计算不对！");
//            }
        }
//        PmsResourcePlanVO pmsResourcePlanVO = pmsResourcePlanDAO.queryByKey(payload.getId());
        // 删除规划年周以外的规划当量
        PmsResourcePlanDaysQuery daysQuery = new PmsResourcePlanDaysQuery();
        daysQuery.setPlanId(payload.getId());
//        List<PmsResourcePlanDaysVO> pmsResourcePlanDaysList = resourcePlanDaysService.queryListDynamic(daysQuery);
//        Set<LocalDate> oldWeekSet = pmsResourcePlanDaysList.stream().map(e -> e.getStartDate()).collect(Collectors.toSet());
//        if (!CollectionUtils.isEmpty(oldWeekSet)) {
//            List<LocalDate> weekList = resourcePlanRoleService.calculateWeeksBetweenLocalDates(payload.getStartDate(), payload.getEndDate());
//            oldWeekSet.removeAll(weekList);
//            // 直接删除这些数据
//            resourcePlanDaysService.deleteSoftByPlanIdAndStartDate(payload.getId(), oldWeekSet);
//        }
        PmsResourcePlanRoleQuery resourcePlanRoleQuery = new PmsResourcePlanRoleQuery();
        resourcePlanRoleQuery.setPlanId(payload.getId());
        List<PmsResourcePlanRoleVO> pmsResourcePlanRoleVOS = null;//resourcePlanRoleService.queryList(resourcePlanRoleQuery);
        LocalDate now = LocalDate.now();
        for (PmsResourcePlanRoleVO pmsResourcePlanRoleVO : pmsResourcePlanRoleVOS) {
            List<PmsResourcePlanDaysVO> daysInfo = pmsResourcePlanRoleVO.getDaysInfo();
            if (!CollectionUtils.isEmpty(daysInfo)) {
                BigDecimal totalDays = daysInfo.stream().map(e -> e.getDays()).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                PmsResourcePlanRolePayload resourcePlanRolePayload = new PmsResourcePlanRolePayload();
                // 重新计算规划当量和人天
                resourcePlanRolePayload.setTotalDays(totalDays);
                resourcePlanRolePayload.setId(pmsResourcePlanRoleVO.getId());
                if (pmsResourcePlanRoleVO.getDistributeRate() == null || pmsResourcePlanRoleVO.getDistributeRate().compareTo(BigDecimal.ZERO) <= 0) {
                    //初始化当量系数
                    BigDecimal eqvaRatio = prdOrgEmployeeEqvaRatioService.getEqvaRatio(pmsResourcePlanRoleVO.getResId(), null);
                    pmsResourcePlanRoleVO.setDistributeRate(eqvaRatio);
                }
                resourcePlanRolePayload.setTotalEqva(pmsResourcePlanRoleVO.getDistributeRate().multiply(totalDays));
                pmsResourcePlanRoleDAO.updateByKeyDynamic(resourcePlanRolePayload);
            }

        }
        // 更新计划的规划当量
        PmsResourcePlanDO entityDo = PmsResourcePlanConvert.INSTANCE.toDo(payload);
        return PmsResourcePlanConvert.INSTANCE.toVo(pmsResourcePlanRepo.save(entityDo));
    }

    //@Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            pmsResourcePlanDAO.deleteSoft(keys);
        }
    }

    //@Override
    public PagingVO<PmsResourcePlanVO> resourcePlanNotice(PmsResourcePlanRoleQuery query) {
        List<PmsResourcePlanVO> list = getPlanVOList(GlobalUtil.getLoginUserId());
        int total = list.size();
        list = list.stream().skip(query.getPageRequest().getOffset()).limit(query.getPageRequest().getPageSize()).collect(Collectors.toList());
        return PagingVO.<PmsResourcePlanVO>builder().records(list).total(total).build();
    }

    //@Override
    public long findRemindCount(Long userId) {
        return getPlanVOList(userId).size();
    }


    /**
     * 符合资源规划更新提醒的数据检索
     * 1，资源规划为空，或者资源规划最后更新日期在 7天前； (7为可配置参数1)
     * 2，项目为激活，工作类型：交付项目(DELIVERY)、内部研发项目（DEVELOP）、T&M项目（T&M）；
     */
    private List<PmsResourcePlanVO> getPlanVOList(Long userId) {
        List<PmsResourcePlanVO> result = new ArrayList<>();
        LocalDate now = LocalDate.now();
        Long projectConfigDaysTime = Long.parseLong("7");

        PmsProjectQuery projectQuery = new PmsProjectQuery();
        projectQuery.setPmResId(userId);
        projectQuery.setProjStatus(ProjectStatusEnum.ACTIVE.getCode());
        projectQuery.setWorkTypes(Arrays.asList("DELIVERY", "DEVELOP", "T&M"));
        List<PmsProjectVO> listProject = pmsProjectDAO.queryListDynamic(projectQuery);
        if (!ObjectUtils.isEmpty(listProject)) {
            Map<Long, PmsProjectVO> projectMap = new HashMap<>();
            List<Long> projectIds = new ArrayList<>();
            listProject.forEach(v -> {
                Long projectId = v.getId();
                projectIds.add(projectId);
                projectMap.put(projectId, v);
            });

            // 查找 资源规划
            PmsResourcePlanQuery query = new PmsResourcePlanQuery();
            query.setObjIds(projectIds);
            query.setPlanType(PmsReasonTypeEnum.PROJ_CONTRACT.getCode());
            List<PmsResourcePlanVO> planVOList = pmsResourcePlanDAO.queryListDynamic(query);

            // 有资源规划的  项目id
            List<Long> hasPlanProject = planVOList.stream().map(v -> v.getObjId()).collect(Collectors.toList());
            // 没有资源规划的  项目id
            List<Long> noPlanProject = projectIds.stream().filter(item -> !hasPlanProject.contains(item)).collect(Collectors.toList());

            // 没有资源规划的
            for (Long projectId : noPlanProject) {
                PmsProjectVO pmsProjectVO = projectMap.get(projectId);
                result.add(fromProject(projectId, PmsReasonTypeEnum.PROJ_CONTRACT.getCode(), pmsProjectVO));
            }
            // 有资源规划的  判断  时间是否符合
            for (PmsResourcePlanVO planVO : planVOList) {
                final LocalDate modifyTime = planVO.getModifyTime().toLocalDate();
                // 计算时间差
                final long between = now.toEpochDay() - modifyTime.toEpochDay();
                if (between > projectConfigDaysTime) {
                    result.add(planVO);
                }
            }
        }
        return result;
    }


    PmsResourcePlanVO fromProject(Long objId, String planType, PmsProjectVO pmsProjectVO) {
        PmsResourcePlanPayload payload = new PmsResourcePlanPayload();
        payload.setObjId(objId);
        payload.setPlanType(planType);
        // 资源规划状态只有正常
        payload.setPlanningStatus("0");
        if (!ObjectUtils.isEmpty(pmsProjectVO)) {
            //资源规划的预计开始-结束日期初始值赋为项目的预计开始-结束日期
            payload.setStartDate(pmsProjectVO.getPlanStartDate());
            payload.setEndDate(pmsProjectVO.getPlanEndDate());
            payload.setObjName(pmsProjectVO.getProjName());
            // 查询项目模板的 资源规划周期: WEEK周 MONTH月
            PmsProjectTemplateVO pmsProjectTemplateVO = pmsProjectTemplateDAO.queryByKey(pmsProjectVO.getProjTempId());


            payload.setResourcePlanningCycle(pmsProjectTemplateVO.getResourcePlanningCycle());
            // 计算持续时长
//            if (ResourcePlanningCycleEnum.WEEK.getCode().equals(pmsProjectTemplateVO.getResourcePlanningCycle())) {
//                payload.setDuration(resourcePlanRoleService.calculateWeeksBetweenLocalDates(payload.getStartDate(), payload.getEndDate()).size());
//            } else {
//                payload.setDuration(resourcePlanRoleService.calculateMonthsBetweenLocalDates(payload.getStartDate(), payload.getEndDate()).size());
//            }
        }
        PmsResourcePlanDO entityDo = PmsResourcePlanConvert.INSTANCE.toDo(payload);
        return PmsResourcePlanConvert.INSTANCE.toVo(pmsResourcePlanRepo.save(entityDo));
    }

}
