package com.elitesland.tw.tw5.server.prd.salecon.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.salecon.payload.ConReceivableDPayload;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConReceivableDQuery;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConReceivableDService;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConReceivableDVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 合同收款明细
 *
 * @author lemon
 * @date 2023-09-05
 */
@Api(tags = "合同收款明细")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/conReceivableD")
@Slf4j
public class ConReceivableDController {

private final ConReceivableDService conReceivableDService;

    /**
     * 合同收款明细-新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("合同收款明细-新增")
    public TwOutputUtil<ConReceivableDVO> insert(@RequestBody ConReceivableDPayload payload){
         return TwOutputUtil.ok(conReceivableDService.insert(payload));
    }

    /**
     * 合同收款明细-更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("合同收款明细-更新")
    public TwOutputUtil<ConReceivableDVO> update(@RequestBody ConReceivableDPayload payload){
        return TwOutputUtil.ok(conReceivableDService.update(payload));
    }

    /**
     * 合同收款明细-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("合同收款明细-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody ConReceivableDPayload payload){
        return TwOutputUtil.ok(conReceivableDService.updateByKeyDynamic(payload));
    }

    /**
     * 合同收款明细-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("合同收款明细-主键查询")
    public TwOutputUtil<ConReceivableDVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(conReceivableDService.queryByKey(key));
    }

    /**
     * 合同收款明细-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("合同收款明细-分页")
    public TwOutputUtil<PagingVO<ConReceivableDVO>> paging(ConReceivableDQuery query) {
        return TwOutputUtil.ok(conReceivableDService.queryPaging(query));
    }

    /**
     * 合同收款明细-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("合同收款明细-查询列表")
    public TwOutputUtil<List<ConReceivableDVO>> queryList(ConReceivableDQuery query) {
        return TwOutputUtil.ok(conReceivableDService.queryListDynamic(query));
    }

    /**
     * 合同收款明细-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("合同收款明细-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
         conReceivableDService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}

