package com.elitesland.tw.tw5.server.prd.salecon.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.salecon.payload.ConInvBatchPayload;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConInvBatchQuery;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConInvBatchVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.inv.entity.QInvItemDO;
import com.elitesland.tw.tw5.server.prd.partner.common.entity.QBusinessPartnerDO;
import com.elitesland.tw.tw5.server.prd.partner.identity.entity.QBusinessCustomerInfoDO;
import com.elitesland.tw.tw5.server.prd.pms.entity.QPmsProjectDO;
import com.elitesland.tw.tw5.server.prd.salecon.entity.*;
import com.elitesland.tw.tw5.server.prd.salecon.repo.ConInvBatchRepo;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;

/**
 * 合同开票批次
 *
 * @author likunpeng
 * @date 2023-07-19
 */
@Repository
@RequiredArgsConstructor
public class ConInvBatchDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final ConInvBatchRepo repo;
    private final QConInvBatchDO qdo = QConInvBatchDO.conInvBatchDO;
    private final QConReceivablePlanDO qPlanDO = QConReceivablePlanDO.conReceivablePlanDO;   // 合同收款计划
    private final QSaleConContractDO qSubConDO = new QSaleConContractDO("subCon");     // 合同表(子合同)
    private final QSaleConContractDO qMainConDO = new QSaleConContractDO("mainCon");     // 合同表(主合同)

    private final QSaleConContractDO qSubConDO1 = new QSaleConContractDO("subCon1");     // 合同表(子合同)
   // private final QPrdOrgCompanyDO qPrdOrgCompanyDO = QPrdOrgCompanyDO.prdOrgCompanyDO; //公司
    // private final QProjectDO qProjectDO = QProjectDO.projectDO;//项目
    private final QPmsProjectDO qPmsProjectDO = QPmsProjectDO.pmsProjectDO;
    private final QConInvBatchInvdtlDO qConInvBatchInvdtlDO = QConInvBatchInvdtlDO.conInvBatchInvdtlDO;//开票批次
    private final QInvItemDO qInvItemDO = QInvItemDO.invItemDO;//商品信息
    private final QConReceivableDO qConReceivableDO = QConReceivableDO.conReceivableDO;//合同收款主表
    // private final QPrdAbDO qPrdAbDO = QPrdAbDO.prdAbDO;
    private final QBusinessPartnerDO businessPartnerDO = QBusinessPartnerDO.businessPartnerDO;
    private final QBusinessPartnerDO qBusinessPartnerDO = new QBusinessPartnerDO("qBusinessPartnerDO");     // 合同表(子合同)
    private final QBusinessCustomerInfoDO qBusinessCustomerInfoDO = QBusinessCustomerInfoDO.businessCustomerInfoDO;
    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<ConInvBatchVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(ConInvBatchVO.class,
                qdo.id,
                qdo.remark,
                qdo.createUserId,
                qdo.creator,
                qdo.createTime,
                qdo.modifyUserId,
                qdo.updater,
                qdo.modifyTime,
                // 批次号
                qdo.batchNo,
                // 批次状态 已申请/待开票/已开票/已取消
                qdo.batchStatus,
                // prd_ab_invoice 发票信息ID
                qdo.invoiceId,
                // 发票抬头
                qdo.invTitle,
                // 发票类型
                qdo.invType,
                // 税率
                qdo.taxRate,
                // 递送方式
                qdo.deliMethod,
                // 收件人
                qdo.contactPerson,
                // 收件人地址 文本录入
                qdo.invAddr,
                // 收件人电话
                qdo.invTel,
                // 开户行
                qdo.bankName,
                // 账号
                qdo.accountNo,
                // 开票日期
                qdo.batchDate,
                // 发票内容
                qdo.invContent,
                // 付款方式
                qdo.payMethod,
                // 开票说明
                qdo.invDesc,
                // 开票主体公司ID
                qSubConDO.ouBookId.as("invOuId"),
                // 开票主体公司名称
                //qPrdOrgCompanyDO.companyName.as("invOuName"),
                qBusinessPartnerDO.partnerName.as("invOuName"),
                // 开票金额（合同开票表）
                qdo.invAmt.as("batchInvAmt"),
                // 开票金额（开票发票表）
                qConInvBatchInvdtlDO.invAmt,
                // 是否自动保存开票信息到地址簿 0 不保存 1保存
                qdo.saveAbFlag,
                // 预计到账日期
                qdo.antiRecvDate,
                // 地址 存放地址簿中的信息
                qdo.addr,
                // 退票原因
                qdo.disDisc,
                // 收件人邮箱
                qdo.invEmail,
                // 发票商品ID 关联 T_INVOICE_ITEM.ID
                qdo.invItemId,
                // 发票商品信息
                qInvItemDO.goodsCodeName.concat("/").concat(qInvItemDO.goodsName).as("goodsNameStr"),
                //总账日期
//                qConReceivableDO.ledgerDate,
                // 流程实例ID
                qdo.procInstId,
                // 流程审批状态
                qdo.procInstStatus,
                // 提交时间
                qdo.submitTime,
                // 审批时间
                qdo.approvedTime,
                // 客户名称
                businessPartnerDO.partnerName.as("custName"),
                // 客户地址簿号
                businessPartnerDO.businessPartnerNo.as("custBookNo"),
                // jde客户编号
                qBusinessCustomerInfoDO.customerNo,
                // 主合同名
                qMainConDO.name.as("contractName"),
                qMainConDO.id.as("contractId"),
                // 子合同id
                qSubConDO.id.as("subContractId"),
                // 子合同号
                qSubConDO.code.as("subContractNo"),
                // 子合同名
                qSubConDO.name.as("subContractName"),
                // 参考合同号
                qSubConDO.referCode,
                // 合同状态
                qSubConDO.status.as("contractStatus"),
                // 项目经理
                qPmsProjectDO.pmResId.as("pmUserId"),
                // 项目id
                qPmsProjectDO.id.as("projId"),
                // 项目编号
                qPmsProjectDO.projNo,
                // 项目名称
                qPmsProjectDO.projName,
                // 发票id
                qConInvBatchInvdtlDO.id.as("invId"),
                // 发票号
                qConInvBatchInvdtlDO.invNo,
                // 快递号码
                qConInvBatchInvdtlDO.deliveryNo,
                // 净额
                qConInvBatchInvdtlDO.netAmt,
                // 税金
                qConInvBatchInvdtlDO.taxAmt,
                //实际开票日期
                qConInvBatchInvdtlDO.actualInvDate,
                // 收款计划id
                qPlanDO.id.as("planId"),
                // 收款阶段
                qPlanDO.receStage.as("phaseDesc"),
                // 预计收款日期
                qPlanDO.expectReceDate.as("expectRecvDate"),
                // 预计开票日期
                qPlanDO.expectInvDate,
                // 主签约BU
                qSubConDO.signBuId,
                // 交付BU
                qSubConDO.deliBuId,
                // PMO
                qSubConDO.pmoUserId,
                qSubConDO.saleManUserId,
                qdo.fileCode,
                qdo.folderId,
                qdo.alreadyInvFlag,
                qdo.productClass,
                qdo.recipientInner,
                qdo.recipientOuter,
                qdo.invFlag,
                qdo.emailFlag,
                qdo.invRemark,
                qdo.saleContractId,
                // 创建人
                qdo.createUserId,
                qdo.saleContractId,
                qdo.workType,
                qdo.recycleSettleFlag,
                // jde单据公司
                qdo.jdeCompany,
                // jde单据号
                qdo.jdeDocumentNo,
                // jde单据类型
                qdo.jdeDocumentType,
                // jde付款项
                qdo.jdePaymentItem,
                // jde发票凭证
                qdo.jdeInvoiceVoucher,
                // jde发票凭证失败原因
                qdo.jdeInvoiceFailReason,
                // jde发票凭证失败原因
                qdo.jdeInvoiceStatus,
                // jde核销收款状态
                qdo.jdeReceiveWriteOffStatus,
                qSubConDO1.code.as("saleContractNo")
        )).from(qdo)
                .leftJoin(qConInvBatchInvdtlDO).on(qConInvBatchInvdtlDO.invbatchId.eq(qdo.id).and(qConInvBatchInvdtlDO.deleteFlag.eq(0)))
                .leftJoin(qPlanDO).on(qdo.id.eq(qPlanDO.invBatchId).and(qPlanDO.deleteFlag.eq(0)))
                .leftJoin(qSubConDO).on(qPlanDO.saleConId.eq(qSubConDO.id).and(qSubConDO.deleteFlag.eq(0)))
                .leftJoin(qPmsProjectDO).on(qPmsProjectDO.contractId.eq(qSubConDO.id).and(qPmsProjectDO.deleteFlag.eq(0)))
                .leftJoin(qMainConDO).on(qSubConDO.parentId.eq(qMainConDO.id).and(qMainConDO.deleteFlag.eq(0)))
                .leftJoin(businessPartnerDO).on(qSubConDO.custId.eq(businessPartnerDO.bookId).and(businessPartnerDO.deleteFlag.eq(0)))
                .leftJoin(qInvItemDO).on(qdo.invItemId.eq(qInvItemDO.id).and(qInvItemDO.deleteFlag.eq(0)))
                .leftJoin(qSubConDO1).on(qdo.saleContractId.eq(qSubConDO1.id).and(qSubConDO1.deleteFlag.eq(0)))
//                .leftJoin(qConReceivableDO).on(qdo.id.eq(qConReceivableDO.sourceId.longValue()).and(qConReceivableDO.deleteFlag.eq(0)).and(qConReceivableDO.recvClass.eq("1")))
                .leftJoin(qBusinessPartnerDO).on(qBusinessPartnerDO.bookId.eq(qSubConDO.ouBookId).and(qBusinessPartnerDO.deleteFlag.eq(0)))
                .leftJoin(qBusinessCustomerInfoDO).on(businessPartnerDO.id.eq(qBusinessCustomerInfoDO.partnerId).and(qBusinessCustomerInfoDO.deleteFlag.eq(0)));
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<ConInvBatchVO> getJpaQueryWhere(ConInvBatchQuery query) {
        JPAQuery<ConInvBatchVO> jpaQuery = getJpaQuerySelect();
            // 条件封装
            jpaQuery.where(where(query));
            // 常用基础查询条件拼装
            SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
            // 非正常的列表查询时，一条开票只保留一条数据
            if (query.getIds() !=null){
                jpaQuery.groupBy(qdo.id);
            }
            // 动态排序
            jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
            return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(ConInvBatchQuery query) {
        long total = getJpaQueryWhere(query).fetch().size();
        return total;
//        JPAQuery<Long> jpaQuery = jpaQueryFactory
//        .select(qdo.count())
//        .from(qdo)
//                .leftJoin(qConInvBatchInvdtlDO).on(qConInvBatchInvdtlDO.invbatchId.eq(qdo.id).and(qConInvBatchInvdtlDO.deleteFlag.eq(0)))
//                .leftJoin(qPlanDO).on(qdo.id.eq(qPlanDO.invBatchId).and(qPlanDO.deleteFlag.eq(0)))
//                .leftJoin(qSubConDO).on(qPlanDO.saleConId.eq(qSubConDO.id).and(qSubConDO.deleteFlag.eq(0)))
//                .leftJoin(qProjectDO).on(qProjectDO.contractId.eq(qSubConDO.id).and(qProjectDO.deleteFlag.eq(0)))
//                .leftJoin(qMainConDO).on(qSubConDO.parentId.eq(qMainConDO.id).and(qMainConDO.deleteFlag.eq(0)))
//                .leftJoin(qPrdAbDO).on(qSubConDO.custId.eq(qPrdAbDO.id).and(qPrdAbDO.deleteFlag.eq(0)))
//                .leftJoin(qInvItemDO).on(qdo.invItemId.eq(qInvItemDO.id).and(qInvItemDO.deleteFlag.eq(0)))
//                .leftJoin(qConReceivableDO).on(qdo.id.eq(qConReceivableDO.sourceId.longValue()).and(qConReceivableDO.deleteFlag.eq(0)).and(qConReceivableDO.recvClass.eq("1")))
//                .leftJoin(qPrdOrgCompanyDO).on(qPrdOrgCompanyDO.id.eq(qSubConDO.ouId).and(qPrdOrgCompanyDO.deleteFlag.eq(0)));
//        jpaQuery.where(where(query));
//        // 常用基础查询条件拼装
//        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
//        long total = jpaQuery.fetchOne();
//        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(ConInvBatchQuery query){
        List<Predicate> list = new ArrayList<>();
        /** 记录唯一ID 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        if (!CollectionUtils.isEmpty(query.getIds())) {
            list.add(qdo.id.in(query.getIds()));
        }
        /** 批次号 模糊 */
        if (!ObjectUtils.isEmpty(query.getBatchNo())) {
             list.add(qdo.batchNo.like(SqlUtil.toSqlLikeString(query.getBatchNo())));
        }
        /** 批次状态 已申请/待开票/已开票/已取消 精确 */
        if (!ObjectUtils.isEmpty(query.getBatchStatus())) {
            list.add(qdo.batchStatus.eq(query.getBatchStatus()));
        }
        /** prd_ab_invoice 发票信息ID 精确 */
        if (!ObjectUtils.isEmpty(query.getInvoiceId())) {
             list.add(qdo.invoiceId.eq(query.getInvoiceId()));
        }
        /** 发票号码 模糊 */
        if (!ObjectUtils.isEmpty(query.getInvNo())) {
            list.add(qConInvBatchInvdtlDO.invNo.like(SqlUtil.toSqlLikeString(query.getInvNo())));
        }
        /** 发票抬头 模糊 */
        if (!ObjectUtils.isEmpty(query.getInvTitle())) {
             list.add(qdo.invTitle.like(SqlUtil.toSqlLikeString(query.getInvTitle())));
        }
        /** 客户id */
//        if (!ObjectUtils.isEmpty(query.getCustId())) {
//            list.add(qPrdAbDO.id.eq(query.getCustId()));
//        }
        if (!ObjectUtils.isEmpty(query.getCustId())) {
            list.add(qBusinessPartnerDO.bookId.eq(query.getCustId()));
        }
        /** 客户名称 模糊 */
//        if (!ObjectUtils.isEmpty(query.getCustName())) {
//            list.add(qPrdAbDO.bookName.like(SqlUtil.toSqlLikeString(query.getCustName())));
//        }
        if (!ObjectUtils.isEmpty(query.getCustName())) {
            list.add(qBusinessPartnerDO.partnerName.like(SqlUtil.toSqlLikeString(query.getCustName())));
        }
        /** 主合同名称 模糊 */
        if (!ObjectUtils.isEmpty(query.getContractName())) {
            list.add(qMainConDO.name.like(SqlUtil.toSqlLikeString(query.getContractName())));
        }
        /** 子合同名称 模糊 */
        if (!ObjectUtils.isEmpty(query.getSubContractName())) {
            list.add(qSubConDO.name.like(SqlUtil.toSqlLikeString(query.getSubContractName())));
        }
        /** 子合同号 模糊 */
        if (!ObjectUtils.isEmpty(query.getSubContractNo())) {
            list.add(qSubConDO.code.like(SqlUtil.toSqlLikeString(query.getSubContractNo())));
        }
        /** 预计开票日期 区间 */
        if (!ObjectUtils.isEmpty(query.getBatchDate())) {
            list.add(qPlanDO.expectInvDate.between(query.getBatchDate().get(0),query.getBatchDate().get(1)));
        }
        /** 批次状态 区间 */
        if (!CollectionUtils.isEmpty(query.getBatchStatusList())) {
            list.add(qdo.batchStatus.in(query.getBatchStatusList()));
        }

        /** 预计收款日期 区间 */
        if (!ObjectUtils.isEmpty(query.getExpectReceDate())) {
            list.add(qPlanDO.expectReceDate.between(query.getExpectReceDate().get(0),query.getExpectReceDate().get(1)));
        }

        /** 逾期天数 区间 */
        if (!ObjectUtils.isEmpty(query.getOverDays())) {
            LocalDate end = LocalDate.now();
            LocalDate start = end.minusDays(query.getOverDays());
            list.add(qPlanDO.expectReceDate.between(start,end));
        }

        /** PMO 模糊 */
        if (!ObjectUtils.isEmpty(query.getPmoUserId())) {
            list.add(qSubConDO.pmoUserId.eq(query.getPmoUserId()));
        }

        /** 发票类型 精确 */
        if (!ObjectUtils.isEmpty(query.getInvType())) {
            list.add(qdo.invType.eq(query.getInvType()));
        }
        /** 税率 精确 */
        if (!ObjectUtils.isEmpty(query.getTaxRate())) {
            list.add(qdo.taxRate.eq(query.getTaxRate()));
        }
        /** 递送方式 精确 */
        if (!ObjectUtils.isEmpty(query.getDeliMethod())) {
            list.add(qdo.deliMethod.eq(query.getDeliMethod()));
        }
        /** 收件人 精确 */
        if (!ObjectUtils.isEmpty(query.getContactPerson())) {
            list.add(qdo.contactPerson.eq(query.getContactPerson()));
        }
        /** 收件人地址 文本录入 精确 */
        if (!ObjectUtils.isEmpty(query.getInvAddr())) {
            list.add(qdo.invAddr.eq(query.getInvAddr()));
        }
        /** 收件人电话 精确 */
        if (!ObjectUtils.isEmpty(query.getInvTel())) {
            list.add(qdo.invTel.eq(query.getInvTel()));
        }
        /** 开户行 精确 */
        if (!ObjectUtils.isEmpty(query.getBankName())) {
            list.add(qdo.bankName.eq(query.getBankName()));
        }
        /** 账号 模糊 */
        if (!ObjectUtils.isEmpty(query.getAccountNo())) {
             list.add(qdo.accountNo.like(SqlUtil.toSqlLikeString(query.getAccountNo())));
        }

        /** 发票内容 精确 */
        if (!ObjectUtils.isEmpty(query.getInvContent())) {
            list.add(qdo.invContent.eq(query.getInvContent()));
        }
        /** 付款方式 精确 */
        if (!ObjectUtils.isEmpty(query.getPayMethod())) {
            list.add(qdo.payMethod.eq(query.getPayMethod()));
        }
        /** 开票说明 精确 */
        if (!ObjectUtils.isEmpty(query.getInvDesc())) {
            list.add(qdo.invDesc.eq(query.getInvDesc()));
        }
        /** 开票主体公司ID 精确 */
        if (!ObjectUtils.isEmpty(query.getInvOuId())) {
            list.add(qdo.invOuId.eq(query.getInvOuId()));
        }
        /** 开票金额 精确 */
        if (!ObjectUtils.isEmpty(query.getInvAmt())) {
            list.add(qdo.invAmt.eq(query.getInvAmt()));
        }
        /** 是否自动保存开票信息到地址簿 0 不保存 1保存 精确 */
        if (!ObjectUtils.isEmpty(query.getSaveAbFlag())) {
            list.add(qdo.saveAbFlag.eq(query.getSaveAbFlag()));
        }
        /** 预计到账日期 精确 */
        if (!ObjectUtils.isEmpty(query.getAntiRecvDate())) {
            list.add(qdo.antiRecvDate.eq(query.getAntiRecvDate()));
        }
        /** 地址 存放地址簿中的信息 精确 */
        if (!ObjectUtils.isEmpty(query.getAddr())) {
            list.add(qdo.addr.eq(query.getAddr()));
        }
        /** 退票原因 精确 */
        if (!ObjectUtils.isEmpty(query.getDisDisc())) {
            list.add(qdo.disDisc.eq(query.getDisDisc()));
        }
        /** 收件人邮箱 精确 */
        if (!ObjectUtils.isEmpty(query.getInvEmail())) {
            list.add(qdo.invEmail.eq(query.getInvEmail()));
        }
        /** 发票商品ID 关联 T_INVOICE_ITEM.ID 精确 */
        if (!ObjectUtils.isEmpty(query.getInvItemId())) {
            list.add(qdo.invItemId.eq(query.getInvItemId()));
        }
        /** 流程实例ID 精确 */
        if (!ObjectUtils.isEmpty(query.getProcInstId())) {
            list.add(qdo.procInstId.eq(query.getProcInstId()));
        }
        /** 流程审批状态 精确 */
        if (!ObjectUtils.isEmpty(query.getProcInstStatus())) {
            list.add(qdo.procInstStatus.eq(query.getProcInstStatus()));
        }
        /** 提交时间 精确 */
        if (!ObjectUtils.isEmpty(query.getSubmitTime())) {
            list.add(qdo.submitTime.eq(query.getSubmitTime()));
        }
        /** 审批时间 精确 */
        if (!ObjectUtils.isEmpty(query.getApprovedTime())) {
            list.add(qdo.approvedTime.eq(query.getApprovedTime()));
        }
        /** 创建人 精确 */
        if (!ObjectUtils.isEmpty(query.getCreateUserId())) {
            list.add(qdo.createUserId.eq(query.getCreateUserId()));
        }
        /** 部门权限 精确 */
        if (!CollectionUtils.isEmpty(query.getAuthOuIds())) {
            // 主签约BU与交付BU
            list.add(qSubConDO.signBuId.in(query.getAuthOuIds()).or(qSubConDO.deliBuId.in(query.getAuthOuIds())));
        }
        /** 发票类型 精确 */
        if (!ObjectUtils.isEmpty(query.getInvStatus())) {
            list.add(qConInvBatchInvdtlDO.invStatus.eq(query.getInvStatus()));
        }
        /** 发起退票日期 区间 */
        if (!ObjectUtils.isEmpty(query.getRefundDate())) {
            LocalDateTime timeFrom = LocalDateTime.of(query.getRefundDate().get(0), LocalTime.MIN);
            LocalDateTime timeTo = LocalDateTime.of(query.getRefundDate().get(1).plusDays(1), LocalTime.MIN);
            list.add(qConInvBatchInvdtlDO.createTime.between(timeFrom,timeTo));
        }

        /** jde单据公司 精确 */
        if (!ObjectUtils.isEmpty(query.getJdeCompany())) {
            list.add(qdo.jdeCompany.eq(query.getJdeCompany()));
        }
        /** jde单据号  精确 */
        if (!ObjectUtils.isEmpty(query.getJdeDocumentNo())) {
            list.add(qdo.jdeDocumentNo.eq(query.getJdeDocumentNo()));
        }
        /** jde单据类型 精确 */
        if (!ObjectUtils.isEmpty(query.getJdeDocumentType())) {
            list.add(qdo.jdeDocumentType.eq(query.getJdeDocumentType()));
        }
        /** jde付款项 精确 */
        if (!ObjectUtils.isEmpty(query.getJdePaymentItem())) {
            list.add(qdo.jdePaymentItem.eq(query.getJdePaymentItem()));
        }
        /** jde发票凭证 精确 */
        if (!ObjectUtils.isEmpty(query.getJdeInvoiceVoucher())) {
            list.add(qdo.jdeInvoiceVoucher.like(query.getJdeInvoiceVoucher()));
        }
        /** jde发票凭证失败原因 精确 */
        if (!ObjectUtils.isEmpty(query.getJdeInvoiceFailReason())) {
            list.add(qdo.jdeInvoiceFailReason.like(query.getJdeInvoiceFailReason()));
        }

        /** jde发票凭证失败原因 精确 */
        if (!ObjectUtils.isEmpty(query.getJdeInvoiceStatus())) {
            list.add(qdo.jdeInvoiceStatus.like(query.getJdeInvoiceStatus()));
        }
        /** jde发票凭证失败原因 精确 */
        if (!ObjectUtils.isEmpty(query.getJdeReceiveWriteOffStatus())) {
            list.add(qdo.jdeReceiveWriteOffStatus.like(query.getJdeReceiveWriteOffStatus()));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public ConInvBatchVO  queryByKey(Long id) {
        JPAQuery<ConInvBatchVO> jpaQuery = getJpaQuerySelect();
            jpaQuery.where(qdo.id.eq(id));
            jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<ConInvBatchVO> queryListDynamic(ConInvBatchQuery query) {
        JPAQuery<ConInvBatchVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<ConInvBatchVO> queryPaging(ConInvBatchQuery query) {
        long total = count(query);
        if (total == 0) {
             return PagingVO.empty();
        }
        JPAQuery<ConInvBatchVO> jpaQuery = getJpaQueryWhere(query);
        List<ConInvBatchVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<ConInvBatchVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public ConInvBatchDO save(ConInvBatchDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<ConInvBatchDO> saveAll(List<ConInvBatchDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(ConInvBatchPayload payload) {
        JPAUpdateClause update = null;
        if(!CollectionUtils.isEmpty(payload.getIds())){
            update = jpaQueryFactory.update(qdo).where(qdo.id.in(payload.getIds()));
        }else{
            update = jpaQueryFactory.update(qdo).where(qdo.id.eq(payload.getId()));
        }
        // 记录唯一ID
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 批次号
        if (payload.getBatchNo() != null) {
            update.set(qdo.batchNo, payload.getBatchNo());
        }
        // 批次状态 已申请/待开票/已开票/已取消
        if (payload.getBatchStatus() != null) {
            update.set(qdo.batchStatus, payload.getBatchStatus());
        }
        // prd_ab_invoice 发票信息ID
        if (payload.getInvoiceId() != null) {
            update.set(qdo.invoiceId, payload.getInvoiceId());
        }
        // 发票抬头
        if (payload.getInvTitle() != null) {
            update.set(qdo.invTitle, payload.getInvTitle());
        }
        // 发票类型
        if (payload.getInvType() != null) {
            update.set(qdo.invType, payload.getInvType());
        }
        // 税率
        if (payload.getTaxRate() != null) {
            update.set(qdo.taxRate, payload.getTaxRate());
        }
        // 递送方式
        if (payload.getDeliMethod() != null) {
            update.set(qdo.deliMethod, payload.getDeliMethod());
        }
        // 收件人
        if (payload.getContactPerson() != null) {
            update.set(qdo.contactPerson, payload.getContactPerson());
        }
        // 收件人地址 文本录入
        if (payload.getInvAddr() != null) {
            update.set(qdo.invAddr, payload.getInvAddr());
        }
        // 收件人电话
        if (payload.getInvTel() != null) {
            update.set(qdo.invTel, payload.getInvTel());
        }
        // 开户行
        if (payload.getBankName() != null) {
            update.set(qdo.bankName, payload.getBankName());
        }
        // 账号
        if (payload.getAccountNo() != null) {
            update.set(qdo.accountNo, payload.getAccountNo());
        }
        // 开票日期
        if (payload.getBatchDate() != null) {
            update.set(qdo.batchDate, payload.getBatchDate());
        }
        // 发票内容
        if (payload.getInvContent() != null) {
            update.set(qdo.invContent, payload.getInvContent());
        }
        // 付款方式
        if (payload.getPayMethod() != null) {
            update.set(qdo.payMethod, payload.getPayMethod());
        }
        // 开票说明
        if (payload.getInvDesc() != null) {
            update.set(qdo.invDesc, payload.getInvDesc());
        }
        // 开票主体公司ID
        if (payload.getInvOuId() != null) {
            update.set(qdo.invOuId, payload.getInvOuId());
        }
        // 开票金额
        if (payload.getInvAmt() != null) {
            update.set(qdo.invAmt, payload.getInvAmt());
        }
        // 是否自动保存开票信息到地址簿 0 不保存 1保存
        if (payload.getSaveAbFlag() != null) {
            update.set(qdo.saveAbFlag, payload.getSaveAbFlag());
        }
        // 预计到账日期
        if (payload.getAntiRecvDate() != null) {
            update.set(qdo.antiRecvDate, payload.getAntiRecvDate());
        }
        // 地址 存放地址簿中的信息
        if (payload.getAddr() != null) {
            update.set(qdo.addr, payload.getAddr());
        }
        // 退票原因
        if (payload.getDisDisc() != null) {
            update.set(qdo.disDisc, payload.getDisDisc());
        }
        // 收件人邮箱
        if (payload.getInvEmail() != null) {
            update.set(qdo.invEmail, payload.getInvEmail());
        }
        // 发票商品ID 关联 T_INVOICE_ITEM.ID
        if (payload.getInvItemId() != null) {
            update.set(qdo.invItemId, payload.getInvItemId());
        }
        // 流程实例ID
        if (payload.getProcInstId() != null) {
            update.set(qdo.procInstId, payload.getProcInstId());
        }
        // 流程审批状态
        if (payload.getProcInstStatus() != null) {
            update.set(qdo.procInstStatus, payload.getProcInstStatus());
        }
        // 提交时间
        if (payload.getSubmitTime() != null) {
            update.set(qdo.submitTime, payload.getSubmitTime());
        }
        // 审批时间
        if (payload.getApprovedTime() != null) {
            update.set(qdo.approvedTime, payload.getApprovedTime());
        }
        // 审批时间
        if (payload.getFileCode() != null) {
            update.set(qdo.fileCode, payload.getFileCode());
        }
        // 审批时间
        if (payload.getFolderId() != null) {
            update.set(qdo.folderId, payload.getFolderId());
        }
        // 删除标志
        if (payload.getDeleteFlag() != null) {
            update.set(qdo.deleteFlag, payload.getDeleteFlag());
        }
        // 结算单回收标志
        if (payload.getRecycleSettleFlag() != null) {
            update.set(qdo.recycleSettleFlag, payload.getRecycleSettleFlag());
        }

        // jde发票公司
        if (payload.getJdeCompany() != null) {
            update.set(qdo.jdeCompany, payload.getJdeCompany());
        }
        // jde发票号
        if (payload.getJdeDocumentNo() != null) {
            update.set(qdo.jdeDocumentNo, payload.getJdeDocumentNo());
        }
        // jde发票凭证号
        if (payload.getJdeInvoiceVoucher() != null) {
            update.set(qdo.jdeInvoiceVoucher, payload.getJdeInvoiceVoucher());
        }
        // jde发票类型
        if (payload.getJdeDocumentType() != null) {
            update.set(qdo.jdeDocumentType, payload.getJdeDocumentType());
        }

        // jde付款项
        if (payload.getJdePaymentItem() != null) {
            update.set(qdo.jdePaymentItem, payload.getJdePaymentItem());
        }

        // jde发票凭证状态
        if (payload.getJdeInvoiceStatus() != null) {
            update.set(qdo.jdeInvoiceStatus, payload.getJdeInvoiceStatus());
        }

        // jde核销收款状态
        if (payload.getJdeReceiveWriteOffStatus() != null) {
            update.set(qdo.jdeReceiveWriteOffStatus, payload.getJdeReceiveWriteOffStatus());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 记录唯一ID
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 批次号
            if (nullFields.contains("batchNo")) {
                update.setNull(qdo.batchNo);
            }
            // 批次状态 已申请/待开票/已开票/已取消
            if (nullFields.contains("batchStatus")) {
                update.setNull(qdo.batchStatus);
            }
            // prd_ab_invoice 发票信息ID
            if (nullFields.contains("invoiceId")) {
                update.setNull(qdo.invoiceId);
            }
            // 发票抬头
            if (nullFields.contains("invTitle")) {
                update.setNull(qdo.invTitle);
            }
            // 发票类型
            if (nullFields.contains("invType")) {
                update.setNull(qdo.invType);
            }
            // 税率
            if (nullFields.contains("taxRate")) {
                update.setNull(qdo.taxRate);
            }
            // 递送方式
            if (nullFields.contains("deliMethod")) {
                update.setNull(qdo.deliMethod);
            }
            // 收件人
            if (nullFields.contains("contactPerson")) {
                update.setNull(qdo.contactPerson);
            }
            // 收件人地址 文本录入
            if (nullFields.contains("invAddr")) {
                update.setNull(qdo.invAddr);
            }
            // 收件人电话
            if (nullFields.contains("invTel")) {
                update.setNull(qdo.invTel);
            }
            // 开户行
            if (nullFields.contains("bankName")) {
                update.setNull(qdo.bankName);
            }
            // 账号
            if (nullFields.contains("accountNo")) {
                update.setNull(qdo.accountNo);
            }
            // 开票日期
            if (nullFields.contains("batchDate")) {
                update.setNull(qdo.batchDate);
            }
            // 发票内容
            if (nullFields.contains("invContent")) {
                update.setNull(qdo.invContent);
            }
            // 付款方式
            if (nullFields.contains("payMethod")) {
                update.setNull(qdo.payMethod);
            }
            // 开票说明
            if (nullFields.contains("invDesc")) {
                update.setNull(qdo.invDesc);
            }
            // 开票主体公司ID
            if (nullFields.contains("invOuId")) {
                update.setNull(qdo.invOuId);
            }
            // 开票金额
            if (nullFields.contains("invAmt")) {
                update.setNull(qdo.invAmt);
            }
            // 是否自动保存开票信息到地址簿 0 不保存 1保存
            if (nullFields.contains("saveAbFlag")) {
                update.setNull(qdo.saveAbFlag);
            }
            // 预计到账日期
            if (nullFields.contains("antiRecvDate")) {
                update.setNull(qdo.antiRecvDate);
            }
            // 地址 存放地址簿中的信息
            if (nullFields.contains("addr")) {
                update.setNull(qdo.addr);
            }
            // 退票原因
            if (nullFields.contains("disDisc")) {
                update.setNull(qdo.disDisc);
            }
            // 收件人邮箱
            if (nullFields.contains("invEmail")) {
                update.setNull(qdo.invEmail);
            }
            // 发票商品ID 关联 T_INVOICE_ITEM.ID
            if (nullFields.contains("invItemId")) {
                update.setNull(qdo.invItemId);
            }
            // 流程实例ID
            if (nullFields.contains("procInstId")) {
                update.setNull(qdo.procInstId);
            }
            // 流程审批状态
            if (nullFields.contains("procInstStatus")) {
                update.setNull(qdo.procInstStatus);
            }
            // 提交时间
            if (nullFields.contains("submitTime")) {
                update.setNull(qdo.submitTime);
            }
            // 审批时间
            if (nullFields.contains("approvedTime")) {
                update.setNull(qdo.approvedTime);
            }
            // 易道壳文件夹
            if (nullFields.contains("fileCode")) {
                update.setNull(qdo.fileCode);
            }
            // 易道壳文件库
            if (nullFields.contains("folderId")) {
                update.setNull(qdo.folderId);
            }
            // 是否回收
            if (nullFields.contains("recycleSettleFlag")) {
                update.setNull(qdo.recycleSettleFlag);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
            .set(qdo.deleteFlag, 1)
            .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }
    /**
     * 根据主键查询
     *
     * @param custId 主键
     * @return 结果
     */
    public List<ConInvBatchVO>  getHistoryInv(Long custId) {
        JPAQuery<ConInvBatchVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qMainConDO.custId.eq(custId));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetch();
    }

    public Long updateBatchStatusById(Long id, String batchStatus) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.batchStatus, batchStatus)
                .where(qdo.id.eq(id));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

}

