package com.elitesland.tw.tw5.server.prd.system.controller;

import com.elitesland.tw.tw5.api.prd.org.query.PrdOrgEmployeeQuery;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemNewFunctionPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemNewFunctionQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemNewFunctionService;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;

/**
 * 业务对象的 功能列表
 *
 * @Author Bill
 * @Date 2023/9/18 13:30
 **/
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/system")
@Slf4j
public class PrdSystemNewFunctionController {

    private final PrdSystemNewFunctionService service;

    /**
     * 业务对象 功能列表 新增
     * @param payload
     * @return
     */
    @PostMapping("/newFunction")
    public TwOutputUtil insert(PrdSystemNewFunctionPayload payload){
        return TwOutputUtil.ok(service.insert(payload));
    }

    /**
     * 业务对象 功能列表修改
     * @param payload
     * @return
     */
    @PutMapping("/newFunction")
    public TwOutputUtil update(PrdSystemNewFunctionPayload payload){
        return TwOutputUtil.ok(service.update(payload));
    }

    /**
     * 功能列表 分页
     * @param query
     * @return
     */
    @GetMapping("/newFunction/paging")
    public TwOutputUtil paging(PrdSystemNewFunctionQuery query){
        return TwOutputUtil.ok(service.paging(query));
    }

    /**
     * 功能列表 分页 keyword多列匹配
     * @param query
     * @return
     */
    @GetMapping("/newFunction/pagingKeyword")
    public TwOutputUtil pagingKeyword(PrdSystemNewFunctionQuery query){
        return TwOutputUtil.ok(service.pagingKeyword(query));
    }

    /**
     * 业务对象 功能类别逻辑删除
     * @param keys
     * @return
     */
    @DeleteMapping("/newFunction/deleteSoft")
    public TwOutputUtil deleteSoft(Long[] keys){
        service.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    /**
     * 业务对象 功能列表主键查询
     * @param id
     * @return
     */
    @GetMapping("/newFunction/{id}")
    public TwOutputUtil get(@PathVariable Long id){
        return TwOutputUtil.ok(service.get(id));
    }

    /**
     * 业务对象 那些用户拥有该功能
     * @param query
     * @return
     */
    @GetMapping("/newFunction/pagingUser")
    public TwOutputUtil pagingUser(PrdOrgEmployeeQuery query) {
        return TwOutputUtil.ok(service.pagingUser(query));
    }

    /**
     * 业务对象 功能下拉框
     * @param objectId
     * @return
     */
    @GetMapping("/newFunction/list/{objectId}")
    public TwOutputUtil list(@PathVariable Long objectId) {
        return TwOutputUtil.ok(service.list(objectId));
    }

    /**
     * 业务对象 可配置功能列表
     *
     * @param objectId
     * @return
     */
    @GetMapping("/newFunction/list/fieldConfig/{objectId}")
    public TwOutputUtil listFieldConfig(@PathVariable Long objectId) {
        return TwOutputUtil.ok(service.listFieldConfig(objectId));
    }

}
