package com.elitesland.tw.tw5.server.prd.system.controller;


import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemSitePayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemSiteQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemSiteService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemSiteVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import com.elitescloud.cloudt.common.base.PagingVO;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 公共地点表
 *
 * @author zoey
 * @date 2024-04-22
 */
@Api(tags = "公共地点表")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/prdSystemSite")
@Slf4j
public class PrdSystemSiteController {

private final PrdSystemSiteService prdSystemSiteService;

    /**
     * 公共地点表-新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("公共地点表-新增")
    public TwOutputUtil<PrdSystemSiteVO> insert(@RequestBody PrdSystemSitePayload payload){
         return TwOutputUtil.ok(prdSystemSiteService.insert(payload));
    }

    /**
     * 公共地点表-更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("公共地点表-更新")
    public TwOutputUtil<PrdSystemSiteVO> update(@RequestBody PrdSystemSitePayload payload){
        return TwOutputUtil.ok(prdSystemSiteService.update(payload));
    }

    /**
     * 公共地点表-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("公共地点表-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody PrdSystemSitePayload payload){
        return TwOutputUtil.ok(prdSystemSiteService.updateByKeyDynamic(payload));
    }

    /**
     * 公共地点表-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("公共地点表-主键查询")
    public TwOutputUtil<PrdSystemSiteVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(prdSystemSiteService.queryByKey(key));
    }

    /**
     * 公共地点表-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    @UdcNameClass
    @ApiOperation("公共地点表-分页")
    public TwOutputUtil<PagingVO<PrdSystemSiteVO>> paging(PrdSystemSiteQuery query) {
        return TwOutputUtil.ok(prdSystemSiteService.queryPaging(query));
    }

    /**
     * 公共地点表-单纯分页,不关联业务单据
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/purPaging")
    @UdcNameClass
    @ApiOperation("公共地点表-分页")
    public TwOutputUtil<PagingVO<PrdSystemSiteVO>> purPaging(PrdSystemSiteQuery query) {
        return TwOutputUtil.ok(prdSystemSiteService.queryPurPaging(query));
    }

    /**
     * 公共地点表-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    @UdcNameClass
    @ApiOperation("公共地点表-查询列表")
    public TwOutputUtil<List<PrdSystemSiteVO>> queryList(PrdSystemSiteQuery query) {
        return TwOutputUtil.ok(prdSystemSiteService.queryListDynamic(query));
    }

    /**
     * 公共地点表-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("公共地点表-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
         prdSystemSiteService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}

