package com.elitesland.tw.tw5.server.prd.ts.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.budget.service.BudgetCommonService;
import com.elitesland.tw.tw5.api.prd.budget.service.BudgetService;
import com.elitesland.tw.tw5.api.prd.budget.vo.BudgetCommonVO;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOpportunityQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpportunityService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityListVO;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgOrganizationService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgOrganizationRefVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgOrganizationVO;
import com.elitesland.tw.tw5.api.prd.pms.service.BuProjectService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectService;
import com.elitesland.tw.tw5.api.prd.pms.vo.BuProjectVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemSelectionVO;
import com.elitesland.tw.tw5.api.prd.task.service.TaskPackageService;
import com.elitesland.tw.tw5.api.prd.task.vo.TaskPackageVO;
import com.elitesland.tw.tw5.api.prd.ts.payload.TsApprovalConfigPayload;
import com.elitesland.tw.tw5.api.prd.ts.payload.TsApprovalResPayload;
import com.elitesland.tw.tw5.api.prd.ts.query.TsApprovalConfigQuery;
import com.elitesland.tw.tw5.api.prd.ts.service.TsApprovalConfigService;
import com.elitesland.tw.tw5.api.prd.ts.vo.TsApprovalConfigVO;
import com.elitesland.tw.tw5.api.prd.ts.vo.TsApprovalRoleResVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.TsEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.PmsReasonTypeEnum;
import com.elitesland.tw.tw5.server.prd.ts.convert.TsApprovalConfigConvert;
import com.elitesland.tw.tw5.server.prd.ts.dao.TsApprovalConfigDAO;
import com.elitesland.tw.tw5.server.prd.ts.entity.TsApprovalConfigDO;
import com.elitesland.tw.tw5.server.prd.ts.repo.TsApprovalConfigRepo;
import com.elitesland.tw.tw5.server.udc.UdcUtil;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;

import static com.elitesland.tw.tw5.server.prd.my.constant.TimesheetStatus.APPROVING;
import static com.elitesland.tw.tw5.server.prd.my.constant.TimesheetStatus.BEFOREAPPROVE;

/**
 * 工时审批配置管理
 *
 * @author carl
 * @date 2024-04-29
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class TsApprovalConfigServiceImpl extends BaseServiceImpl implements TsApprovalConfigService {

    private final TsApprovalConfigRepo tsApprovalConfigRepo;
    private final TsApprovalConfigDAO tsApprovalConfigDAO;
    private final CacheUtil cacheUtil;
    private final TaskPackageService taskPackageService;
    private final PmsProjectService pmsProjectService;
    private final BuProjectService buProjectService;
    private final CrmOpportunityService opportunityService;
    private final PrdOrgOrganizationService prdOrgOrganizationService;
    private final BudgetService budgetService;
    private final BudgetCommonService budgetCommonService;
    private final UdcUtil udcUtil;

    @Override
    public PagingVO<TsApprovalConfigVO> queryPaging(TsApprovalConfigQuery query) {
        PagingVO<TsApprovalConfigVO> tsApprovalConfigVOPagingVO = tsApprovalConfigDAO.queryPaging(query);
        if (tsApprovalConfigVOPagingVO.getTotal() > 0) {
            tsApprovalConfigVOPagingVO.getRecords().forEach(this::translateData);
        }
        return tsApprovalConfigVOPagingVO;
    }

    /**
     * 数据翻译
     *
     * @param vo
     */
    void translateData(TsApprovalConfigVO vo) {
        if (vo == null) {
            return;
        }
        //审批节点1
        if (StringUtils.hasText(vo.getApprovalType1()) && StringUtils.hasText(vo.getApprovalSource1())) {
            if ("1".equals(vo.getApprovalType1()) && vo.getApprovalSource1() != null) {
                //指定业务角色
                TsEnum.TsBussinessRole tsBussinessRole = TsEnum.TsBussinessRole.valueOf(vo.getApprovalSource1());
                vo.setApprovalSource1Desc(tsBussinessRole.getDesc());
            } else {
                //指定人
                vo.setApprovalSource1Desc(cacheUtil.getUserName(Long.valueOf(vo.getApprovalSource1())));
            }
        }
        //审批节点2
        if (StringUtils.hasText(vo.getApprovalType2()) && StringUtils.hasText(vo.getApprovalSource2())) {
            if ("1".equals(vo.getApprovalType2()) && vo.getApprovalSource2() != null) {
                //指定业务角色
                TsEnum.TsBussinessRole tsBussinessRole = TsEnum.TsBussinessRole.valueOf(vo.getApprovalSource2());
                vo.setApprovalSource2Desc(tsBussinessRole.getDesc());
            } else {
                //指定人
                vo.setApprovalSource2Desc(cacheUtil.getUserName(Long.valueOf(vo.getApprovalSource2())));
            }
        }
        //审批节点3
        if (StringUtils.hasText(vo.getApprovalType3()) && StringUtils.hasText(vo.getApprovalSource3())) {
            if ("1".equals(vo.getApprovalType3()) && vo.getApprovalSource3() != null) {
                //指定业务角色
                TsEnum.TsBussinessRole tsBussinessRole = TsEnum.TsBussinessRole.valueOf(vo.getApprovalSource3());
                vo.setApprovalSource3Desc(tsBussinessRole.getDesc());
            } else {
                //指定人
                vo.setApprovalSource3Desc(cacheUtil.getUserName(Long.valueOf(vo.getApprovalSource3())));
            }
        }

        if (StringUtils.hasText(vo.getWorkType())) {
            PrdSystemSelectionVO systemSelection = cacheUtil.getSystemSelection("salecon:work_type");
            List<PrdSystemSelectionVO> selectionChildren = systemSelection.getChildren();
            // 翻译工作类型
            List<String> workTypes = new ArrayList<>();
            for (String activity : vo.getWorkType().split(",")) {
                for (PrdSystemSelectionVO selectionChild : selectionChildren) {
                    if (selectionChild.getSelectionValue().equals(activity)) {
                        workTypes.add(selectionChild.getSelectionName());
                    }
                }
            }
            String workTypeDesc = String.join(",", workTypes);
            vo.setWorkTypeDesc(workTypeDesc);
        }
    }

    @Override
    public List<TsApprovalConfigVO> queryListDynamic(TsApprovalConfigQuery query) {
        List<TsApprovalConfigVO> tsApprovalConfigVOS = tsApprovalConfigDAO.queryListDynamic(query);
        tsApprovalConfigVOS.forEach(this::translateData);
        return tsApprovalConfigVOS;
    }

    @Override
    public TsApprovalConfigVO queryByKey(Long key) {
        TsApprovalConfigVO tsApprovalConfigVO = tsApprovalConfigDAO.queryByKey(key);
        translateData(tsApprovalConfigVO);
        return tsApprovalConfigVO;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public TsApprovalConfigVO insert(TsApprovalConfigPayload payload) {
        TsApprovalConfigDO entityDo = TsApprovalConfigConvert.INSTANCE.toDo(payload);
        return TsApprovalConfigConvert.INSTANCE.toVo(tsApprovalConfigRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public TsApprovalConfigVO update(TsApprovalConfigPayload payload) {
        TsApprovalConfigDO entity = tsApprovalConfigRepo.findById(payload.getId()).orElseGet(TsApprovalConfigDO::new);
        Assert.notNull(entity.getId(), "不存在");
        TsApprovalConfigDO entityDo = TsApprovalConfigConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return TsApprovalConfigConvert.INSTANCE.toVo(tsApprovalConfigRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(TsApprovalConfigPayload payload) {
        TsApprovalConfigDO entity = tsApprovalConfigRepo.findById(payload.getId()).orElseGet(TsApprovalConfigDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = tsApprovalConfigDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            tsApprovalConfigDAO.deleteSoft(keys);
        }
    }

    @Override
    public List<TsApprovalResPayload> queryApprovalRes(Long taskPackageId, Integer finYear) {
        if (taskPackageId == null) {
            throw TwException.error("", "任务包id不可为空");
        }
        if (finYear == null) {
            finYear = LocalDate.now().getYear();
        }
        TaskPackageVO taskPackageVO = taskPackageService.queryByKey(taskPackageId, false);
        if (taskPackageVO == null) {
            throw TwException.error("", "任务包不存在");
        }
        TsApprovalRoleResVO roleResVO = new TsApprovalRoleResVO();

        TsApprovalConfigQuery query = new TsApprovalConfigQuery();
        query.setStatusFlag(1);
        query.setFinYear(finYear);
        query.setReasonType(taskPackageVO.getReasonType());
        PrdOrgEmployeeVO employee = cacheUtil.getEmployee(taskPackageVO.getReceiverResId());
        query.setResType(employee.getExtString6());//内外部资源
        if (taskPackageVO.getReasonType().equals(PmsReasonTypeEnum.PROJ_CONTRACT.getCode())) {
            //合同项目任务包
            PmsProjectVO pmsProjectVO = pmsProjectService.queryByKey(taskPackageVO.getReasonId());
            if (pmsProjectVO == null) {
                throw TwException.error("", "所选项目不存在");
            }
            query.setWorkType(pmsProjectVO.getWorkType());
            query.setCostLevel(pmsProjectVO.getCostLevel());
            query.setDeliBuId(pmsProjectVO.getDeliBuId());
            query.setBudgetType("1");
            //预算类型为风险等级
            String riskLevel = budgetService.queryBudgetRiskLevel(taskPackageVO.getReasonId(), PmsReasonTypeEnum.PROJ_CONTRACT.getCode(), pmsProjectVO.getContractId());
            query.setBudgetData(riskLevel);
            // 预算类型为百分比的
            BudgetCommonVO commonVO = new BudgetCommonVO();
            commonVO.setReasonId(taskPackageVO.getReasonId());
            commonVO.setReasonType(PmsReasonTypeEnum.PROJ_CONTRACT.getCode());
            budgetCommonService.queryBudgetEqva(commonVO, null);

            BigDecimal totalEqva = commonVO.getUsedEqva().add(commonVO.getOccupyEqva());
            if (pmsProjectVO.getTotalEqva() != null && pmsProjectVO.getTotalEqva().compareTo(BigDecimal.ZERO) > 0) {
                BigDecimal divide = totalEqva.multiply(BigDecimal.valueOf(100)).divide(pmsProjectVO.getTotalEqva(), 2, RoundingMode.HALF_UP);
                query.setBudgetData0(divide);
            } else {
                query.setBudgetData0(BigDecimal.ZERO);
            }
            //初始化数据
            roleResVO.setApprovalResId1(pmsProjectVO.getPmResId());//项目经理
            roleResVO.setApprovalResId2(pmsProjectVO.getDeliUserId());//交付负责人
            PrdOrgOrganizationVO org = cacheUtil.getOrg(pmsProjectVO.getDeliBuId());//交付BU
            roleResVO.setApprovalResId3(org.getManageId());//交付BU Leader
            PrdOrgOrganizationRefVO buLevel1 = cacheUtil.getBULevel1ByOrgId(pmsProjectVO.getDeliBuId());
            if (buLevel1 != null) {
                roleResVO.setApprovalResId4(buLevel1.getManageId());//交付BU 事业部Leader
            }
        }
        if (taskPackageVO.getReasonType().equals(PmsReasonTypeEnum.PROJ_OPPO.getCode())) {
            CrmOpportunityQuery crmOpportunityQuery = new CrmOpportunityQuery();
            crmOpportunityQuery.setProjectId(taskPackageVO.getReasonId());
            List<CrmOpportunityListVO> crmOpportunityListVOS = opportunityService.queryListDynamic(crmOpportunityQuery);
            if (ObjectUtils.isEmpty(crmOpportunityListVOS)) {
                throw TwException.error("", "项目不存在，请核验！");
            }
            CrmOpportunityListVO crmOpportunityListVO = crmOpportunityListVOS.get(0);

            query.setCostLevel("COST_LEVEL_3");
            query.setDeliBuId(crmOpportunityListVO.getDeliOrgId());
            //初始化数据
            roleResVO.setApprovalResId2(crmOpportunityListVO.getDeliUserId());//交付负责人
            roleResVO.setApprovalResId7(crmOpportunityListVO.getManageUserId());//签单负责人
            roleResVO.setApprovalResId8(crmOpportunityListVO.getPreSaleUserId());//售前负责人

            PrdOrgOrganizationVO org0 = cacheUtil.getOrg(crmOpportunityListVO.getOrgId());//签单BU
            if (org0 != null) {
                roleResVO.setApprovalResId9(org0.getManageId());//签单BU Leader
                PrdOrgOrganizationRefVO buLevel1 = cacheUtil.getBULevel1ByOrgId(crmOpportunityListVO.getOrgId());
                if (buLevel1 != null) {
                    roleResVO.setApprovalResId11(buLevel1.getManageId());//签单BU 事业部Leader
                }
            }
            PrdOrgOrganizationVO org1 = cacheUtil.getOrg(crmOpportunityListVO.getDeliOrgId());//交付BU
            if (org1 != null) {
                roleResVO.setApprovalResId3(org1.getManageId());//交付BU Leader
                PrdOrgOrganizationRefVO buLevel1 = cacheUtil.getBULevel1ByOrgId(crmOpportunityListVO.getDeliOrgId());
                if (buLevel1 != null) {
                    roleResVO.setApprovalResId4(buLevel1.getManageId());//交付BU 事业部Leader
                }
            }
            PrdOrgOrganizationVO org2 = cacheUtil.getOrg(crmOpportunityListVO.getPreSaleOrgId());//售前BU
            if (org2 != null) {
                roleResVO.setApprovalResId10(org2.getManageId());//售前BU Leader
                PrdOrgOrganizationRefVO buLevel1 = cacheUtil.getBULevel1ByOrgId(crmOpportunityListVO.getPreSaleOrgId());
                if (buLevel1 != null) {
                    roleResVO.setApprovalResId12(buLevel1.getManageId());//售前BU 事业部Leader
                }
            }

        }
        if (taskPackageVO.getReasonType().equals(PmsReasonTypeEnum.PROJ_BU.getCode())) {
            BuProjectVO buProjectVO = buProjectService.queryByKey(taskPackageVO.getReasonId());
            if (ObjectUtils.isEmpty(buProjectVO)) {
                throw TwException.error("", "所选BU项目不存在");
            }
            query.setCostLevel("COST_LEVEL_3");
            query.setDeliBuId(buProjectVO.getDeliBuId());

            roleResVO.setApprovalResId1(buProjectVO.getPmResId());//项目经理
            roleResVO.setApprovalResId2(buProjectVO.getDeliUserId());//交付负责人
            PrdOrgOrganizationVO org = cacheUtil.getOrg(buProjectVO.getDeliBuId());//
            roleResVO.setApprovalResId3(org.getManageId());//交付BU Leader
            PrdOrgOrganizationRefVO buLevel1 = cacheUtil.getBULevel1ByOrgId(buProjectVO.getDeliBuId());
            if (buLevel1 != null) {
                roleResVO.setApprovalResId4(buLevel1.getManageId());//交付BU 事业部Leader
            }
        }
        //获取审批配置
        TsApprovalConfigVO tsApprovalConfig = tsApprovalConfigDAO.getTsApprovalConfig(query);
        if (ObjectUtils.isEmpty(tsApprovalConfig)) {
            throw TwException.error("", "匹配不到工时审批配置，无法获取到审批人！");
        }
//        udcUtil.translate(tsApprovalConfig);
        List<TsApprovalResPayload> resPayloads = getApprovalResPayload(tsApprovalConfig, roleResVO);

        return resPayloads;
    }

    List<TsApprovalResPayload> getApprovalResPayload(TsApprovalConfigVO tsApprovalConfig, TsApprovalRoleResVO roleResVO) {
        List<TsApprovalResPayload> resPayloads = new ArrayList<>();

        if (tsApprovalConfig != null) {
            log.info("tsApprovalConfigId:{}", tsApprovalConfig.getId());
            log.info("tsApprovalConfig:{}", tsApprovalConfig);

            List<Long> appResIds = new ArrayList<>();
            if (StringUtils.hasText(tsApprovalConfig.getApprovalType1()) && StringUtils.hasText(tsApprovalConfig.getApprovalSource1())) {
                //指定角色
                TsApprovalResPayload resPayload = new TsApprovalResPayload();
                resPayload.setConfigType("TASK");
                resPayload.setConfigId(tsApprovalConfig.getId());
                resPayload.setApprovalStatus(APPROVING.getCode());
                resPayload.setSortIndex(1);
                resPayload.setLastFlag(0);
                if ("1".equals(tsApprovalConfig.getApprovalType1())) {
                    initApproalRes(resPayload, roleResVO, tsApprovalConfig.getApprovalSource1());
                    String systemSelectionNameByValue = cacheUtil.getSystemSelectionNameByValue("prd:timesheet:business_role", tsApprovalConfig.getApprovalSource1());
                    resPayload.setApprovalSource(systemSelectionNameByValue);
                }
                if ("2".equals(tsApprovalConfig.getApprovalType1())) {
                    //指定人
                    resPayload.setApprovalResId(Long.valueOf(tsApprovalConfig.getApprovalSource1()));
                }
                resPayloads.add(resPayload);

                appResIds.add(resPayload.getApprovalResId());
            } else {
                throw TwException.error("", "获取审批配置节点1错误,配置id:" + tsApprovalConfig.getId());
            }
            if (StringUtils.hasText(tsApprovalConfig.getApprovalType2()) && StringUtils.hasText(tsApprovalConfig.getApprovalSource2())) {
                //指定角色
                TsApprovalResPayload resPayload = new TsApprovalResPayload();
                resPayload.setConfigId(tsApprovalConfig.getId());
                resPayload.setApprovalStatus(BEFOREAPPROVE.getCode());
                resPayload.setSortIndex(resPayloads.size() + 1);
                resPayload.setLastFlag(0);
//                if (StringUtils.hasText(tsApprovalConfig.getApprovalType3()) && StringUtils.hasText(tsApprovalConfig.getApprovalSource3())) {
//                    resPayload.setLastFlag(0);
//                } else {
//                    resPayload.setLastFlag(1);
//                }

                if ("1".equals(tsApprovalConfig.getApprovalType2())) {
                    initApproalRes(resPayload, roleResVO, tsApprovalConfig.getApprovalSource2());
                    String systemSelectionNameByValue = cacheUtil.getSystemSelectionNameByValue("prd:timesheet:business_role", tsApprovalConfig.getApprovalSource2());
                    resPayload.setApprovalSource(systemSelectionNameByValue);
                }
                if ("2".equals(tsApprovalConfig.getApprovalType2())) {
                    //指定人
                    resPayload.setApprovalResId(Long.valueOf(tsApprovalConfig.getApprovalSource2()));
                }
                if (!appResIds.contains(resPayload.getApprovalResId())) {
                    //人员不重复添加
                    resPayloads.add(resPayload);
                    appResIds.add(resPayload.getApprovalResId());
                }

            } else {
                throw TwException.error("", "获取审批配置节点2错误,配置id:" + tsApprovalConfig.getId());
            }
            if (StringUtils.hasText(tsApprovalConfig.getApprovalType3()) && StringUtils.hasText(tsApprovalConfig.getApprovalSource3())) {
                //指定角色
                TsApprovalResPayload resPayload = new TsApprovalResPayload();
                resPayload.setConfigId(tsApprovalConfig.getId());
                resPayload.setApprovalStatus(BEFOREAPPROVE.getCode());
                resPayload.setSortIndex(resPayloads.size() + 1);
                resPayload.setLastFlag(1);
                if ("1".equals(tsApprovalConfig.getApprovalType3())) {
                    //
                    initApproalRes(resPayload, roleResVO, tsApprovalConfig.getApprovalSource3());
                    String systemSelectionNameByValue = cacheUtil.getSystemSelectionNameByValue("prd:timesheet:business_role", tsApprovalConfig.getApprovalSource3());
                    resPayload.setApprovalSource(systemSelectionNameByValue);
                }
                if ("2".equals(tsApprovalConfig.getApprovalType3())) {
                    //指定人
                    resPayload.setApprovalResId(Long.valueOf(tsApprovalConfig.getApprovalSource3()));
                }
                if (!appResIds.contains(resPayload.getApprovalResId())) {
                    //人员不重复添加
                    resPayloads.add(resPayload);
                    appResIds.add(resPayload.getApprovalResId());
                }
            }
        } else {
            throw TwException.error("", "匹配不到工时审批配置，无法获取到审批人！");
        }
        //取最后一个节点赋值
        TsApprovalResPayload resPayload = resPayloads.stream().reduce((first, second) -> second).orElse(null);
        resPayload.setLastFlag(1);

        return resPayloads;
    }

    /**
     * 根据角色获取审批人
     *
     * @param resPayload
     * @param roleResVO
     */

//   n
    void initApproalRes(TsApprovalResPayload resPayload, TsApprovalRoleResVO roleResVO, String approvalSource) {
        TsEnum.TsBussinessRole tsBussinessRole = TsEnum.TsBussinessRole.valueOf(approvalSource);
        switch (tsBussinessRole) {
            case business_role1:
                resPayload.setApprovalResId(roleResVO.getApprovalResId1());
                break;
            case business_role2:
                resPayload.setApprovalResId(roleResVO.getApprovalResId2());
                break;
            case business_role3:
                resPayload.setApprovalResId(roleResVO.getApprovalResId3());
                break;
            case business_role4:
                resPayload.setApprovalResId(roleResVO.getApprovalResId4());
                break;
            case business_role5:
                resPayload.setApprovalResId(roleResVO.getApprovalResId5());
                break;
            case business_role6:
                resPayload.setApprovalResId(roleResVO.getApprovalResId6());
                break;
            case business_role7:
                resPayload.setApprovalResId(roleResVO.getApprovalResId7());
                break;
            case business_role8:
                resPayload.setApprovalResId(roleResVO.getApprovalResId8());
                break;
            case business_role9:
                resPayload.setApprovalResId(roleResVO.getApprovalResId9());
                break;
            case business_role10:
                resPayload.setApprovalResId(roleResVO.getApprovalResId10());
                break;
            case business_role11:
                resPayload.setApprovalResId(roleResVO.getApprovalResId11());
                break;
            case business_role12:
                resPayload.setApprovalResId(roleResVO.getApprovalResId12());
                break;
        }

    }

}
