package com.elitesland.tw.tw5.server.prd.workflow;

import com.elitesland.tw.tw5.api.prd.salecon.payload.ConReceivablePlanConfirmPayload;
import com.elitesland.tw.tw5.api.prd.salecon.payload.ConRecvplanChangeLogPayload;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConReceivablePlanConfirmService;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConReceivablePlanService;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConReceivablePlanConfirmVO;
import com.elitesland.tw.tw5.server.prd.salecon.dao.ConReceivablePlanConfirmDAO;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.WorkflowConstant;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;

/**
 * 销售子合同激活流程
 *
 * @author likunpeng
 * @date 2023/5/5
 */
@Slf4j
@RestController
@RequestMapping(WorkflowConstant.WORKFLOW + "CON_PROMPT" + WorkflowConstant.CALLBACK)
@Transactional
@RequiredArgsConstructor
public class ConRecePlanConfirmWorkflowCallBackController implements WorkflowCallBack {

    private final ConReceivablePlanConfirmService service;

    private final ConReceivablePlanConfirmDAO dao;
    private final ConReceivablePlanService conReceivablePlanService;
    /**
     * 动态指定任务负责人
     *
     * @return 任务负责人ID列表
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_ASSIGNEE_PATH)
    public WorkflowResult<ArrayList<String>> taskAssignee(TaskAssigneePayload payload) {
        return WorkflowResult.success(null);
    }

    /**
     * 任务创建回调
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_CREATED_PATH)
    public WorkflowResult<Void> taskCreated(@RequestBody TaskCreatedPayload payload) {
        log.info("任务创建后回调参数: {}", payload);
        return WorkflowResult.success(null);
    }

    /**
     * 任务完成回调(只有正常推下一个节点,才算任务完成,其他从当前任务撤回/驳回都能不算当前任务完成,不会触发下面回调)
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_COMPLETED_PATH)
    public WorkflowResult<Void> taskCompleted(@RequestBody TaskCompletedPayload payload) {
        log.info("任务完成后回调参数: {}", payload);
        return WorkflowResult.success(null);
    }

    /**
     * 流程状态变化回调
     */
    @Override
    @PostMapping(WorkflowConstant.PROCESS_STATUS_CHANGE_PATH)
    public WorkflowResult<Void> processStatusChange(@RequestBody ProcessStatusChangePayload payload) {
        log.info("流程状态变化回调参数:{}", payload);
        String businessKey = payload.getBusinessKey();
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        ConReceivablePlanConfirmPayload receivablePlanConfirmPayload = new ConReceivablePlanConfirmPayload();
        receivablePlanConfirmPayload.setId(Long.parseLong(businessKey));
        //根据业务key查询当前业务对象
        ConReceivablePlanConfirmVO conReceivablePlanConfirmVO = service.queryByKey(Long.valueOf(businessKey));
        if (conReceivablePlanConfirmVO != null) {
            switch (procInstStatus) {
                case NOTSUBMIT://创建人提交节点
                    //一般情况将单据状态变成"新建",流程状态改为未提交
                    //将单据状态改为“激活”
                    receivablePlanConfirmPayload.setProcInstStatus(ProcInstStatus.NOTSUBMIT);
                    break;
                case INTERRUPT://中断（删除工作流，初始化单据，管理员操作）
                    //一般情况将单据状态变成"新建",并且将单据上的"流程实例状态"，"流程实例ID"清成null
                    //将单据状态变为“激活”
                    receivablePlanConfirmPayload.setNullFields(Arrays.asList("procInstStatus", "procInstId", "submitTime"));
                    break;
                case INVALID://先删除流程再删除单据
                    receivablePlanConfirmPayload.setDeleteFlag(1);
                    receivablePlanConfirmPayload.setProcInstStatus(ProcInstStatus.INVALID);
                    break;
                case REJECTED://审批人拒绝，回到第一个节点
                    //将单据状态变为新建状态
                    receivablePlanConfirmPayload.setProcInstStatus(ProcInstStatus.REJECTED);
                    break;
                case APPROVED:
                    //一般情况将单据状态变成"激活"
                    receivablePlanConfirmPayload.setProcInstStatus(ProcInstStatus.APPROVED);
                    receivablePlanConfirmPayload.setApprovedTime(LocalDateTime.now());
                    finish(conReceivablePlanConfirmVO);
                    break;
                case APPROVING:
                    receivablePlanConfirmPayload.setProcInstStatus(ProcInstStatus.APPROVING);
            }
            dao.updateByKeyDynamic(receivablePlanConfirmPayload);
        }
        return WorkflowResult.success(null);
    }

    private void finish(ConReceivablePlanConfirmVO view) {
        if ((view.getFinanceConfirm() != null && view.getFinanceConfirm() == 1) || (view.getReceDateConfirm() != null && view.getReceDateConfirm() ==1)) {
            log.debug("已付款需财务确认");
            log.debug("预计收款日期无误");
        }else{
            // 流程走完 记录变革记录 并 变更收款计划
            ConRecvplanChangeLogPayload logEntity = new ConRecvplanChangeLogPayload();
            logEntity.setRcvpConfirmId(view.getId());
            logEntity.setFlag1(view.getSendPaymentRequest()==1?true:false);
            logEntity.setRecvplanId(view.getRecePlanId());
            logEntity.setOldRecvOrInvDate(view.getExpectReceDate());
            logEntity.setRecvOrInvDate(view.getAdjExpectReceDate());
            logEntity.setType("RECV");
            logEntity.setApplyUserId(view.getApplyUserId());
            if (null != view.getPmConfirm() && view.getPmConfirm()==1) {
                logEntity.setReason(view.getPmRemark());
            } else {
                logEntity.setReason(view.getSalesRemark());
            }
            conReceivablePlanService.updateRecvOrInvDate(logEntity);
        }
    }
}
