package com.elitesland.tw.tw5.server.yeedoc.service;

import com.elitescloud.cloudt.system.vo.SysUserDTO;

import java.util.List;
import java.util.Map;

/**
 * yeedoc服务
 *
 * @author
 */
public interface YeedocService {

    /**
     * 创建文件夹
     *
     * @param map 地图
     * @return {@link String}
     */
    String createFolder(Map<String, Object> map);

    /**
     * 创建文件夹
     * @param map
     */
    String createFolder(Map<String, Object> map, String authToken);

    /**
     * 重命名文件夹
     *
     * see String reNameFolder(Map<String, Object> map);
     * @param map
     * @param authToken
     * @return
     */
    @Deprecated
    String reNameFolder(Map<String, Object> map, String authToken);


    /**
     * 重命名文件夹
     *
     * @param map 地图
     * @return {@link String}
     */
    String reNameFolder(Map<String, Object> map);

    /**
     * @param map 上传文件或文件夹的最终保存
     * @param authToken
     * @return
     */
    String newUploadFilesSave(Map<String, Object> map, String authToken);

    /**
     * @param map 获取上传的附件Id
     * @param authToken
     * @return
     */
    String getCaCheKeyItemId (Map<String, Object> map, String authToken);

    /**
     * 设置权限 在易道壳赋权
     *
     * @param itemId        项目id
     * @param permissionIds 权限ID
     * @return {@link String}
     */
    String setPermission(String itemId, List<String> permissionIds);

    /**
     * 获取文件链接uri
     * see  String preViewItemPro(String itemId);
     *
     * @param itemId 项id
     * @return {@link String}
     */
    @Deprecated
    String preViewItem(String itemId);

    /**
     * 获取易稻壳文件夹链接uri
     *
     * @param itemId 项目id
     * @return {@link String}
     */
    String preViewItemPro(String itemId);

    /**
     * 删除项目
     *
     * @param itemId 项id
     * @return {@link String}
     */
    String deleteItem(String itemId);

    String deleteItem(String itemId, String authToken);

    /**
     * 通过用户信息生成易稻壳的jwt
     *
     * @param  loginUser
     */
    String getYeedocJwt(SysUserDTO loginUser);

    /**
     * 获取当前登录人的易稻壳的jwt
     *
     */
    String getYeedocJwt();
}
