/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.common.util;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import com.elitesland.tw.tw5.api.common.annotation.FieldCreateLog;
import com.elitesland.tw.tw5.api.common.annotation.FieldUpdateLog;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemTagVO;
import com.elitesland.tw.tw5.server.common.util.BeanUtil;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.FunctionSelectionEnum;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmOffshoreDAO;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmOpenseaDAO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmOffshoreDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmOpenseaDO;
import com.elitesland.tw.tw5.server.udc.UdcTypeEnum;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Component
public class ChangeFieldLogUtil {
    private static final Logger log = LoggerFactory.getLogger(ChangeFieldLogUtil.class);
    private final CacheUtil cacheUtil;
    private final CrmOpenseaDAO openseaDAO;
    private final CrmOffshoreDAO offshoreDAO;

    public <T> String getFieldsUpdateLog(T newBean, T oldBean) {
        Field[] fields = newBean.getClass().getDeclaredFields();
        StringBuilder builder = new StringBuilder();
        for (Field field : fields) {
            field.setAccessible(true);
            if (!field.isAnnotationPresent(FieldUpdateLog.class)) continue;
            try {
                String selectionKey = field.getAnnotation(FieldUpdateLog.class).selectionKey();
                String changeAction = field.getAnnotation(FieldUpdateLog.class).changeAction();
                Object newValue = field.get(newBean);
                Object oldValue = field.get(oldBean);
                if (null == newValue) continue;
                newValue = ObjectUtils.isEmpty((Object)newValue) ? "\u7a7a" : this.translation(selectionKey, newValue);
                oldValue = ObjectUtils.isEmpty((Object)oldValue) ? "\u7a7a" : this.translation(selectionKey, oldValue);
                Boolean isEq = false;
                if (newValue instanceof Number && oldValue instanceof Number) {
                    Number newValue1 = (Number)newValue;
                    Number newValue2 = (Number)oldValue;
                    if (newValue1.doubleValue() == newValue2.doubleValue()) {
                        isEq = true;
                    }
                }
                if (isEq.booleanValue() || Objects.equals(newValue, oldValue) || StringUtils.hasText((String)field.getAnnotation(FieldUpdateLog.class).fieldObject())) continue;
                if (StringUtils.hasText((String)field.getAnnotation(FieldUpdateLog.class).objectNameField())) {
                    builder.append(BeanUtil.getAllFieldValueByFieldName(field.getAnnotation(FieldUpdateLog.class).objectNameField(), oldBean));
                } else {
                    builder.append(field.getAnnotation(FieldUpdateLog.class).fieldName());
                }
                builder.append(" \u7531 ");
                builder.append(oldValue);
                builder.append((String)(changeAction == null ? " \u4fee\u6539\u4e3a " : " " + changeAction + " "));
                builder.append(newValue);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return builder.toString();
    }

    public <T> String getFieldsCreateLog(T newBean) {
        return this.getFieldsCreateLog(newBean, null);
    }

    public <T> String getFieldsCreateLog(T newBean, String content) {
        Field[] fields = newBean.getClass().getDeclaredFields();
        StringBuilder builder = new StringBuilder();
        for (Field field : fields) {
            field.setAccessible(true);
            if (!field.isAnnotationPresent(FieldCreateLog.class)) continue;
            try {
                Object newValue = field.get(newBean);
                if (null == newValue || ObjectUtils.isEmpty((Object)newValue)) continue;
                String selectionKey = field.getAnnotation(FieldCreateLog.class).selectionKey();
                if (StringUtils.hasText((String)field.getAnnotation(FieldCreateLog.class).fieldObject())) continue;
                newValue = this.translation(selectionKey, newValue);
                builder.append(field.getAnnotation(FieldCreateLog.class).fieldName());
                if (!StringUtils.hasText((String)content)) {
                    content = "\u521b\u5efa\u4e3a";
                }
                builder.append(" " + content + " ");
                builder.append(newValue);
                builder.append("\n");
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return builder.toString();
    }

    public StringBuilder nullFieldsProcess(TwCommonPayload payload, BaseModel entityDb, BaseModel entity) {
        StringBuilder builder = new StringBuilder();
        List nullFields = payload.getNullFields();
        Class<?> cClass = entity.getClass();
        Class<?> cClassReq = payload.getClass();
        Class<?> cClassDbDO = entityDb.getClass();
        if (!CollectionUtils.isEmpty((Collection)nullFields)) {
            nullFields.forEach(s -> {
                block5: {
                    try {
                        Field field = cClass.getDeclaredField((String)s);
                        Field fReq = cClassReq.getDeclaredField((String)s);
                        Field fDbDO = cClassDbDO.getDeclaredField((String)s);
                        field.setAccessible(true);
                        fReq.setAccessible(true);
                        fDbDO.setAccessible(true);
                        field.set(entity, null);
                        fReq.set(payload, null);
                        Object oldValue = fDbDO.get(entityDb);
                        fDbDO.set(entityDb, null);
                        if (!field.isAnnotationPresent(FieldUpdateLog.class)) break block5;
                        try {
                            String selectionKey = field.getAnnotation(FieldUpdateLog.class).selectionKey();
                            String changeAction = field.getAnnotation(FieldUpdateLog.class).changeAction();
                            String newValue = "\u7a7a";
                            oldValue = ObjectUtils.isEmpty((Object)oldValue) ? "\u7a7a" : this.translation(selectionKey, oldValue);
                            if (!Objects.equals(newValue, oldValue)) {
                                builder.append(field.getAnnotation(FieldUpdateLog.class).fieldName());
                                builder.append(" \u7531 ");
                                builder.append(oldValue);
                                builder.append((String)(changeAction == null ? " \u4fee\u6539\u4e3a " : " " + changeAction + " "));
                                builder.append((Object)newValue);
                            }
                        }
                        catch (Exception e) {
                            log.error(e.getMessage(), (Throwable)e);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        return builder;
    }

    public <T> Object translation(String selectionKey, Object value) {
        if (StringUtils.hasText((String)selectionKey)) {
            if (selectionKey.equals(UdcTypeEnum.USER.getCode())) {
                value = this.cacheUtil.getUserName(Long.valueOf(value.toString()));
            } else if (selectionKey.equals(UdcTypeEnum.BU.getCode())) {
                value = this.cacheUtil.getOrgName(Long.valueOf(value.toString()));
            } else if (selectionKey.equals(UdcTypeEnum.OPENSEA.getCode())) {
                CrmOpenseaDO openseaDO = this.openseaDAO.queryById(Long.valueOf(BeanUtil.getAllFieldValueByFieldName("id", value).toString()));
                value = openseaDO == null ? null : openseaDO.getOpenseaName();
            } else if (selectionKey.equals(UdcTypeEnum.OFFSHORE.getCode())) {
                CrmOffshoreDO offshoreDO = this.offshoreDAO.queryById(Long.valueOf(BeanUtil.getAllFieldValueByFieldName("id", value).toString()));
                value = offshoreDO == null ? null : offshoreDO.getOffshoreName();
            } else {
                switch (selectionKey) {
                    case "crm:leads_channel": {
                        value = this.transferMarketChannel(value.toString());
                        break;
                    }
                    case "crm:tags": {
                        value = this.transferTags(value.toString());
                        break;
                    }
                    default: {
                        value = this.cacheUtil.transferSystemSelection(selectionKey, value.toString());
                    }
                }
            }
        }
        return value;
    }

    private Object transferTags(String tagIds) {
        if (tagIds != null) {
            String[] tags;
            ArrayList<String> tagList = new ArrayList<String>();
            for (String tag : tags = tagIds.split(",")) {
                List<PrdSystemTagVO> systemTags = this.cacheUtil.getSystemTag(Long.parseLong(tag));
                for (PrdSystemTagVO systemTag : systemTags) {
                    tagList.add(systemTag.getTagName());
                }
            }
            return String.join((CharSequence)",", tagList);
        }
        return null;
    }

    private Object transferMarketChannel(String marketChannel) {
        if (marketChannel != null) {
            String[] split = marketChannel.split(",");
            if (split.length < 2) {
                return this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsChannel.getCode(), split[0]);
            }
            String s1 = this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsChannel.getCode(), split[0]);
            String s2 = "";
            switch (split[0]) {
                case "baidu": {
                    s2 = this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsChannelBaidu.getCode(), split[1]);
                    break;
                }
                case "sem_360": {
                    s2 = this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsChannel360.getCode(), split[1]);
                    break;
                }
                case "offline_activity": {
                    s2 = this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsChannelOfflineActivity.getCode(), split[1]);
                    break;
                }
                case "thrid_party_data": {
                    s2 = this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsChannelThirdPartyData.getCode(), split[1]);
                }
            }
            return s2.equals("") ? s1 : s1 + "/" + s2;
        }
        return null;
    }

    public ChangeFieldLogUtil(CacheUtil cacheUtil, CrmOpenseaDAO openseaDAO, CrmOffshoreDAO offshoreDAO) {
        this.cacheUtil = cacheUtil;
        this.openseaDAO = openseaDAO;
        this.offshoreDAO = offshoreDAO;
    }
}

